/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.nms.v1_15_R1.advancement;

import com.fren_gor.ultimateAdvancementAPI.nms.v1_15_R1.Util;
import com.fren_gor.ultimateAdvancementAPI.nms.v1_15_R1.advancement.AdvancementWrapper_v1_15_R1;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.MinecraftKeyWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementWrapper;
import com.google.common.base.Preconditions;
import java.util.Map;
import net.minecraft.server.v1_15_R1.Criterion;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class PreparedAdvancementWrapper_v1_15_R1
extends PreparedAdvancementWrapper {
    private final MinecraftKeyWrapper key;
    private final PreparedAdvancementWrapper parent;
    private final Map<String, Criterion> advCriteria;
    private final String[][] advRequirements;

    public PreparedAdvancementWrapper_v1_15_R1(@NotNull MinecraftKeyWrapper key, @Nullable PreparedAdvancementWrapper parent, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) {
        this.key = key;
        this.parent = parent;
        this.advCriteria = Util.getAdvancementCriteria(maxProgression);
        this.advRequirements = Util.getAdvancementRequirements(this.advCriteria);
    }

    protected PreparedAdvancementWrapper_v1_15_R1(@NotNull MinecraftKeyWrapper key, @Nullable PreparedAdvancementWrapper parent, @NotNull Map<String, Criterion> advCriteria, @NotNull String[][] advRequirements) {
        this.key = key;
        this.parent = parent;
        this.advCriteria = advCriteria;
        this.advRequirements = advRequirements;
    }

    @Override
    @NotNull
    public MinecraftKeyWrapper getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public PreparedAdvancementWrapper getParent() {
        return this.parent;
    }

    @Override
    public @Range(from=1L, to=0x7FFFFFFFL) int getMaxProgression() {
        return this.advRequirements.length;
    }

    @Override
    @NotNull
    public AdvancementWrapper toAdvancementWrapper(@NotNull AdvancementDisplayWrapper display) {
        Preconditions.checkNotNull((Object)display, (Object)"AdvancementDisplayWrapper is null.");
        if (this.parent == null) {
            return new AdvancementWrapper_v1_15_R1(this.key, display, this.advCriteria, this.advRequirements);
        }
        return new AdvancementWrapper_v1_15_R1(this.key, this.parent, display, this.advCriteria, this.advRequirements);
    }

    @Override
    @NotNull
    @Contract(value="_ -> new")
    public PreparedAdvancementWrapper withParent(@Nullable PreparedAdvancementWrapper parent) {
        return new PreparedAdvancementWrapper_v1_15_R1(this.key, parent, this.advCriteria, this.advRequirements);
    }
}

