/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.nms.util;

import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.AbstractWrapper;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class ListSet<E>
extends AbstractSet<E>
implements Set<E> {
    private final E[] elements;
    private final int size;

    public ListSet(@NotNull Set<E> elements) {
        Preconditions.checkNotNull(elements, (Object)"Set is null.");
        Object[] array = new Object[elements.size()];
        int i = 0;
        for (E e : elements) {
            if (e == null) continue;
            array[i++] = e;
        }
        this.elements = array;
        this.size = i;
    }

    private ListSet(@NotNull E[] elements, @Range(from=0L, to=0x7FFFFFFFL) int size) {
        this.elements = elements;
        this.size = size;
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T extends AbstractWrapper> ListSet<?> fromWrapperSet(@NotNull Set<T> elements) {
        Preconditions.checkNotNull(elements, (Object)"Set is null.");
        Object[] array = new Object[elements.size()];
        int i = 0;
        for (AbstractWrapper t : elements) {
            Object nms;
            if (t == null || (nms = t.toNMS()) == null) continue;
            array[i++] = nms;
        }
        return new ListSet<Object>(array, i);
    }

    @Override
    @NotNull
    public E[] toArray() {
        Object[] array = new Object[this.size];
        System.arraycopy(this.elements, 0, array, 0, this.size);
        return array;
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] array) {
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        } else if (array.length > this.size) {
            array[this.size] = null;
        }
        System.arraycopy(this.elements, 0, array, 0, this.size);
        return array;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < ListSet.this.size;
            }

            @Override
            public E next() {
                return ListSet.this.elements[this.current++];
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }
}

