/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.metrics;

import com.fren_gor.ultimateAdvancementAPI.AdvancementPlugin;
import com.fren_gor.ultimateAdvancementAPI.libs.org.bstats.bukkit.Metrics;
import com.fren_gor.ultimateAdvancementAPI.libs.org.bstats.charts.DrilldownPie;
import com.fren_gor.ultimateAdvancementAPI.libs.org.bstats.charts.SimplePie;
import com.fren_gor.ultimateAdvancementAPI.util.Versions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BStats {
    private static final int BSTATS_ID = 12593;
    private static final Map<String, Map<String, Integer>> apiMcVersions = new HashMap<String, Map<String, Integer>>();
    private static final Map<String, Map<String, Integer>> apiNMSVersions = new HashMap<String, Map<String, Integer>>();

    public static void init(@NotNull AdvancementPlugin plugin) {
        @Nullable String versionsRange = Versions.getNMSVersionsRange();
        Metrics metrics = new Metrics((Plugin)plugin, 12593);
        metrics.addCustomChart(new SimplePie("disabled_vanilla_advancements", () -> BStats.getDisabledAdvancementsLabel(plugin)));
        metrics.addCustomChart(new SimplePie("database_type", () -> plugin.getConfigManager().getStorageType().getFancyName()));
        if (versionsRange != null) {
            apiMcVersions.put(Versions.getApiVersion(), Collections.singletonMap(Versions.getNMSVersionsRange(), 1));
            metrics.addCustomChart(new DrilldownPie("api_-_minecraft_version", () -> apiMcVersions));
        }
        Versions.getNMSVersion().ifPresent(version -> {
            apiNMSVersions.put(Versions.getApiVersion(), Collections.singletonMap(Versions.removeInitialV(version), 1));
            metrics.addCustomChart(new DrilldownPie("api_-_nms_version", () -> apiNMSVersions));
        });
    }

    @NotNull
    private static String getDisabledAdvancementsLabel(@NotNull AdvancementPlugin plugin) {
        boolean disabledAdvs = plugin.getConfigManager().getDisableVanillaAdvancements();
        boolean disabledRecipeAdvs = plugin.getConfigManager().getDisableVanillaRecipeAdvancements();
        if (disabledAdvs && disabledRecipeAdvs) {
            return "All Disabled";
        }
        if (disabledAdvs) {
            return "Only Vanilla Advs Disabled";
        }
        if (disabledRecipeAdvs) {
            return "Only Recipe Advs Disabled";
        }
        return "None Disabled";
    }
}

