/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.exceptions;

import com.fren_gor.ultimateAdvancementAPI.exceptions.NotRegisteredException;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class UserNotRegisteredException
extends NotRegisteredException {
    private final UUID user;

    public UserNotRegisteredException(@NotNull UUID user) {
        this(user, UserNotRegisteredException.getDefaultErrorMessage(user));
    }

    public UserNotRegisteredException(@NotNull UUID user, String message) {
        super(message);
        this.user = Objects.requireNonNull(user, "User is null.");
    }

    public UserNotRegisteredException(@NotNull UUID user, String message, Throwable cause) {
        super(message, cause);
        this.user = Objects.requireNonNull(user, "User is null.");
    }

    public UserNotRegisteredException(@NotNull UUID user, Throwable cause) {
        this(user, UserNotRegisteredException.getDefaultErrorMessage(user), cause);
    }

    protected UserNotRegisteredException(@NotNull UUID user, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.user = Objects.requireNonNull(user, "User is null.");
    }

    @NotNull
    public UUID getUser() {
        return this.user;
    }

    private static String getDefaultErrorMessage(UUID user) {
        return "Could not find user " + String.valueOf(user);
    }
}

