/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.exceptions;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class UserNotLoadedException
extends RuntimeException {
    private final UUID user;

    public UserNotLoadedException(@NotNull UUID user) {
        this(user, UserNotLoadedException.getDefaultErrorMessage(user));
    }

    public UserNotLoadedException(@NotNull UUID user, String message) {
        super(message);
        this.user = Objects.requireNonNull(user, "User is null.");
    }

    public UserNotLoadedException(@NotNull UUID user, String message, Throwable cause) {
        super(message, cause);
        this.user = Objects.requireNonNull(user, "User is null.");
    }

    public UserNotLoadedException(@NotNull UUID user, Throwable cause) {
        this(user, UserNotLoadedException.getDefaultErrorMessage(user), cause);
    }

    protected UserNotLoadedException(@NotNull UUID user, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.user = Objects.requireNonNull(user, "User is null.");
    }

    @NotNull
    public UUID getUser() {
        return this.user;
    }

    private static String getDefaultErrorMessage(UUID user) {
        return "Could not load user " + String.valueOf(user);
    }
}

