/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.exceptions;

import com.fren_gor.ultimateAdvancementAPI.exceptions.NotRegisteredException;

public class TeamNotRegisteredException
extends NotRegisteredException {
    private final int teamId;

    public TeamNotRegisteredException(int teamId) {
        this(teamId, TeamNotRegisteredException.getDefaultErrorMessage(teamId));
    }

    public TeamNotRegisteredException(int teamId, String message) {
        super(message);
        this.teamId = teamId;
    }

    public TeamNotRegisteredException(int teamId, String message, Throwable cause) {
        super(message, cause);
        this.teamId = teamId;
    }

    public TeamNotRegisteredException(int teamId, Throwable cause) {
        this(teamId, TeamNotRegisteredException.getDefaultErrorMessage(teamId), cause);
    }

    protected TeamNotRegisteredException(int teamId, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.teamId = teamId;
    }

    public int getTeamId() {
        return this.teamId;
    }

    private static String getDefaultErrorMessage(int teamId) {
        return "Could not find any team with id " + teamId;
    }
}

