/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.exceptions;

import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class NotGrantedException
extends RuntimeException {
    private final AdvancementKey advancementKey;
    private final int teamId;

    public NotGrantedException(@NotNull AdvancementKey advancementKey, int teamId) {
        this(advancementKey, teamId, NotGrantedException.getDefaultErrorMessage(advancementKey, teamId));
    }

    public NotGrantedException(@NotNull AdvancementKey advancementKey, int teamId, String message) {
        super(message);
        this.advancementKey = Objects.requireNonNull(advancementKey, "AdvancementKey is null.");
        this.teamId = teamId;
    }

    public NotGrantedException(@NotNull AdvancementKey advancementKey, int teamId, String message, Throwable cause) {
        super(message, cause);
        this.advancementKey = Objects.requireNonNull(advancementKey, "AdvancementKey is null.");
        this.teamId = teamId;
    }

    public NotGrantedException(@NotNull AdvancementKey advancementKey, int teamId, Throwable cause) {
        this(advancementKey, teamId, NotGrantedException.getDefaultErrorMessage(advancementKey, teamId), cause);
    }

    protected NotGrantedException(@NotNull AdvancementKey advancementKey, int teamId, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.advancementKey = Objects.requireNonNull(advancementKey, "AdvancementKey is null.");
        this.teamId = teamId;
    }

    @NotNull
    public AdvancementKey getAdvancementKey() {
        return this.advancementKey;
    }

    public int getTeamId() {
        return this.teamId;
    }

    private static String getDefaultErrorMessage(AdvancementKey advancementKey, int teamId) {
        return "Advancement " + String.valueOf(advancementKey) + " is not granted for team with id " + teamId;
    }
}

