/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.events.team;

import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class TeamUpdateEvent
extends Event {
    private final TeamProgression oldTeam;
    private final TeamProgression newTeam;
    private final UUID playerUUID;
    private static final HandlerList handlers = new HandlerList();

    @ApiStatus.Internal
    public TeamUpdateEvent(@NotNull UUID playerUUID, @NotNull TeamProgression oldTeam, @NotNull TeamProgression newTeam) {
        this.oldTeam = AdvancementUtils.validateTeamProgression(Objects.requireNonNull(oldTeam, "OldTeam is null."));
        this.newTeam = AdvancementUtils.validateTeamProgression(Objects.requireNonNull(newTeam, "NewTeam is null."));
        this.playerUUID = Objects.requireNonNull(playerUUID, "UUID is null.");
    }

    @NotNull
    public TeamProgression getOldTeamProgression() {
        return this.oldTeam;
    }

    @NotNull
    public TeamProgression getNewTeamProgression() {
        return this.newTeam;
    }

    @NotNull
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public String toString() {
        return "TeamUpdateEvent{oldTeam=" + String.valueOf(this.oldTeam) + ", newTeam=" + String.valueOf(this.newTeam) + ", playerUUID=" + String.valueOf(this.playerUUID) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TeamUpdateEvent that = (TeamUpdateEvent)((Object)o);
        if (!this.oldTeam.equals(that.oldTeam)) {
            return false;
        }
        if (!this.newTeam.equals(that.newTeam)) {
            return false;
        }
        return this.playerUUID.equals(that.playerUUID);
    }

    public int hashCode() {
        int result = this.oldTeam.hashCode();
        result = 31 * result + this.newTeam.hashCode();
        result = 31 * result + this.playerUUID.hashCode();
        return result;
    }
}

