/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.events.team;

import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerRegisteredEvent
extends Event {
    private final TeamProgression team;
    private final UUID uuid;
    private static final HandlerList handlers = new HandlerList();

    @ApiStatus.Internal
    public PlayerRegisteredEvent(@NotNull TeamProgression team, @NotNull UUID uuid) {
        this.team = AdvancementUtils.validateTeamProgression(team);
        this.uuid = Objects.requireNonNull(uuid, "UUID is null.");
    }

    @NotNull
    public TeamProgression getTeamProgression() {
        return this.team;
    }

    @NotNull
    public UUID getPlayerUUID() {
        return this.uuid;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public String toString() {
        return "PlayerRegisteredEvent{team=" + String.valueOf(this.team) + ", uuid=" + String.valueOf(this.uuid) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PlayerRegisteredEvent that = (PlayerRegisteredEvent)((Object)o);
        if (!this.team.equals(that.team)) {
            return false;
        }
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        int result = this.team.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }
}

