/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.events.advancement;

import com.fren_gor.ultimateAdvancementAPI.database.ProgressionUpdateResult;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class ProgressionUpdateEvent
extends Event {
    private final TeamProgression team;
    private final @Range(from=0L, to=0x7FFFFFFFL) int oldProgression;
    private final @Range(from=0L, to=0x7FFFFFFFL) int newProgression;
    private final AdvancementKey advancementKey;
    private final CompletableFuture<ProgressionUpdateResult> updateCompletableFuture;
    private static final HandlerList handlers = new HandlerList();

    @ApiStatus.Internal
    public ProgressionUpdateEvent(@NotNull AdvancementKey advancementKey, @NotNull TeamProgression team, @Range(from=0L, to=0x7FFFFFFFL) int oldProgression, @Range(from=0L, to=0x7FFFFFFFL) int newProgression, @NotNull CompletableFuture<ProgressionUpdateResult> updateCompletableFuture) {
        this.team = AdvancementUtils.validateTeamProgression(team);
        this.oldProgression = AdvancementUtils.validateProgressionValue(oldProgression);
        this.newProgression = AdvancementUtils.validateProgressionValue(newProgression);
        this.advancementKey = Objects.requireNonNull(advancementKey, "AdvancementKey is null.");
        this.updateCompletableFuture = Objects.requireNonNull(updateCompletableFuture, "Update CompletableFuture is null.");
        Preconditions.checkArgument((!updateCompletableFuture.isDone() ? 1 : 0) != 0, (Object)"Update CompletableFuture is completed.");
    }

    public TeamProgression getTeamProgression() {
        return this.team;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getOldProgression() {
        return this.oldProgression;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getNewProgression() {
        return this.newProgression;
    }

    public AdvancementKey getAdvancementKey() {
        return this.advancementKey;
    }

    @NotNull
    public CompletableFuture<ProgressionUpdateResult> getUpdateCompletableFuture() {
        return this.updateCompletableFuture;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public String toString() {
        return "ProgressionUpdateEvent{team=" + String.valueOf(this.team) + ", oldProgression=" + this.oldProgression + ", newProgression=" + this.newProgression + ", advancementKey=" + String.valueOf(this.advancementKey) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ProgressionUpdateEvent that = (ProgressionUpdateEvent)((Object)o);
        if (this.oldProgression != that.oldProgression) {
            return false;
        }
        if (this.newProgression != that.newProgression) {
            return false;
        }
        if (!this.team.equals(that.team)) {
            return false;
        }
        return this.advancementKey.equals(that.advancementKey);
    }

    public int hashCode() {
        int result = this.team.hashCode();
        result = 31 * result + this.oldProgression;
        result = 31 * result + this.newProgression;
        result = 31 * result + this.advancementKey.hashCode();
        return result;
    }
}

