/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.events.advancement;

import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class AdvancementGrantEvent
extends Event {
    private final TeamProgression team;
    private final Player advancementCompleter;
    private final Advancement advancement;
    private final boolean giveRewards;
    private static final HandlerList handlers = new HandlerList();

    public AdvancementGrantEvent(@NotNull Advancement advancement, @NotNull TeamProgression team, @NotNull Player advancementCompleter, boolean giveRewards) {
        this.team = AdvancementUtils.validateTeamProgression(team);
        this.advancementCompleter = Objects.requireNonNull(advancementCompleter, "Player is null.");
        Preconditions.checkArgument((boolean)team.contains(advancementCompleter), (Object)"Team does not contain the advancement completer.");
        this.advancement = Objects.requireNonNull(advancement, "Advancement is null.");
        this.giveRewards = giveRewards;
    }

    @NotNull
    public TeamProgression getTeamProgression() {
        return this.team;
    }

    @NotNull
    public Player getAdvancementCompleter() {
        return this.advancementCompleter;
    }

    @NotNull
    public Advancement getAdvancement() {
        return this.advancement;
    }

    public boolean doesGiveRewards() {
        return this.giveRewards;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public String toString() {
        return "AdvancementGrantEvent{team=" + String.valueOf(this.team) + ", advancementCompleter=" + String.valueOf(this.advancementCompleter) + ", advancement=" + String.valueOf(this.advancement) + ", giveRewards=" + this.giveRewards + "}";
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AdvancementGrantEvent that = (AdvancementGrantEvent)((Object)o);
        return this.giveRewards == that.giveRewards && this.team.equals(that.team) && this.advancementCompleter.equals((Object)that.advancementCompleter) && this.advancement.equals(that.advancement);
    }

    public int hashCode() {
        int result = this.team.hashCode();
        result = 31 * result + this.advancementCompleter.hashCode();
        result = 31 * result + this.advancement.hashCode();
        result = 31 * result + Boolean.hashCode(this.giveRewards);
        return result;
    }
}

