/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.database;

import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.database.DatabaseManager;
import com.fren_gor.ultimateAdvancementAPI.database.IDatabase;
import com.fren_gor.ultimateAdvancementAPI.exceptions.IllegalOperationException;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;

public final class TeamProgression {
    final AtomicBoolean inCache = new AtomicBoolean(false);
    private final int teamId;
    private final Map<AdvancementKey, Integer> advancements;
    private Set<UUID> players;
    private final Object playersLock = new Object();

    public TeamProgression(int teamId) {
        this.validateCaller(StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass());
        this.advancements = new ConcurrentHashMap<AdvancementKey, Integer>();
        this.teamId = teamId;
        this.players = Set.of();
    }

    public TeamProgression(int teamId, @NotNull Collection<UUID> members, @NotNull Map<AdvancementKey, Integer> advancements) {
        this.validateCaller(StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass());
        Preconditions.checkNotNull(advancements, (Object)"Advancements is null.");
        Preconditions.checkNotNull(members, (Object)"Members is null.");
        this.advancements = new ConcurrentHashMap<AdvancementKey, Integer>(advancements);
        this.teamId = teamId;
        this.players = Set.copyOf(members);
    }

    private void validateCaller(@NotNull Class<?> caller) throws IllegalOperationException {
        if (!IDatabase.class.isAssignableFrom(caller)) {
            throw new IllegalOperationException("TeamProgression can be instantiated only by database implementations (IDatabase).");
        }
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getProgression(@NotNull Advancement advancement) {
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        Integer progression = this.advancements.get(advancement.getKey());
        if (progression != null) {
            if (progression <= advancement.getMaxProgression()) {
                return progression;
            }
            return advancement.getMaxProgression();
        }
        return 0;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getRawProgression(@NotNull AdvancementKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"AdvancementKey is null.");
        Integer progression = this.advancements.get(key);
        return progression != null ? progression : 0;
    }

    @Contract(pure=true)
    public boolean contains(@NotNull Player player) {
        return this.contains(AdvancementUtils.uuidFromPlayer(player));
    }

    @Contract(pure=true, value="null -> false")
    public boolean contains(UUID uuid) {
        return this.getMembers().contains(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public @Unmodifiable @NotNull Set<@NotNull UUID> getMembers() {
        Object object = this.playersLock;
        synchronized (object) {
            return this.players;
        }
    }

    @Contract(pure=true)
    public @Range(from=0L, to=0x7FFFFFFFL) int getSize() {
        return this.getMembers().size();
    }

    public void forEachMember(@NotNull Consumer<UUID> action) {
        Preconditions.checkNotNull(action, (Object)"Consumer is null.");
        for (UUID u : this.getMembers()) {
            action.accept(u);
        }
    }

    public boolean everyMemberMatch(@NotNull Predicate<UUID> action) {
        Preconditions.checkNotNull(action, (Object)"Predicate is null.");
        for (UUID u : this.getMembers()) {
            if (action.test(u)) continue;
            return false;
        }
        return true;
    }

    public boolean anyMemberMatch(@NotNull Predicate<UUID> action) {
        Preconditions.checkNotNull(action, (Object)"Predicate is null.");
        for (UUID u : this.getMembers()) {
            if (!action.test(u)) continue;
            return true;
        }
        return false;
    }

    public boolean noMemberMatch(@NotNull Predicate<UUID> action) {
        Preconditions.checkNotNull(action, (Object)"Predicate is null.");
        for (UUID u : this.getMembers()) {
            if (!action.test(u)) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.inCache.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMember(@NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null");
        Object object = this.playersLock;
        synchronized (object) {
            Preconditions.checkArgument((boolean)this.players.contains(uuid), (Object)("Team " + this.teamId + " doesn't contain member " + String.valueOf(uuid)));
            int size = this.players.size();
            block2 : switch (size) {
                case 1: {
                    this.players = Set.of();
                    break;
                }
                case 2: {
                    for (UUID u : this.players) {
                        if (u.equals(uuid)) continue;
                        this.players = Set.of(u);
                        break block2;
                    }
                    break;
                }
                default: {
                    UUID u;
                    UUID[] members = new UUID[size - 1];
                    int i = 0;
                    Iterator<UUID> it = this.players.iterator();
                    while (it.hasNext() && !(u = it.next()).equals(uuid)) {
                        members[i++] = u;
                    }
                    while (it.hasNext()) {
                        members[i++] = it.next();
                    }
                    this.players = Set.of(members);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMember(@NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        Object object = this.playersLock;
        synchronized (object) {
            Preconditions.checkArgument((!this.players.contains(uuid) ? 1 : 0) != 0, (Object)("Team " + this.teamId + " already contains member " + String.valueOf(uuid)));
            int size = this.players.size();
            UUID[] members = new UUID[size + 1];
            this.players.toArray(members);
            Preconditions.checkArgument((size == members.length - 1 ? 1 : 0) != 0);
            members[size] = uuid;
            this.players = Set.of(members);
        }
    }

    void updateProgression(@NotNull AdvancementKey key, @Range(from=0L, to=0x7FFFFFFFL) int progression) {
        AdvancementUtils.validateProgressionValue(progression);
        this.advancements.put(key, progression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void movePlayer(@NotNull TeamProgression newTeam, @NotNull UUID uuid) {
        AdvancementUtils.validateTeamProgression(newTeam);
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        if (this == newTeam) {
            return;
        }
        Object object = this.playersLock;
        synchronized (object) {
            Object object2 = newTeam.playersLock;
            synchronized (object2) {
                this.removeMember(uuid);
                newTeam.addMember(uuid);
            }
        }
    }

    @Nullable
    public UUID getAMember() {
        return (UUID)Iterables.getFirst(this.getMembers(), null);
    }

    @Nullable
    public Player getAnOnlineMember(@NotNull DatabaseManager manager) {
        Preconditions.checkNotNull((Object)manager, (Object)"DatabaseManager is null.");
        for (UUID u : this.getMembers()) {
            if (!manager.isLoadedAndOnline(u)) continue;
            return Bukkit.getPlayer((UUID)u);
        }
        return null;
    }

    public String toString() {
        return "TeamProgression{teamId=" + this.teamId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamProgression that = (TeamProgression)o;
        return this.teamId == that.teamId;
    }

    public int hashCode() {
        return this.teamId;
    }

    public int getTeamId() {
        return this.teamId;
    }
}

