/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.database;

import com.fren_gor.ultimateAdvancementAPI.exceptions.SyncExecutionException;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class ReentrantUpdaterLock
implements Lock {
    public static final int MAX_LOCKS_PER_THREAD = Integer.MAX_VALUE;
    private final Semaphore mutex = new Semaphore(1, true);
    private boolean updateLockRequested = false;
    private long activeLocksCounter = 0L;
    private final ThreadLocal<Integer> threadLockCounter = ThreadLocal.withInitial(() -> 0);
    private Set<Thread> blocked = new HashSet<Thread>();

    ReentrantUpdaterLock() {
    }

    boolean tryLockExclusiveLock() {
        AdvancementUtils.checkSync();
        this.mutex.acquireUninterruptibly();
        try {
            this.updateLockRequested = true;
            boolean bl = this.activeLocksCounter == 0L;
            return bl;
        }
        finally {
            this.mutex.release();
        }
    }

    void unlockExclusiveLock() {
        Set<Thread> oldBlocked;
        AdvancementUtils.checkSync();
        this.mutex.acquireUninterruptibly();
        try {
            this.updateLockRequested = false;
            oldBlocked = this.blocked;
            this.blocked = new HashSet<Thread>();
            this.activeLocksCounter = oldBlocked.size();
        }
        finally {
            this.mutex.release();
        }
        for (Thread t : oldBlocked) {
            LockSupport.unpark(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        this.checkMainThread();
        int currentThreadCounter = this.threadLockCounter.get();
        if (currentThreadCounter > 0) {
            this.incrementThreadLockCounter(currentThreadCounter);
            return;
        }
        Thread currentThread = Thread.currentThread();
        this.mutex.acquireUninterruptibly();
        if (this.updateLockRequested) {
            boolean blockedContains;
            try {
                this.blocked.add(currentThread);
            }
            finally {
                this.mutex.release();
            }
            do {
                LockSupport.park(this);
                this.mutex.acquireUninterruptibly();
                try {
                    blockedContains = this.blocked.contains(currentThread);
                }
                finally {
                    this.mutex.release();
                }
            } while (blockedContains);
        } else {
            ++this.activeLocksCounter;
            this.mutex.release();
        }
        this.threadLockCounter.set(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.checkMainThread();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int currentThreadCounter = this.threadLockCounter.get();
        if (currentThreadCounter > 0) {
            this.incrementThreadLockCounter(currentThreadCounter);
            return;
        }
        Thread currentThread = Thread.currentThread();
        this.mutex.acquireUninterruptibly();
        if (this.updateLockRequested) {
            boolean interrupted;
            boolean blockedContains;
            try {
                this.blocked.add(currentThread);
            }
            finally {
                this.mutex.release();
            }
            do {
                LockSupport.park(this);
                this.mutex.acquireUninterruptibly();
                try {
                    blockedContains = this.blocked.contains(currentThread);
                    interrupted = Thread.interrupted();
                    if (interrupted && blockedContains) {
                        this.blocked.remove(currentThread);
                        throw new InterruptedException();
                    }
                }
                finally {
                    this.mutex.release();
                }
            } while (blockedContains);
            if (interrupted) {
                currentThread.interrupt();
            }
        } else {
            ++this.activeLocksCounter;
            this.mutex.release();
        }
        this.threadLockCounter.set(1);
    }

    @Override
    public boolean tryLock() {
        this.checkMainThread();
        int currentThreadCounter = this.threadLockCounter.get();
        if (currentThreadCounter == Integer.MAX_VALUE) {
            return false;
        }
        if (currentThreadCounter > 0) {
            this.threadLockCounter.set(currentThreadCounter + 1);
            return true;
        }
        this.mutex.acquireUninterruptibly();
        try {
            if (this.updateLockRequested) {
                boolean bl = false;
                return bl;
            }
            ++this.activeLocksCounter;
        }
        finally {
            this.mutex.release();
        }
        this.threadLockCounter.set(1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long time, @NotNull TimeUnit timeUnit) throws InterruptedException {
        this.checkMainThread();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int currentThreadCounter = this.threadLockCounter.get();
        if (currentThreadCounter == Integer.MAX_VALUE) {
            return false;
        }
        if (currentThreadCounter > 0) {
            this.threadLockCounter.set(currentThreadCounter + 1);
            return true;
        }
        Thread currentThread = Thread.currentThread();
        long nanos = timeUnit.toNanos(time);
        this.mutex.acquireUninterruptibly();
        if (nanos <= 0L) {
            try {
                if (this.updateLockRequested) {
                    boolean bl = false;
                    return bl;
                }
                ++this.activeLocksCounter;
            }
            finally {
                this.mutex.release();
            }
        }
        nanos += System.nanoTime();
        if (this.updateLockRequested) {
            boolean interrupted;
            boolean blockedContains;
            try {
                this.blocked.add(currentThread);
            }
            finally {
                this.mutex.release();
            }
            do {
                long timeout;
                if ((timeout = nanos - System.nanoTime()) <= 0L) {
                    return false;
                }
                LockSupport.parkNanos(this, timeout);
                this.mutex.acquireUninterruptibly();
                try {
                    blockedContains = this.blocked.contains(currentThread);
                    interrupted = Thread.interrupted();
                    if (interrupted && blockedContains) {
                        this.blocked.remove(currentThread);
                        throw new InterruptedException();
                    }
                }
                finally {
                    this.mutex.release();
                }
            } while (blockedContains);
            if (interrupted) {
                currentThread.interrupt();
            }
        } else {
            ++this.activeLocksCounter;
            this.mutex.release();
        }
        this.threadLockCounter.set(1);
        return true;
    }

    @Override
    public void unlock() {
        this.checkMainThread();
        int currentThreadCounter = this.threadLockCounter.get();
        if (currentThreadCounter == 0) {
            throw new IllegalStateException("Thread " + Thread.currentThread().getName() + " called ReentrantUpdaterLock#unlock() while not holding any lock.");
        }
        this.threadLockCounter.set(--currentThreadCounter);
        if (currentThreadCounter == 0) {
            this.mutex.acquireUninterruptibly();
            --this.activeLocksCounter;
            this.mutex.release();
        }
    }

    public boolean isHeldByCurrentThread() {
        return this.threadLockCounter.get() > 0;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getHoldCount() {
        return this.threadLockCounter.get();
    }

    @Override
    @Contract(value="-> fail")
    public Condition newCondition() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void incrementThreadLockCounter(int counterToIncrement) {
        if (counterToIncrement == Integer.MAX_VALUE) {
            throw new IllegalStateException("Thread " + Thread.currentThread().getName() + " already holds the maximum amount of locks permitted per-thread.");
        }
        this.threadLockCounter.set(counterToIncrement + 1);
    }

    private void checkMainThread() {
        if (Bukkit.isPrimaryThread()) {
            throw new SyncExecutionException("The main thread cannot hold any ReentrantUpdaterLock lock.");
        }
    }
}

