/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.database;

import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JoinEventWaiter {
    private final Map<UUID, WaiterObject> waiting = new HashMap<UUID, WaiterObject>();
    private final Plugin plugin;

    public JoinEventWaiter(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    public synchronized void onLogin(@NotNull UUID uuid) {
        this.waiting.put(uuid, new WaiterObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinishLoading(@NotNull UUID uuid, long delay, @NotNull Consumer<Player> toRun, @NotNull Runnable onCancel) {
        Runnable cancelled;
        JoinEventWaiter joinEventWaiter = this;
        synchronized (joinEventWaiter) {
            WaiterObject waiter = this.waiting.get(uuid);
            if (waiter == null) {
                cancelled = onCancel;
            } else if (waiter.scheduled) {
                cancelled = onCancel;
            } else {
                cancelled = waiter.onCancel;
                if (waiter.joinEventFired) {
                    Preconditions.checkNotNull((Object)waiter.joinEventPlayer, (Object)"waiter.joinEventFired is null.");
                    this.scheduleRunnable(waiter, toRun, delay, waiter.joinEventPlayer);
                } else {
                    waiter.toRun = toRun;
                    waiter.onCancel = onCancel;
                    waiter.delay = delay;
                }
            }
        }
        if (cancelled != null) {
            cancelled.run();
        }
    }

    public synchronized void onJoin(@NotNull Player player) {
        WaiterObject waiter = this.waiting.get(player.getUniqueId());
        if (waiter == null) {
            return;
        }
        if (waiter.scheduled) {
            return;
        }
        if (waiter.toRun == null) {
            waiter.joinEventFired = true;
            waiter.joinEventPlayer = player;
            return;
        }
        this.scheduleRunnable(waiter, waiter.toRun, waiter.delay, player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onQuit(@NotNull UUID uuid) {
        Runnable onCancel = null;
        JoinEventWaiter joinEventWaiter = this;
        synchronized (joinEventWaiter) {
            WaiterObject w = this.waiting.remove(uuid);
            if (w != null) {
                w.cancel();
                onCancel = w.onCancel;
            }
        }
        if (onCancel != null) {
            onCancel.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        ArrayList<Runnable> toCancel;
        JoinEventWaiter joinEventWaiter = this;
        synchronized (joinEventWaiter) {
            toCancel = new ArrayList<Runnable>(this.waiting.size());
            for (WaiterObject w : this.waiting.values()) {
                w.cancel();
                if (w.onCancel == null) continue;
                toCancel.add(w.onCancel);
            }
            this.waiting.clear();
        }
        for (Runnable cancel : toCancel) {
            cancel.run();
        }
    }

    private synchronized void scheduleRunnable(@NotNull WaiterObject waiter, @NotNull Consumer<Player> toRun, long delay, @NotNull Player player) {
        waiter.scheduled = true;
        waiter.task = AdvancementUtils.runSync(this.plugin, delay, () -> {
            JoinEventWaiter joinEventWaiter = this;
            synchronized (joinEventWaiter) {
                this.waiting.remove(player.getUniqueId());
            }
            toRun.accept(player);
        });
    }

    private static class WaiterObject {
        @Nullable
        private Consumer<Player> toRun;
        @Nullable
        private Runnable onCancel;
        private boolean joinEventFired;
        private boolean scheduled;
        @Nullable
        private Player joinEventPlayer;
        @Nullable
        private BukkitTask task;
        private long delay;

        private WaiterObject() {
        }

        protected void cancel() {
            if (this.task != null) {
                this.task.cancel();
            }
        }
    }
}

