/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.database;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.database.DBPaperEvents;
import com.fren_gor.ultimateAdvancementAPI.database.IDatabase;
import com.fren_gor.ultimateAdvancementAPI.database.JoinEventWaiter;
import com.fren_gor.ultimateAdvancementAPI.database.ProgressionUpdateResult;
import com.fren_gor.ultimateAdvancementAPI.database.ReentrantUpdaterLock;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.events.EventManager;
import com.fren_gor.ultimateAdvancementAPI.events.PlayerLoadingCompletedEvent;
import com.fren_gor.ultimateAdvancementAPI.events.PlayerLoadingFailedEvent;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.ProgressionUpdateEvent;
import com.fren_gor.ultimateAdvancementAPI.events.team.AsyncPlayerUnregisteredEvent;
import com.fren_gor.ultimateAdvancementAPI.events.team.AsyncTeamLoadEvent;
import com.fren_gor.ultimateAdvancementAPI.events.team.AsyncTeamUnloadEvent;
import com.fren_gor.ultimateAdvancementAPI.events.team.PlayerRegisteredEvent;
import com.fren_gor.ultimateAdvancementAPI.events.team.TeamUpdateEvent;
import com.fren_gor.ultimateAdvancementAPI.exceptions.DatabaseException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.DatabaseManagerClosedException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.UserNotLoadedException;
import com.fren_gor.ultimateAdvancementAPI.nms.util.ReflectionUtil;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class DatabaseManager
implements Closeable {
    private static final int LOAD_EVENTS_DELAY = 3;
    private static final boolean IS_PAPER = ReflectionUtil.classExists("io.papermc.paper.advancement.AdvancementDisplay");
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("DatabaseManager Thread - %d").build());
    private final AdvancementMain main;
    private final Logger logger;
    private final EventManager eventManager;
    private final IDatabase database;
    private final JoinEventWaiter joinEventWaiter;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Map<Integer, CompletableFuture<?>> uncompletedCompletableFutures = Collections.synchronizedMap(new HashMap());
    private final AtomicInteger keysOfUncompletedCFs = new AtomicInteger(0);
    private final Map<Integer, LoadedTeam> teamsLoaded = new HashMap<Integer, LoadedTeam>();
    private final Map<UUID, LoadedPlayer> playersLoaded = new HashMap<UUID, LoadedPlayer>();
    public final ReentrantUpdaterLock updaterLock = new ReentrantUpdaterLock();
    private final PendingUpdatesManager pendingUpdatesManager = new PendingUpdatesManager();

    @ApiStatus.Internal
    public DatabaseManager(@NotNull AdvancementMain main, @NotNull IDatabase database) throws Exception {
        Preconditions.checkNotNull((Object)main, (Object)"AdvancementMain is null.");
        Preconditions.checkNotNull((Object)database, (Object)"Database impl is null.");
        this.main = main;
        this.logger = main.getLogger();
        this.eventManager = main.getEventManager();
        this.database = database;
        this.joinEventWaiter = new JoinEventWaiter(main.getOwningPlugin());
        this.commonSetUp();
    }

    private void commonSetUp() throws SQLException {
        this.database.setUp();
        if (IS_PAPER && (ReflectionUtil.VERSION > 21 || ReflectionUtil.VERSION == 21 && ReflectionUtil.MINOR_VERSION >= 7)) {
            DBPaperEvents events = new DBPaperEvents(this.logger, this.eventManager);
            events.registerPlayerConnectionInitialConfigureEvent(this, this::loadPlayerOnConnect);
            events.registerPlayerConnectionCloseEvent(this, this::unloadPlayerOnDisconnect);
        } else {
            this.eventManager.register(this, PlayerLoginEvent.class, EventPriority.LOWEST, e -> this.loadPlayerOnConnect(e.getPlayer().getUniqueId(), e.getPlayer().getName()));
        }
        this.eventManager.register(this, PlayerJoinEvent.class, e -> this.joinEventWaiter.onJoin(e.getPlayer()));
        this.eventManager.register(this, PlayerQuitEvent.class, EventPriority.MONITOR, e -> this.unloadPlayerOnDisconnect(e.getPlayer().getUniqueId()));
        this.eventManager.register(this, PluginDisableEvent.class, EventPriority.HIGHEST, e -> {
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                ArrayList<LoadedPlayer> list = new ArrayList<LoadedPlayer>(this.playersLoaded.size());
                for (LoadedPlayer loadedPlayer : this.playersLoaded.values()) {
                    if (loadedPlayer.__removeAllPluginRequests(e.getPlugin()) == 0 || !loadedPlayer.canBeUnloaded()) continue;
                    list.add(loadedPlayer);
                }
                for (LoadedPlayer loadedPlayer : list) {
                    this.unloadPlayer(loadedPlayer);
                }
            }
        });
        this.runAsyncOnExecutor(() -> {
            try {
                this.database.clearUpTeams();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Cannot clear up unused team ids", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        if (this.eventManager.isEnabled()) {
            this.eventManager.unregister(this);
        }
        this.joinEventWaiter.onClose();
        this.pendingUpdatesManager.unregisterTask();
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.logger.log(Level.SEVERE, "It was not possible to terminate some tasks while closing the DatabaseManager");
                }
            }
        }
        catch (InterruptedException ignored) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "An exception occurred shutting down the executor thread while closing the DatabaseManager", e);
            this.executor.shutdownNow();
        }
        DatabaseManager e = this;
        synchronized (e) {
            this.pendingUpdatesManager.clearUpdates();
            this.teamsLoaded.forEach((u, t) -> t.getTeamProgression().inCache.set(false));
            for (LoadedPlayer player : this.playersLoaded.values()) {
                CompletableFuture<TeamProgression> cf = player.getRegisteringCF();
                if (cf == null) continue;
                player.unsetRegistering();
                cf.completeExceptionally(new DatabaseManagerClosedException());
                try {
                    this.database.unregisterPlayer(player.getUuid());
                }
                catch (Exception e2) {
                    this.logger.log(Level.SEVERE, "Couldn't unregister player " + String.valueOf(player.getUuid()) + " (waiting PlayerRegisteredEvent) while closing the DatabaseManager", e2);
                }
            }
            this.playersLoaded.clear();
            this.teamsLoaded.clear();
            Map<Integer, CompletableFuture<?>> map = this.uncompletedCompletableFutures;
            synchronized (map) {
                for (CompletableFuture<?> uncompleted : this.uncompletedCompletableFutures.values()) {
                    uncompleted.completeExceptionally(new DatabaseManagerClosedException());
                }
                this.uncompletedCompletableFutures.clear();
            }
        }
        try {
            this.database.close();
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Couldn't close the database connection while closing the DatabaseManager", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlayerOnConnect(@NotNull UUID uuid, @NotNull String name) {
        LoadedPlayer loadedPlayer;
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        Preconditions.checkNotNull((Object)name, (Object)"Name is null.");
        this.joinEventWaiter.onLogin(uuid);
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            loadedPlayer = this.addPlayerToCache(uuid, true);
            loadedPlayer.addInternalRequest();
        }
        this.runAsyncOnExecutor(() -> {
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                if (!loadedPlayer.isOnline()) {
                    return;
                }
                if (loadedPlayer.getPlayerTeam() != null) {
                    this.firePlayerLoadingCompletedEvent(loadedPlayer);
                    return;
                }
                CompletableFuture<TeamProgression> registeringCF = loadedPlayer.getRegisteringCF();
                if (registeringCF != null) {
                    loadedPlayer.addInternalRequest();
                    registeringCF.whenComplete((team, err) -> {
                        if (this.closed.get()) {
                            return;
                        }
                        try {
                            if (err != null) {
                                this.firePlayerLoadingFailedEvent(uuid, (Throwable)err);
                            } else {
                                this.firePlayerLoadingCompletedEvent(loadedPlayer);
                            }
                        }
                        finally {
                            this.removeInternalRequest(loadedPlayer);
                        }
                    });
                    return;
                }
                LoadedTeam loadedTeam = this.searchPlayerTeam(uuid);
                if (loadedTeam != null) {
                    loadedPlayer.setPlayerTeam(loadedTeam);
                    loadedTeam.addInternalRequest();
                    this.firePlayerLoadingCompletedEvent(loadedPlayer);
                    return;
                }
            }
            try {
                this.loadOrRegisterPlayerTeam(uuid, name, loadedPlayer, false, pro -> this.firePlayerLoadingCompletedEvent(loadedPlayer));
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Cannot load player " + name, ex);
                this.firePlayerLoadingFailedEvent(uuid, ex);
            }
        }).whenComplete((v, k) -> this.removeInternalRequest(loadedPlayer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadPlayerOnDisconnect(@NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        this.joinEventWaiter.onQuit(uuid);
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            LoadedPlayer loadedPlayer = this.playersLoaded.get(uuid);
            if (loadedPlayer != null) {
                this.setOffline(loadedPlayer);
            }
        }
    }

    private void firePlayerLoadingCompletedEvent(@NotNull LoadedPlayer loadedPlayer) {
        loadedPlayer.addInternalRequest();
        this.joinEventWaiter.onFinishLoading(loadedPlayer.getUuid(), 3L, player -> {
            AdvancementUtils.checkSync();
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                if (this.closed.get()) {
                    return;
                }
                if (!player.isOnline()) {
                    this.removeInternalRequest(loadedPlayer);
                    return;
                }
                LoadedTeam loadedTeam = loadedPlayer.getPlayerTeam();
                if (loadedTeam == null) {
                    this.removeInternalRequest(loadedPlayer);
                    return;
                }
                this.callEventCatchingExceptions(new PlayerLoadingCompletedEvent((Player)player, loadedTeam.getTeamProgression()));
                this.processUnredeemed(loadedPlayer, (Player)player);
            }
            this.main.updateAdvancementsToTeam((Player)player);
        }, () -> {
            if (!this.closed.get()) {
                this.removeInternalRequest(loadedPlayer);
            }
        });
    }

    private void firePlayerLoadingFailedEvent(@NotNull UUID uuid, @NotNull Throwable error) {
        this.joinEventWaiter.onFinishLoading(uuid, 0L, player -> {
            AdvancementUtils.checkSync();
            if (!this.closed.get() && player.isOnline()) {
                this.callEventCatchingExceptions(new PlayerLoadingFailedEvent((Player)player, error));
            }
        }, () -> {});
    }

    @Nullable
    private synchronized LoadedTeam searchPlayerTeam(@NotNull UUID uuid) {
        for (LoadedTeam loadedTeam : this.teamsLoaded.values()) {
            if (!loadedTeam.getTeamProgression().contains(uuid)) continue;
            return loadedTeam;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrRegisterPlayerTeam(@NotNull UUID uuid, @Nullable String name, @NotNull LoadedPlayer loadedPlayer, boolean loadOnly, @NotNull Consumer<TeamProgression> callback) throws SQLException {
        boolean fireRegisteredEvent;
        TeamProgression progression;
        if (loadOnly) {
            progression = this.database.loadUUID(uuid);
            fireRegisteredEvent = false;
        } else {
            Map.Entry<TeamProgression, Boolean> e = this.database.loadOrRegisterPlayer(uuid, Objects.requireNonNull(name, "Player name is null."));
            progression = e.getKey();
            fireRegisteredEvent = e.getValue();
        }
        if (!fireRegisteredEvent && name != null) {
            this.updatePlayerName(uuid, name);
        }
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            LoadedTeam loadedTeam = this.addTeamToCache(progression);
            if (fireRegisteredEvent) {
                this.pendingUpdatesManager.registerPlayerRegisteredUpdate(loadedPlayer, loadedTeam, () -> callback.accept(progression));
            } else {
                loadedTeam.addInternalRequest();
                loadedPlayer.setPlayerTeam(loadedTeam);
                callback.accept(progression);
            }
        }
    }

    private void processUnredeemed(@NotNull LoadedPlayer loadedPlayer, @NotNull Player player) {
        LoadedTeam[] teamToWhichRemoveInternalRequest = new LoadedTeam[]{null};
        this.runAsyncOnExecutor(() -> {
            LinkedList<Map.Entry<AdvancementKey, Boolean>> list;
            LoadedTeam loadedTeam;
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                loadedTeam = loadedPlayer.getPlayerTeam();
                if (!loadedPlayer.isOnline() || loadedTeam == null) {
                    return;
                }
                loadedTeam.addInternalRequest();
                teamToWhichRemoveInternalRequest[0] = loadedTeam;
            }
            try {
                list = this.database.getUnredeemed(loadedTeam.getTeamProgression().getTeamId());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't fetch unredeemed advancements for player " + player.getName(), e);
                return;
            }
            if (list.isEmpty() || !loadedPlayer.isOnline()) {
                return;
            }
            ArrayList<AbstractMap.SimpleEntry<Advancement, Boolean>> advs = new ArrayList<AbstractMap.SimpleEntry<Advancement, Boolean>>(list.size());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Map.Entry k = (Map.Entry)it.next();
                Advancement a = this.main.getAdvancement((AdvancementKey)k.getKey());
                if (a == null) {
                    it.remove();
                    continue;
                }
                advs.add(new AbstractMap.SimpleEntry<Advancement, Boolean>(a, (Boolean)k.getValue()));
            }
            if (this.closed.get() || advs.isEmpty() || !loadedPlayer.isOnline() || !loadedTeam.getTeamProgression().contains(loadedPlayer.getUuid())) {
                return;
            }
            try {
                this.database.unsetUnredeemed(Collections.unmodifiableList(list), loadedTeam.getTeamProgression().getTeamId());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't unset unredeemed advancements for player " + player.getName(), e);
                return;
            }
            loadedPlayer.addInternalRequest();
            loadedTeam.addInternalRequest();
            AdvancementUtils.runSync(this.main, () -> {
                try {
                    if (this.closed.get() || !player.isOnline() || !loadedTeam.getTeamProgression().contains(loadedPlayer.getUuid())) {
                        loadedPlayer.addInternalRequest();
                        CompletableFuture.runAsync(() -> {
                            for (Map.Entry entry : list) {
                                int teamId = loadedTeam.getTeamProgression().getTeamId();
                                try {
                                    this.database.setUnredeemed((AdvancementKey)entry.getKey(), teamId, (Boolean)entry.getValue());
                                }
                                catch (Exception e) {
                                    this.logger.log(Level.SEVERE, "Error restoring unredeemed advancement '" + String.valueOf(entry.getKey()) + "' for team " + teamId, e);
                                }
                            }
                        }, this.executor).whenComplete((r, e) -> this.removeInternalRequest(loadedPlayer));
                        return;
                    }
                    for (Map.Entry e2 : advs) {
                        try {
                            ((Advancement)e2.getKey()).onGrant(player, (Boolean)e2.getValue());
                        }
                        catch (Exception err) {
                            this.logger.log(Level.SEVERE, "onGrant method of advancement '" + String.valueOf(((Advancement)e2.getKey()).getKey()) + "' threw an exception", err);
                        }
                    }
                }
                finally {
                    DatabaseManager databaseManager = this;
                    synchronized (databaseManager) {
                        this.removeInternalRequest(loadedPlayer);
                        this.removeInternalRequest(loadedTeam);
                    }
                }
            });
        }).whenComplete((r, e) -> {
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                this.removeInternalRequest(loadedPlayer);
                if (teamToWhichRemoveInternalRequest[0] != null) {
                    this.removeInternalRequest(teamToWhichRemoveInternalRequest[0]);
                }
            }
        });
    }

    @NotNull
    public CompletableFuture<Void> updatePlayerName(@NotNull Player player) {
        this.checkClosed();
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null.");
        return this.updatePlayerName(player.getUniqueId(), player.getName());
    }

    @NotNull
    private CompletableFuture<Void> updatePlayerName(@NotNull UUID uuid, @NotNull String name) {
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        Preconditions.checkNotNull((Object)name, (Object)"Name is null.");
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            try {
                this.database.updatePlayerName(uuid, name);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't update player " + name + " name", e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> updatePlayerTeam(@NotNull Player playerToMove, @NotNull Player otherTeamMember) throws UserNotLoadedException {
        return this.updatePlayerTeam(playerToMove, this.getTeamProgression(otherTeamMember));
    }

    @NotNull
    public CompletableFuture<Void> updatePlayerTeam(@NotNull UUID playerToMove, @NotNull UUID otherTeamMember) throws UserNotLoadedException {
        return this.updatePlayerTeam(playerToMove, this.getTeamProgression(otherTeamMember));
    }

    @NotNull
    public CompletableFuture<Void> updatePlayerTeam(@NotNull UUID playerToMove, @NotNull TeamProgression otherTeamProgression) throws UserNotLoadedException {
        return this.updatePlayerTeam(playerToMove, Bukkit.getPlayer((UUID)playerToMove), otherTeamProgression);
    }

    @NotNull
    public CompletableFuture<Void> updatePlayerTeam(@NotNull Player playerToMove, @NotNull TeamProgression otherTeamProgression) throws UserNotLoadedException {
        return this.updatePlayerTeam(AdvancementUtils.uuidFromPlayer(playerToMove), playerToMove, otherTeamProgression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompletableFuture<Void> updatePlayerTeam(@NotNull UUID playerToMove, @Nullable Player ptm, @NotNull TeamProgression otherTeamProgression) throws UserNotLoadedException {
        LoadedPlayer loadedPlayer;
        LoadedTeam loadedNewTeam;
        this.checkClosed();
        Preconditions.checkNotNull((Object)playerToMove, (Object)"Player to move is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            AdvancementUtils.validateTeamProgression(otherTeamProgression);
            loadedNewTeam = this.teamsLoaded.get(otherTeamProgression.getTeamId());
            if (loadedNewTeam == null) {
                throw new IllegalArgumentException("Invalid TeamProgression.");
            }
            loadedPlayer = this.playersLoaded.get(playerToMove);
            if (loadedPlayer == null || loadedPlayer.getPlayerTeam() == null) {
                throw new UserNotLoadedException(playerToMove);
            }
            loadedNewTeam.addInternalRequest();
            loadedPlayer.addInternalRequest();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            try {
                this.database.movePlayer(playerToMove, otherTeamProgression.getTeamId());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't move player " + String.valueOf(ptm == null ? playerToMove : ptm) + " into team " + otherTeamProgression.getTeamId(), e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            this.registerTeamUpdate(loadedPlayer, ptm, loadedNewTeam, true, completableFuture, null);
        }).whenComplete((v, t) -> {
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                this.removeInternalRequest(loadedPlayer);
                this.removeInternalRequest(loadedNewTeam);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<TeamProgression> movePlayerInNewTeam(@NotNull Player player) throws UserNotLoadedException {
        return this.movePlayerInNewTeam(AdvancementUtils.uuidFromPlayer(player), player);
    }

    public CompletableFuture<TeamProgression> movePlayerInNewTeam(@NotNull UUID uuid) throws UserNotLoadedException {
        return this.movePlayerInNewTeam(uuid, Bukkit.getPlayer((UUID)uuid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<TeamProgression> movePlayerInNewTeam(@NotNull UUID uuid, @Nullable Player ptr) throws UserNotLoadedException {
        LoadedPlayer loadedPlayer;
        this.checkClosed();
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            loadedPlayer = this.playersLoaded.get(uuid);
            if (loadedPlayer == null || loadedPlayer.getPlayerTeam() == null) {
                throw new UserNotLoadedException(uuid);
            }
            loadedPlayer.addInternalRequest();
        }
        CompletableFuture<TeamProgression> completableFuture = new CompletableFuture<TeamProgression>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            TeamProgression newPro;
            try {
                newPro = this.database.movePlayerInNewTeam(uuid);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't remove player " + String.valueOf(ptr == null ? uuid : ptr.getName()) + " from their team", e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                LoadedTeam loadedTeam = this.addTeamToCache(newPro);
                this.registerTeamUpdate(loadedPlayer, ptr, loadedTeam, false, completableFuture, newPro);
            }
        }).whenComplete((v, t) -> this.removeInternalRequest(loadedPlayer));
        return completableFuture;
    }

    public CompletableFuture<Void> unregisterOfflinePlayer(@NotNull OfflinePlayer player) {
        return this.unregisterOfflinePlayer(AdvancementUtils.uuidFromPlayer(player));
    }

    public CompletableFuture<Void> unregisterOfflinePlayer(@NotNull UUID uuid) {
        this.checkClosed();
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                LoadedPlayer loadedPlayer = this.playersLoaded.get(uuid);
                if (loadedPlayer != null) {
                    if (loadedPlayer.isOnline()) {
                        completableFuture.completeExceptionally(new IllegalStateException("Player " + String.valueOf(uuid) + " is online."));
                    } else {
                        completableFuture.completeExceptionally(new IllegalStateException("Player " + String.valueOf(uuid) + " is loaded."));
                    }
                    return;
                }
                LoadedTeam team = this.searchPlayerTeam(uuid);
                if (team != null) {
                    completableFuture.completeExceptionally(new IllegalStateException("Player " + String.valueOf(uuid) + "'s team (id " + team.getTeamProgression().getTeamId() + ") is loaded."));
                }
            }
            try {
                this.database.unregisterPlayer(uuid);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't unregister player " + String.valueOf(uuid), e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            this.callEventCatchingExceptions(new AsyncPlayerUnregisteredEvent(uuid));
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull AdvancementKey key, @NotNull UUID uuid, @Range(from=0L, to=0x7FFFFFFFL) int newProgression) throws UserNotLoadedException {
        return this.setProgression(key, this.getTeamProgression(uuid), newProgression);
    }

    @NotNull
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull AdvancementKey key, @NotNull Player player, @Range(from=0L, to=0x7FFFFFFFL) int newProgression) throws UserNotLoadedException {
        return this.setProgression(key, AdvancementUtils.uuidFromPlayer(player), newProgression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull AdvancementKey key, @NotNull TeamProgression progression, @Range(from=0L, to=0x7FFFFFFFL) int newProgression) {
        LoadedTeam loadedNewTeam;
        this.checkClosed();
        Preconditions.checkNotNull((Object)key, (Object)"Key is null.");
        AdvancementUtils.validateProgressionValue(newProgression);
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            AdvancementUtils.validateTeamProgression(progression);
            loadedNewTeam = this.teamsLoaded.get(progression.getTeamId());
            if (loadedNewTeam == null) {
                throw new IllegalArgumentException("Invalid TeamProgression.");
            }
            loadedNewTeam.addInternalRequest();
        }
        CompletableFuture<ProgressionUpdateResult> completableFuture = new CompletableFuture<ProgressionUpdateResult>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            int old = this.pendingUpdatesManager.getCurrentValue(progression, key);
            if (newProgression != old) {
                try {
                    this.database.updateAdvancement(key, progression.getTeamId(), newProgression);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Couldn't set progression of advancement " + String.valueOf(key) + " to team " + progression.getTeamId(), e);
                    completableFuture.completeExceptionally(new DatabaseException(e));
                    return;
                }
            }
            this.registerProgressionUpdate(loadedNewTeam, key, old, newProgression, completableFuture);
        }).whenComplete((v, t) -> this.removeInternalRequest(loadedNewTeam));
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull AdvancementKey key, @NotNull UUID uuid, int increment, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) throws UserNotLoadedException {
        return this.incrementProgression(key, this.getTeamProgression(uuid), increment, maxProgression);
    }

    @NotNull
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull AdvancementKey key, @NotNull Player player, int increment, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) throws UserNotLoadedException {
        return this.incrementProgression(key, AdvancementUtils.uuidFromPlayer(player), increment, maxProgression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull AdvancementKey key, @NotNull TeamProgression progression, int increment, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) {
        LoadedTeam loadedNewTeam;
        this.checkClosed();
        Preconditions.checkNotNull((Object)key, (Object)"Key is null.");
        Preconditions.checkArgument((maxProgression > 0 ? 1 : 0) != 0, (Object)"Maximum progression cannot be <= 0");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            AdvancementUtils.validateTeamProgression(progression);
            loadedNewTeam = this.teamsLoaded.get(progression.getTeamId());
            if (loadedNewTeam == null) {
                throw new IllegalArgumentException("Invalid TeamProgression.");
            }
            loadedNewTeam.addInternalRequest();
        }
        CompletableFuture<ProgressionUpdateResult> completableFuture = new CompletableFuture<ProgressionUpdateResult>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            int old = this.pendingUpdatesManager.getCurrentValue(loadedNewTeam.getTeamProgression(), key);
            int incremented = Math.min(Math.max(old + increment, 0), maxProgression);
            if (incremented != old) {
                try {
                    this.database.updateAdvancement(key, progression.getTeamId(), incremented);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Couldn't increment progression of advancement " + String.valueOf(key) + " to team " + progression.getTeamId(), e);
                    completableFuture.completeExceptionally(new DatabaseException(e));
                    return;
                }
            }
            this.registerProgressionUpdate(loadedNewTeam, key, old, incremented, completableFuture);
        }).whenComplete((v, t) -> this.removeInternalRequest(loadedNewTeam));
        return completableFuture;
    }

    @NotNull
    public TeamProgression getTeamProgression(@NotNull Player player) throws UserNotLoadedException {
        return this.getTeamProgression(AdvancementUtils.uuidFromPlayer(player));
    }

    @NotNull
    public TeamProgression getTeamProgression(@NotNull OfflinePlayer player) throws UserNotLoadedException {
        return this.getTeamProgression(AdvancementUtils.uuidFromPlayer(player));
    }

    @NotNull
    public synchronized TeamProgression getTeamProgression(@NotNull UUID uuid) throws UserNotLoadedException {
        this.checkClosed();
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        LoadedPlayer loadedPlayer = this.playersLoaded.get(uuid);
        if (loadedPlayer == null || loadedPlayer.getPlayerTeam() == null) {
            throw new UserNotLoadedException(uuid);
        }
        return loadedPlayer.getPlayerTeam().getTeamProgression();
    }

    @NotNull
    public CompletableFuture<Boolean> isUnredeemed(@NotNull AdvancementKey key, @NotNull UUID uuid) throws UserNotLoadedException {
        return this.isUnredeemed(key, this.getTeamProgression(uuid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Boolean> isUnredeemed(@NotNull AdvancementKey key, @NotNull TeamProgression pro) {
        LoadedTeam loadedNewTeam;
        this.checkClosed();
        Preconditions.checkNotNull((Object)key, (Object)"AdvancementKey is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            AdvancementUtils.validateTeamProgression(pro);
            loadedNewTeam = this.teamsLoaded.get(pro.getTeamId());
            if (loadedNewTeam == null) {
                throw new IllegalArgumentException("Invalid TeamProgression.");
            }
            loadedNewTeam.addInternalRequest();
        }
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            boolean res;
            try {
                res = this.database.isUnredeemed(key, pro.getTeamId());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't fetch unredeemed advancements of team " + pro.getTeamId(), e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            completableFuture.complete(res);
        }).whenComplete((v, t) -> this.removeInternalRequest(loadedNewTeam));
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> setUnredeemed(@NotNull AdvancementKey key, @NotNull UUID uuid, boolean giveRewards) throws UserNotLoadedException {
        return this.setUnredeemed(key, this.getTeamProgression(uuid), giveRewards);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Void> setUnredeemed(@NotNull AdvancementKey key, @NotNull TeamProgression pro, boolean giveRewards) {
        LoadedTeam loadedNewTeam;
        this.checkClosed();
        Preconditions.checkNotNull((Object)key, (Object)"AdvancementKey is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            AdvancementUtils.validateTeamProgression(pro);
            loadedNewTeam = this.teamsLoaded.get(pro.getTeamId());
            if (loadedNewTeam == null) {
                throw new IllegalArgumentException("Invalid TeamProgression.");
            }
            loadedNewTeam.addInternalRequest();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            try {
                this.database.setUnredeemed(key, pro.getTeamId(), giveRewards);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't set unredeemed advancement " + String.valueOf(key) + " to team " + pro.getTeamId(), e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            completableFuture.complete(null);
        }).whenComplete((v, t) -> this.removeInternalRequest(loadedNewTeam));
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> unsetUnredeemed(@NotNull AdvancementKey key, @NotNull UUID uuid) throws UserNotLoadedException {
        return this.unsetUnredeemed(key, this.getTeamProgression(uuid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Void> unsetUnredeemed(@NotNull AdvancementKey key, @NotNull TeamProgression pro) {
        LoadedTeam loadedNewTeam;
        this.checkClosed();
        Preconditions.checkNotNull((Object)key, (Object)"AdvancementKey is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            AdvancementUtils.validateTeamProgression(pro);
            loadedNewTeam = this.teamsLoaded.get(pro.getTeamId());
            if (loadedNewTeam == null) {
                throw new IllegalArgumentException("Invalid TeamProgression.");
            }
            loadedNewTeam.addInternalRequest();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            try {
                this.database.unsetUnredeemed(key, pro.getTeamId());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't set unredeemed advancement " + String.valueOf(key) + " to team " + pro.getTeamId(), e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            completableFuture.complete(null);
        }).whenComplete((v, t) -> this.removeInternalRequest(loadedNewTeam));
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> setTeamPermanent(@NotNull TeamProgression progression, boolean permanent) {
        AdvancementUtils.validateTeamProgression(progression);
        return this.setTeamPermanent(progression.getTeamId(), permanent);
    }

    @NotNull
    public CompletableFuture<Void> setTeamPermanent(int teamId, boolean permanent) {
        this.checkClosed();
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            try {
                this.database.setTeamPermanent(teamId, permanent);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't set team " + teamId + (permanent ? " permanent" : " not permanent"), e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Boolean> isTeamPermanent(@NotNull TeamProgression progression) {
        AdvancementUtils.validateTeamProgression(progression);
        return this.isTeamPermanent(progression.getTeamId());
    }

    @NotNull
    public CompletableFuture<Boolean> isTeamPermanent(int teamId) {
        this.checkClosed();
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            boolean isPermanent;
            try {
                isPermanent = this.database.isTeamPermanent(teamId);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't fetch whether team " + teamId + " is permanent", e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            completableFuture.complete(isPermanent);
        });
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<List<Integer>> getPermanentTeams() {
        this.checkClosed();
        CompletableFuture<List<Integer>> completableFuture = new CompletableFuture<List<Integer>>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            List<Integer> permanentTeams;
            try {
                permanentTeams = this.database.getPermanentTeams();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't fetch permanent teams", e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            completableFuture.complete(permanentTeams);
        });
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<String> getStoredPlayerName(@NotNull UUID uuid) {
        this.checkClosed();
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            String name;
            try {
                name = this.database.getPlayerName(uuid);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't fetch player name of " + String.valueOf(uuid), e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            completableFuture.complete(name);
        });
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<TeamProgression> loadAndAddLoadingRequest(@NotNull UUID uuid, @NotNull Plugin requester) {
        LoadedPlayer loadedPlayer;
        this.checkClosed();
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        Preconditions.checkNotNull((Object)requester, (Object)"Plugin is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            if (!requester.isEnabled()) {
                throw new IllegalStateException("Plugin is not enabled.");
            }
            loadedPlayer = this.addPlayerToCache(uuid, false);
            if (loadedPlayer.getPlayerTeam() != null) {
                loadedPlayer.addPluginRequest(requester);
                return CompletableFuture.completedFuture(loadedPlayer.getPlayerTeam().getTeamProgression());
            }
        }
        CompletableFuture<TeamProgression> completableFuture = new CompletableFuture<TeamProgression>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                if (!requester.isEnabled()) {
                    completableFuture.completeExceptionally(new IllegalStateException("Plugin is not enabled."));
                    return;
                }
                if (loadedPlayer.getPlayerTeam() != null) {
                    loadedPlayer.addPluginRequest(requester);
                    completableFuture.complete(loadedPlayer.getPlayerTeam().getTeamProgression());
                    return;
                }
                CompletableFuture<TeamProgression> registeringCF = loadedPlayer.getRegisteringCF();
                if (registeringCF != null) {
                    loadedPlayer.addInternalRequest();
                    registeringCF.whenComplete((team, err) -> {
                        try {
                            if (err != null) {
                                completableFuture.completeExceptionally((Throwable)err);
                            } else if (!requester.isEnabled()) {
                                completableFuture.completeExceptionally(new IllegalStateException("Plugin is not enabled."));
                            } else {
                                loadedPlayer.addPluginRequest(requester);
                                completableFuture.complete((TeamProgression)team);
                            }
                        }
                        finally {
                            this.removeInternalRequest(loadedPlayer);
                        }
                    });
                    return;
                }
                LoadedTeam loadedTeam = this.searchPlayerTeam(uuid);
                if (loadedTeam != null) {
                    loadedPlayer.addPluginRequest(requester);
                    loadedPlayer.setPlayerTeam(loadedTeam);
                    loadedTeam.addInternalRequest();
                    completableFuture.complete(loadedTeam.getTeamProgression());
                    return;
                }
            }
            try {
                this.loadOrRegisterPlayerTeam(uuid, null, loadedPlayer, true, pro -> {
                    if (!requester.isEnabled()) {
                        completableFuture.completeExceptionally(new IllegalStateException("Plugin is not enabled."));
                        return;
                    }
                    loadedPlayer.addPluginRequest(requester);
                    completableFuture.complete((TeamProgression)pro);
                });
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't load offline player " + String.valueOf(uuid), e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
        }).whenComplete((v, t) -> this.removeInternalRequest(loadedPlayer));
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadingRequest(@NotNull UUID uuid, @NotNull Plugin requester) {
        this.checkClosed();
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        Preconditions.checkNotNull((Object)requester, (Object)"Plugin is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            Preconditions.checkArgument((boolean)requester.isEnabled(), (Object)"Plugin isn't enabled.");
            LoadedPlayer loadedPlayer = this.playersLoaded.get(uuid);
            if (loadedPlayer != null) {
                this.removePluginRequest(loadedPlayer, requester);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<TeamProgression> createNewTeamWithOneLoadingRequest(@NotNull Plugin requester) {
        this.checkClosed();
        Preconditions.checkNotNull((Object)requester, (Object)"Plugin is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            if (!requester.isEnabled()) {
                throw new IllegalStateException("Plugin is not enabled.");
            }
        }
        CompletableFuture<TeamProgression> completableFuture = new CompletableFuture<TeamProgression>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            TeamProgression team;
            try {
                team = this.database.createNewTeam();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't create a new team", e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                if (!requester.isEnabled()) {
                    completableFuture.completeExceptionally(new IllegalStateException("Plugin is not enabled."));
                    return;
                }
                LoadedTeam loadedTeam = this.addTeamToCache(team);
                loadedTeam.addPluginRequest(requester);
            }
            completableFuture.complete(team);
        });
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<TeamProgression> loadAndAddLoadingRequest(int teamId, @NotNull Plugin requester) {
        this.checkClosed();
        Preconditions.checkNotNull((Object)requester, (Object)"Plugin is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            if (!requester.isEnabled()) {
                throw new IllegalStateException("Plugin is not enabled.");
            }
            LoadedTeam team = this.teamsLoaded.get(teamId);
            if (team != null) {
                team.addPluginRequest(requester);
                return CompletableFuture.completedFuture(team.getTeamProgression());
            }
        }
        CompletableFuture<TeamProgression> completableFuture = new CompletableFuture<TeamProgression>();
        this.runAsyncOnExecutor(completableFuture, () -> {
            TeamProgression team;
            DatabaseManager databaseManager = this;
            synchronized (databaseManager) {
                if (!requester.isEnabled()) {
                    completableFuture.completeExceptionally(new IllegalStateException("Plugin is not enabled."));
                    return;
                }
                LoadedTeam team2 = this.teamsLoaded.get(teamId);
                if (team2 != null) {
                    team2.addPluginRequest(requester);
                    completableFuture.complete(team2.getTeamProgression());
                    return;
                }
            }
            try {
                team = this.database.loadTeam(teamId);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Couldn't load team " + teamId, e);
                completableFuture.completeExceptionally(new DatabaseException(e));
                return;
            }
            DatabaseManager databaseManager2 = this;
            synchronized (databaseManager2) {
                if (!requester.isEnabled()) {
                    completableFuture.completeExceptionally(new IllegalStateException("Plugin is not enabled."));
                    return;
                }
                LoadedTeam loadedTeam = this.addTeamToCache(team);
                loadedTeam.addPluginRequest(requester);
            }
            completableFuture.complete(team);
        });
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoadingRequest(@NotNull TeamProgression teamProgression, @NotNull Plugin requester) throws IllegalArgumentException {
        this.checkClosed();
        Preconditions.checkNotNull((Object)requester, (Object)"Plugin is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            if (!requester.isEnabled()) {
                throw new IllegalStateException("Plugin is not enabled.");
            }
            AdvancementUtils.validateTeamProgression(teamProgression);
            LoadedTeam team = this.teamsLoaded.get(teamProgression.getTeamId());
            Preconditions.checkArgument((team != null ? 1 : 0) != 0, (Object)("Team " + teamProgression.getTeamId() + " isn't loaded."));
            team.addPluginRequest(requester);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadingRequest(@NotNull TeamProgression teamProgression, @NotNull Plugin requester) {
        this.checkClosed();
        Preconditions.checkNotNull((Object)teamProgression, (Object)"TeamProgression is null.");
        Preconditions.checkNotNull((Object)requester, (Object)"Plugin is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            Preconditions.checkArgument((boolean)requester.isEnabled(), (Object)"Plugin isn't enabled.");
            LoadedTeam team = this.teamsLoaded.get(teamProgression.getTeamId());
            if (team != null) {
                this.removePluginRequest(team, requester);
            }
        }
    }

    @Contract(pure=true)
    public boolean isLoaded(@NotNull Player player) {
        return this.isLoaded(AdvancementUtils.uuidFromPlayer(player));
    }

    @Contract(pure=true)
    public boolean isLoaded(@NotNull OfflinePlayer player) {
        return this.isLoaded(AdvancementUtils.uuidFromPlayer(player));
    }

    @Contract(pure=true, value="null -> false")
    public synchronized boolean isLoaded(UUID uuid) {
        this.checkClosed();
        LoadedPlayer loadedPlayer = this.playersLoaded.get(uuid);
        return loadedPlayer != null && loadedPlayer.getPlayerTeam() != null;
    }

    @Contract(pure=true)
    public synchronized boolean isLoaded(int teamId) {
        this.checkClosed();
        return this.teamsLoaded.containsKey(teamId);
    }

    @Contract(pure=true)
    public boolean isLoadedAndOnline(@NotNull Player player) {
        return this.isLoadedAndOnline(AdvancementUtils.uuidFromPlayer(player));
    }

    @Contract(pure=true, value="null -> false")
    public synchronized boolean isLoadedAndOnline(UUID uuid) {
        this.checkClosed();
        LoadedPlayer loadedPlayer = this.playersLoaded.get(uuid);
        return loadedPlayer != null && loadedPlayer.getPlayerTeam() != null && loadedPlayer.isOnline();
    }

    @Contract(pure=true)
    public int getLoadingRequestsAmount(@NotNull Player player, @NotNull Plugin requester) {
        return this.getLoadingRequestsAmount(AdvancementUtils.uuidFromPlayer(player), requester);
    }

    @Contract(pure=true)
    public int getLoadingRequestsAmount(@NotNull OfflinePlayer player, @NotNull Plugin requester) {
        return this.getLoadingRequestsAmount(AdvancementUtils.uuidFromPlayer(player), requester);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    public int getLoadingRequestsAmount(@NotNull UUID uuid, @NotNull Plugin requester) {
        this.checkClosed();
        Preconditions.checkNotNull((Object)requester, (Object)"Plugin is null.");
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            Preconditions.checkArgument((boolean)requester.isEnabled(), (Object)"Plugin isn't enabled.");
            LoadedPlayer loadedPlayer = this.playersLoaded.get(uuid);
            if (loadedPlayer == null) {
                return 0;
            }
            return loadedPlayer.getPluginRequests(requester);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    public int getLoadingRequestsAmount(@NotNull TeamProgression teamProgression, @NotNull Plugin requester) {
        this.checkClosed();
        Preconditions.checkNotNull((Object)teamProgression, (Object)"TeamProgression is null.");
        Preconditions.checkNotNull((Object)requester, (Object)"Plugin is null.");
        DatabaseManager databaseManager = this;
        synchronized (databaseManager) {
            Preconditions.checkArgument((boolean)requester.isEnabled(), (Object)"Plugin isn't enabled.");
            LoadedTeam team = this.teamsLoaded.get(teamProgression.getTeamId());
            if (team == null) {
                return 0;
            }
            return team.getPluginRequests(requester);
        }
    }

    @NotNull
    private synchronized LoadedTeam addTeamToCache(TeamProgression progression) {
        LoadedTeam loadedTeam = this.teamsLoaded.computeIfAbsent(progression.getTeamId(), id -> new LoadedTeam(progression));
        if (!progression.inCache.getAndSet(true)) {
            this.callEventCatchingExceptions(new AsyncTeamLoadEvent(progression));
        }
        return loadedTeam;
    }

    @NotNull
    private synchronized LoadedPlayer addPlayerToCache(@NotNull UUID uuid, boolean setOnline) {
        LoadedPlayer loadedPlayer = this.playersLoaded.computeIfAbsent(uuid, LoadedPlayer::new);
        if (setOnline) {
            loadedPlayer.__setOnline(true);
        }
        loadedPlayer.addInternalRequest();
        return loadedPlayer;
    }

    private synchronized void removeInternalRequest(@NotNull LoadedTeam loadedTeam) {
        if (loadedTeam.__removeInternalRequest() == 0 && loadedTeam.canBeUnloaded()) {
            this.unloadTeam(loadedTeam);
        }
    }

    private synchronized void removeInternalRequest(@NotNull LoadedPlayer loadedPlayer) {
        if (loadedPlayer.__removeInternalRequest() == 0 && loadedPlayer.canBeUnloaded()) {
            this.unloadPlayer(loadedPlayer);
        }
    }

    private synchronized void removePluginRequest(@NotNull LoadedTeam loadedTeam, @NotNull Plugin plugin) {
        if (loadedTeam.__removePluginRequest(plugin) == 0 && loadedTeam.canBeUnloaded()) {
            this.unloadTeam(loadedTeam);
        }
    }

    private synchronized void removePluginRequest(@NotNull LoadedPlayer loadedPlayer, @NotNull Plugin plugin) {
        if (loadedPlayer.__removePluginRequest(plugin) == 0 && loadedPlayer.canBeUnloaded()) {
            this.unloadPlayer(loadedPlayer);
        }
    }

    private synchronized void unloadTeam(@NotNull LoadedTeam loadedTeam) {
        TeamProgression teamProgression = loadedTeam.getTeamProgression();
        teamProgression.inCache.set(false);
        this.teamsLoaded.remove(teamProgression.getTeamId());
        this.callEventCatchingExceptions(new AsyncTeamUnloadEvent(teamProgression));
    }

    private synchronized void unloadPlayer(@NotNull LoadedPlayer loadedPlayer) {
        this.playersLoaded.remove(loadedPlayer.getUuid());
        @Nullable LoadedTeam loadedTeam = loadedPlayer.getPlayerTeam();
        loadedPlayer.setPlayerTeam(null);
        if (loadedTeam != null) {
            this.removeInternalRequest(loadedTeam);
        }
    }

    private void setOffline(@NotNull LoadedPlayer loadedPlayer) {
        if (loadedPlayer.__setOnline(false)) {
            this.removeInternalRequest(loadedPlayer);
        }
    }

    private synchronized void updateLoadedPlayerTeam(@NotNull LoadedPlayer player, @NotNull LoadedTeam newTeam) {
        AdvancementUtils.checkSync();
        LoadedTeam oldTeam = player.getPlayerTeam();
        Preconditions.checkArgument((oldTeam != null ? 1 : 0) != 0, (Object)("Player " + String.valueOf(player.getUuid()) + " was being moved but isn't part of a team."));
        oldTeam.getTeamProgression().movePlayer(newTeam.getTeamProgression(), player.getUuid());
        newTeam.addInternalRequest();
        player.setPlayerTeam(newTeam);
        this.callEventCatchingExceptions(new TeamUpdateEvent(player.getUuid(), oldTeam.getTeamProgression(), newTeam.getTeamProgression()));
        this.removeInternalRequest(oldTeam);
    }

    private void registerProgressionUpdate(@NotNull LoadedTeam team, @NotNull AdvancementKey key, int oldProgr, int newProgr, @NotNull CompletableFuture<ProgressionUpdateResult> completableFuture) {
        this.pendingUpdatesManager.registerProgressionUpdate(team, key, oldProgr, newProgr, () -> {
            try {
                this.callEventCatchingExceptions(new ProgressionUpdateEvent(key, team.getTeamProgression(), oldProgr, newProgr, completableFuture));
            }
            finally {
                completableFuture.complete(new ProgressionUpdateResult(oldProgr, newProgr));
            }
        });
    }

    private synchronized <T> void registerTeamUpdate(@NotNull LoadedPlayer player, @Nullable Player playerToMove, @NotNull LoadedTeam team, boolean processUnredeemed, CompletableFuture<T> completableFuture, T completingObj) {
        this.pendingUpdatesManager.registerTeamUpdate(player, team, () -> {
            completableFuture.complete(completingObj);
            AdvancementUtils.checkSync();
            if (playerToMove != null && playerToMove.isOnline()) {
                this.main.updateAdvancementsToTeam(playerToMove);
                if (processUnredeemed) {
                    player.addInternalRequest();
                    this.processUnredeemed(player, playerToMove);
                }
            }
        });
    }

    private CompletableFuture<Void> runAsyncOnExecutor(Runnable runnable) {
        return CompletableFuture.runAsync(() -> {
            if (!this.closed.get()) {
                runnable.run();
            }
        }, this.executor);
    }

    private CompletableFuture<Void> runAsyncOnExecutor(CompletableFuture<?> returnedCompletableFuture, Runnable runnable) {
        Integer key = this.keysOfUncompletedCFs.incrementAndGet();
        this.uncompletedCompletableFutures.put(key, returnedCompletableFuture);
        returnedCompletableFuture.whenComplete((res, err) -> {
            if (!this.closed.get()) {
                this.uncompletedCompletableFutures.remove(key);
            }
        });
        return CompletableFuture.runAsync(() -> {
            if (!this.closed.get()) {
                runnable.run();
            }
        }, this.executor);
    }

    private <E extends Event> void callEventCatchingExceptions(@NotNull E event) {
        try {
            Bukkit.getPluginManager().callEvent(event);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "An exception occurred while calling event " + event.getClass().getSimpleName(), exception);
        }
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new DatabaseManagerClosedException();
        }
    }

    private final class PendingUpdatesManager {
        private final List<Update> progressionUpdates = new ArrayList<Update>(10);
        private final Map<Integer, Map<AdvancementKey, Integer>> realProgressions = new HashMap<Integer, Map<AdvancementKey, Integer>>();
        private boolean updaterTaskIsRegistered = false;
        private BukkitTask task = null;

        private PendingUpdatesManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerTeamUpdate(@NotNull LoadedPlayer player, @NotNull LoadedTeam team, @NotNull Runnable callback) {
            DatabaseManager databaseManager = DatabaseManager.this;
            synchronized (databaseManager) {
                player.addInternalRequest();
                team.addInternalRequest();
                this.progressionUpdates.add(new Update(UpdateType.TEAM_UPDATE, player, team, null, 0, 0, callback));
            }
            this.registerUpdaterTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerPlayerRegisteredUpdate(@NotNull LoadedPlayer player, @NotNull LoadedTeam team, @NotNull Runnable callback) {
            DatabaseManager databaseManager = DatabaseManager.this;
            synchronized (databaseManager) {
                player.addInternalRequest();
                team.addInternalRequest();
                player.setRegistering();
                this.progressionUpdates.add(new Update(UpdateType.PLAYER_REGISTERED_UPDATE, player, team, null, 0, 0, callback));
            }
            this.registerUpdaterTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerProgressionUpdate(@NotNull LoadedTeam team, @NotNull AdvancementKey key, int oldProgr, int newProgr, @NotNull Runnable callback) {
            DatabaseManager databaseManager = DatabaseManager.this;
            synchronized (databaseManager) {
                team.addInternalRequest();
                Map map = this.realProgressions.computeIfAbsent(team.getTeamProgression().getTeamId(), HashMap::new);
                map.put(key, newProgr);
                this.progressionUpdates.add(new Update(UpdateType.PROGRESSION_UPDATE, null, team, key, oldProgr, newProgr, callback));
            }
            this.registerUpdaterTask();
        }

        private synchronized void registerUpdaterTask() {
            if (!this.updaterTaskIsRegistered) {
                this.updaterTaskIsRegistered = true;
                this.task = Bukkit.getScheduler().runTaskTimer(DatabaseManager.this.main.getOwningPlugin(), () -> {
                    if (!DatabaseManager.this.updaterLock.tryLockExclusiveLock()) {
                        return;
                    }
                    try {
                        PendingUpdatesManager pendingUpdatesManager = this;
                        synchronized (pendingUpdatesManager) {
                            block9: {
                                if (this.task != null) break block9;
                                return;
                            }
                            this.updaterTaskIsRegistered = false;
                            this.task.cancel();
                            this.task = null;
                        }
                        DatabaseManager.this.pendingUpdatesManager.applyUpdates();
                    }
                    finally {
                        DatabaseManager.this.updaterLock.unlockExclusiveLock();
                    }
                }, 1L, 1L);
            }
        }

        synchronized void unregisterTask() {
            Preconditions.checkArgument((boolean)DatabaseManager.this.closed.get(), (Object)"DatabaseManager isn't closing.");
            if (this.updaterTaskIsRegistered) {
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
            } else {
                this.updaterTaskIsRegistered = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearUpdates() {
            Preconditions.checkArgument((boolean)DatabaseManager.this.closed.get(), (Object)"DatabaseManager isn't closing.");
            DatabaseManager databaseManager = DatabaseManager.this;
            synchronized (databaseManager) {
                this.progressionUpdates.clear();
                this.realProgressions.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getCurrentValue(@NotNull TeamProgression team, @NotNull AdvancementKey key) {
            DatabaseManager databaseManager = DatabaseManager.this;
            synchronized (databaseManager) {
                Map<AdvancementKey, Integer> map = this.realProgressions.get(team.getTeamId());
                if (map == null) {
                    return team.getRawProgression(key);
                }
                Integer progr = map.get(key);
                int n = progr == null ? team.getRawProgression(key) : progr.intValue();
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void applyUpdates() {
            AdvancementUtils.checkSync();
            DatabaseManager databaseManager = DatabaseManager.this;
            synchronized (databaseManager) {
                if (DatabaseManager.this.closed.get()) {
                    this.progressionUpdates.clear();
                    this.realProgressions.clear();
                    return;
                }
                for (Update update : this.progressionUpdates) {
                    switch (update.type.ordinal()) {
                        case 0: {
                            DatabaseManager.this.updateLoadedPlayerTeam(update.player, update.team);
                            break;
                        }
                        case 1: {
                            if (update.player.getPlayerTeam() != null) {
                                DatabaseManager.this.logger.severe("Player " + String.valueOf(update.player.getUuid()) + " was already loaded: " + String.valueOf(update) + ". This is a UltimateAdvancementAPI bug, please report it here: https://github.com/frengor/UltimateAdvancementAPI/issues");
                            } else {
                                update.team.getTeamProgression().addMember(update.player.getUuid());
                                update.team.addInternalRequest();
                                update.player.setPlayerTeam(update.team);
                                DatabaseManager.this.callEventCatchingExceptions(new PlayerRegisteredEvent(update.team.getTeamProgression(), update.player.getUuid()));
                            }
                            @Nullable CompletableFuture<TeamProgression> cf = update.player.getRegisteringCF();
                            update.player.unsetRegistering();
                            if (cf == null) break;
                            cf.complete(update.player.getPlayerTeam().getTeamProgression());
                            break;
                        }
                        case 2: {
                            update.team.getTeamProgression().updateProgression(update.key, update.newProgr);
                        }
                    }
                    try {
                        update.callback.run();
                    }
                    catch (Exception e) {
                        DatabaseManager.this.logger.log(Level.SEVERE, "An exception occurred while executing the callback for update " + String.valueOf(update), e);
                    }
                    if (update.type == UpdateType.TEAM_UPDATE || update.type == UpdateType.PLAYER_REGISTERED_UPDATE) {
                        DatabaseManager.this.removeInternalRequest(update.player);
                    }
                    DatabaseManager.this.removeInternalRequest(update.team);
                }
                this.progressionUpdates.clear();
                this.realProgressions.clear();
            }
        }

        private record Update(UpdateType type, LoadedPlayer player, LoadedTeam team, AdvancementKey key, int oldProgr, int newProgr, Runnable callback) {
            @Override
            @NotNull
            public String toString() {
                return switch (this.type.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> "TeamUpdate{player=" + String.valueOf(this.player.getUuid()) + ", team=" + this.team.getTeamProgression().getTeamId() + "}";
                    case 1 -> "PlayerRegisteredUpdate{player=" + String.valueOf(this.player.getUuid()) + ", team=" + this.team.getTeamProgression().getTeamId() + "}";
                    case 2 -> "ProgressionUpdate{team=" + this.team.getTeamProgression().getTeamId() + ", key=" + String.valueOf(this.key) + ", oldProgr=" + this.oldProgr + ", newProgr=" + this.newProgr + "}";
                };
            }
        }

        private static enum UpdateType {
            TEAM_UPDATE,
            PLAYER_REGISTERED_UPDATE,
            PROGRESSION_UPDATE;

        }
    }

    private static final class LoadedPlayer
    extends CacheableEntry {
        @Nullable
        private volatile LoadedTeam playerTeam;
        private final UUID uuid;
        private final AtomicBoolean online = new AtomicBoolean(false);
        @Nullable
        private volatile CompletableFuture<TeamProgression> registeringCompletableFuture = null;

        public LoadedPlayer(@NotNull UUID uuid) {
            this.uuid = uuid;
        }

        @NotNull
        public UUID getUuid() {
            return this.uuid;
        }

        @Nullable
        public LoadedTeam getPlayerTeam() {
            return this.playerTeam;
        }

        public void setPlayerTeam(@Nullable LoadedTeam playerTeam) {
            this.playerTeam = playerTeam;
        }

        public boolean isOnline() {
            return this.online.get();
        }

        public boolean __setOnline(boolean online) {
            return this.online.getAndSet(online);
        }

        public CompletableFuture<TeamProgression> getRegisteringCF() {
            return this.registeringCompletableFuture;
        }

        public void setRegistering() {
            this.registeringCompletableFuture = new CompletableFuture();
        }

        public void unsetRegistering() {
            this.registeringCompletableFuture = null;
        }
    }

    private static final class LoadedTeam
    extends CacheableEntry {
        private final TeamProgression teamProgression;

        public LoadedTeam(@NotNull TeamProgression progression) {
            this.teamProgression = progression;
        }

        @NotNull
        public TeamProgression getTeamProgression() {
            return this.teamProgression;
        }
    }

    private static class CacheableEntry {
        private final Map<Plugin, Integer> pluginRequests = new HashMap<Plugin, Integer>();
        private final AtomicInteger internalRequests = new AtomicInteger(0);

        private CacheableEntry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPluginRequest(@NotNull Plugin plugin) {
            Map<Plugin, Integer> map = this.pluginRequests;
            synchronized (map) {
                this.pluginRequests.merge(plugin, 1, Integer::sum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int __removePluginRequest(@NotNull Plugin plugin) {
            Map<Plugin, Integer> map = this.pluginRequests;
            synchronized (map) {
                Integer res = this.pluginRequests.computeIfPresent(plugin, (key, value) -> value <= 1 ? null : Integer.valueOf(value - 1));
                return res == null ? 0 : res;
            }
        }

        public void addInternalRequest() {
            this.internalRequests.incrementAndGet();
        }

        public int __removeInternalRequest() {
            return this.internalRequests.decrementAndGet();
        }

        public int getInternalRequests() {
            return this.internalRequests.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPluginRequests(@NotNull Plugin plugin) {
            Map<Plugin, Integer> map = this.pluginRequests;
            synchronized (map) {
                return this.pluginRequests.getOrDefault(plugin, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int __removeAllPluginRequests(@NotNull Plugin plugin) {
            Map<Plugin, Integer> map = this.pluginRequests;
            synchronized (map) {
                Integer i = this.pluginRequests.remove(plugin);
                return i == null ? 0 : i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPluginRequests() {
            Map<Plugin, Integer> map = this.pluginRequests;
            synchronized (map) {
                return !this.pluginRequests.isEmpty();
            }
        }

        public boolean canBeUnloaded() {
            return this.getInternalRequests() == 0 && !this.hasPluginRequests();
        }
    }
}

