/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.commands;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.AdvancementTab;
import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CommandsCommon<Error extends Exception> {
    private final AdvancementMain main;
    private final CommandAPIMethods<Error> commandAPI;

    public CommandsCommon(@NotNull AdvancementMain main, @NotNull CommandAPIMethods<Error> commandAPI) {
        this.main = Objects.requireNonNull(main, "AdvancementMain is null.");
        this.commandAPI = Objects.requireNonNull(commandAPI, "CommandAPIMethods is null.");
    }

    public void grantAll(CommandSender sender, Player player, boolean giveRewards) throws Error {
        this.grantAll(sender, List.of(player), giveRewards);
    }

    public void grantAll(CommandSender sender, Collection<Player> players, boolean giveRewards) throws Error {
        this.validatePlayerArgument(players);
        boolean failed = false;
        for (AdvancementTab m : this.main.getTabs()) {
            if (!m.isActive()) continue;
            for (Advancement a2 : m.getAdvancements()) {
                for (Player p : players) {
                    failed |= this.runSafely(sender, () -> a2.grant(p, giveRewards), () -> "Could not grant advancement " + String.valueOf(a2) + " to " + p.getName());
                }
            }
        }
        for (Player p : players) {
            if (failed) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not grant every advancement to " + p.getName());
                continue;
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "All advancements have been granted to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    public void grantTab(CommandSender sender, AdvancementTab tab, Player player, boolean giveRewards) throws Error {
        this.grantTab(sender, tab, List.of(player), giveRewards);
    }

    public void grantTab(CommandSender sender, AdvancementTab tab, Collection<Player> players, boolean giveRewards) throws Error {
        this.validatePlayerArgument(players);
        if (!tab.isActive()) {
            throw this.commandAPI.failWithString("Advancement tab is not active.");
        }
        boolean failed = false;
        for (Advancement a2 : tab.getAdvancements()) {
            for (Player p : players) {
                failed |= this.runSafely(sender, () -> a2.grant(p, giveRewards), () -> "Could not grant advancement " + String.valueOf(a2) + " to " + p.getName());
            }
        }
        for (Player p : players) {
            if (failed) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not grant every advancement of tab " + String.valueOf(tab) + " to " + p.getName());
                continue;
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "All advancements of tab " + String.valueOf(ChatColor.YELLOW) + String.valueOf(tab) + String.valueOf(ChatColor.GREEN) + " have been granted to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    public void grantOne(CommandSender sender, Advancement advancement, Player player, boolean giveRewards) throws Error {
        this.grantOne(sender, advancement, List.of(player), giveRewards);
    }

    public void grantOne(CommandSender sender, Advancement advancement, Collection<Player> players, boolean giveRewards) throws Error {
        this.validatePlayerArgument(players);
        for (Player p : players) {
            boolean failed = this.runSafely(sender, () -> {
                advancement.getAdvancementTab().showTab(p);
                advancement.grant(p, giveRewards);
            }, () -> "Could not grant advancement " + String.valueOf(advancement) + " to " + p.getName());
            if (failed) continue;
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Advancement " + String.valueOf(ChatColor.YELLOW) + String.valueOf(advancement.getKey()) + String.valueOf(ChatColor.GREEN) + " has been granted to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    public void revokeAll(CommandSender sender, Player player, boolean hideTabs) throws Error {
        this.revokeAll(sender, List.of(player), hideTabs);
    }

    public void revokeAll(CommandSender sender, Collection<Player> players, boolean hideTabs) throws Error {
        this.validatePlayerArgument(players);
        boolean failed = false;
        for (AdvancementTab m : this.main.getTabs()) {
            Collection<Advancement> advancements = m.getAdvancements();
            for (Player p : players) {
                for (Advancement a2 : advancements) {
                    failed |= this.runSafely(sender, () -> a2.revoke(p), () -> "Could not revoke advancement " + String.valueOf(a2) + " to " + p.getName());
                }
                if (!hideTabs) continue;
                this.runSafely(sender, () -> m.hideTab(p), () -> "Could not hide advancement tab " + String.valueOf(m) + " to " + p.getName());
            }
        }
        for (Player p : players) {
            if (failed) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not revoke every advancement to " + p.getName());
                continue;
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "All advancements have been revoked to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    public void revokeTab(CommandSender sender, AdvancementTab tab, Player player, boolean hideTab) throws Error {
        this.revokeTab(sender, tab, List.of(player), hideTab);
    }

    public void revokeTab(CommandSender sender, AdvancementTab tab, Collection<Player> players, boolean hideTab) throws Error {
        this.validatePlayerArgument(players);
        if (!tab.isActive()) {
            throw this.commandAPI.failWithString("Advancement tab is not active.");
        }
        Collection<Advancement> advancements = tab.getAdvancements();
        for (Player p : players) {
            boolean failed = false;
            for (Advancement a2 : advancements) {
                failed |= this.runSafely(sender, () -> a2.revoke(p), () -> "Could not revoke advancement " + String.valueOf(a2) + " to " + p.getName());
            }
            if (hideTab) {
                this.runSafely(sender, () -> tab.hideTab(p), () -> "Could not hide advancement tab " + String.valueOf(tab) + " to " + p.getName());
            }
            if (failed) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not revoke every advancement of tab " + String.valueOf(tab) + " to " + p.getName());
                continue;
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "All advancements of tab " + String.valueOf(ChatColor.YELLOW) + String.valueOf(tab) + String.valueOf(ChatColor.GREEN) + " have been revoked to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    public void revokeOne(CommandSender sender, Advancement advancement, Player player) throws Error {
        this.revokeOne(sender, advancement, List.of(player));
    }

    public void revokeOne(CommandSender sender, Advancement advancement, Collection<Player> players) throws Error {
        this.validatePlayerArgument(players);
        for (Player p : players) {
            boolean failed = this.runSafely(sender, () -> advancement.revoke(p), () -> "Could not revoke advancement " + String.valueOf(advancement) + " to " + p.getName());
            if (failed) continue;
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Advancement " + String.valueOf(ChatColor.YELLOW) + String.valueOf(advancement) + String.valueOf(ChatColor.GREEN) + " has been revoked to " + String.valueOf(ChatColor.YELLOW) + p.getName());
        }
    }

    public int getProgression(CommandSender sender, Advancement advancement, Player player) throws Error {
        return this.getProgression(sender, advancement, List.of(player));
    }

    public int getProgression(CommandSender sender, Advancement advancement, Collection<Player> players) throws Error {
        this.validatePlayerArgument(players);
        int[] progression = new int[]{0};
        for (Player p : players) {
            boolean failed = this.runSafely(sender, () -> {
                progression[0] = advancement.getProgression(p);
            }, () -> "Could not get " + p.getName() + "'s progression of advancement " + String.valueOf(advancement));
            if (failed) continue;
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + p.getName() + String.valueOf(ChatColor.GREEN) + " progression is " + String.valueOf(ChatColor.YELLOW) + progression[0] + "/" + advancement.getMaxProgression());
        }
        return progression[0];
    }

    public void setProgression(CommandSender sender, Advancement advancement, int progression, Player player, boolean giveRewards) throws Error {
        this.setProgression(sender, advancement, progression, List.of(player), giveRewards);
    }

    public void setProgression(CommandSender sender, Advancement advancement, int progression, Collection<Player> players, boolean giveRewards) throws Error {
        this.validatePlayerArgument(players);
        int progr = Math.min(advancement.getMaxProgression(), progression);
        for (Player p : players) {
            boolean failed = this.runSafely(sender, () -> advancement.setProgression(p, progr, giveRewards), () -> "Could not set " + p.getName() + "'s progression of advancement " + String.valueOf(advancement) + " to " + progr + "/" + advancement.getMaxProgression());
            if (failed) continue;
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Progression of " + String.valueOf(ChatColor.YELLOW) + p.getName() + String.valueOf(ChatColor.GREEN) + " has been set to " + String.valueOf(ChatColor.YELLOW) + progr + "/" + advancement.getMaxProgression());
        }
    }

    private boolean runSafely(CommandSender sender, Runnable action, Supplier<String> errorGenerator) {
        try {
            action.run();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Exception e) {
            String error = errorGenerator.get();
            this.main.getLogger().log(Level.SEVERE, error, e);
            sender.sendMessage(String.valueOf(ChatColor.RED) + error);
            return true;
        }
        return false;
    }

    private void validatePlayerArgument(@NotNull Collection<Player> players) throws Error {
        if (players.isEmpty()) {
            throw this.commandAPI.failWithString("No player has been provided.");
        }
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface CommandAPIMethods<Error extends Exception> {
        public Error failWithString(String var1);
    }
}

