/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement.tasks;

import com.fren_gor.ultimateAdvancementAPI.AdvancementUpdater;
import com.fren_gor.ultimateAdvancementAPI.advancement.BaseAdvancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementDisplayBuilder;
import com.fren_gor.ultimateAdvancementAPI.advancement.tasks.AbstractMultiTasksAdvancement;
import com.fren_gor.ultimateAdvancementAPI.database.DatabaseManager;
import com.fren_gor.ultimateAdvancementAPI.database.ProgressionUpdateResult;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.AdvancementProgressionUpdateEvent;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.ProgressionUpdateEvent;
import com.fren_gor.ultimateAdvancementAPI.exceptions.InvalidAdvancementException;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class TaskAdvancement
extends BaseAdvancement {
    private final Map<CompletableFuture<ProgressionUpdateResult>, Integer> pendingUpdates = new MapMaker().concurrencyLevel(1).weakKeys().makeMap();

    public TaskAdvancement(@NotNull AbstractMultiTasksAdvancement multitask, @NotNull String key) {
        this(multitask, key, 1);
    }

    public TaskAdvancement(@NotNull AbstractMultiTasksAdvancement multitask, @NotNull String key, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) {
        this(multitask, key, maxProgression, (AbstractAdvancementDisplay)new AdvancementDisplayBuilder(Material.GRASS_BLOCK, Objects.requireNonNull(key, "Key is null.")).build());
    }

    public TaskAdvancement(@NotNull AbstractMultiTasksAdvancement multitask, @NotNull String key, @NotNull AbstractAdvancementDisplay display) {
        this(multitask, key, 1, display);
    }

    public TaskAdvancement(@NotNull AbstractMultiTasksAdvancement multitask, @NotNull String key, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression, @NotNull AbstractAdvancementDisplay display) {
        super(Objects.requireNonNull(multitask, "AbstractMultiTasksAdvancement is null."), key, maxProgression, display);
        this.registerEvent(ProgressionUpdateEvent.class, EventPriority.HIGHEST, e -> {
            if (!this.getKey().equals(e.getAdvancementKey())) {
                return;
            }
            this.pendingUpdates.put(e.getUpdateCompletableFuture(), multitask.getProgression(e.getTeamProgression()));
        });
    }

    @Override
    protected CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull TeamProgression pro, @Nullable Player player, int increment, boolean giveRewards) {
        AdvancementUtils.validateTeamProgression(pro);
        DatabaseManager ds = this.advancementTab.getDatabaseManager();
        CompletableFuture<ProgressionUpdateResult> completableFuture = ds.incrementProgression(this.key, pro, increment, this.maxProgression);
        AdvancementUtils.runSync(completableFuture, this.advancementTab.getOwningPlugin(), (result, err) -> {
            if (err != null) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while incrementing the progression of " + String.valueOf(this.key), (Throwable)err);
                return;
            }
            try {
                Bukkit.getPluginManager().callEvent((Event)new AdvancementProgressionUpdateEvent(this, pro, result.oldProgression(), result.newProgression()));
            }
            catch (Exception e) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while calling AdvancementProgressionUpdateEvent for " + String.valueOf(this.key), e);
            }
            try {
                this.handleAdvancementGranting(pro, player, result.newProgression(), result.oldProgression(), giveRewards);
            }
            finally {
                Integer multiTaskProgression = this.pendingUpdates.remove(completableFuture);
                if (multiTaskProgression != null) {
                    this.getMultiTasksAdvancement().onTaskProgressionChange(this, pro, player, (ProgressionUpdateResult)result, multiTaskProgression, giveRewards);
                }
            }
        });
        return completableFuture;
    }

    @Override
    protected CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull TeamProgression pro, @Nullable Player player, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean giveRewards) {
        AdvancementUtils.validateTeamProgression(pro);
        AdvancementUtils.validateProgressionValueStrict(progression, this.maxProgression);
        DatabaseManager ds = this.advancementTab.getDatabaseManager();
        CompletableFuture<ProgressionUpdateResult> completableFuture = ds.setProgression(this.key, pro, progression);
        AdvancementUtils.runSync(completableFuture, this.advancementTab.getOwningPlugin(), (result, err) -> {
            if (err != null) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while setting the progression of " + String.valueOf(this.key), (Throwable)err);
                return;
            }
            try {
                Bukkit.getPluginManager().callEvent((Event)new AdvancementProgressionUpdateEvent(this, pro, result.oldProgression(), result.newProgression()));
            }
            catch (Exception e) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while calling AdvancementProgressionUpdateEvent for " + String.valueOf(this.key), e);
            }
            try {
                this.handleAdvancementGranting(pro, player, result.newProgression(), result.oldProgression(), giveRewards);
            }
            finally {
                Integer multiTaskProgression = this.pendingUpdates.remove(completableFuture);
                if (multiTaskProgression != null) {
                    this.getMultiTasksAdvancement().onTaskProgressionChange(this, pro, player, (ProgressionUpdateResult)result, multiTaskProgression, giveRewards);
                }
            }
        });
        return completableFuture;
    }

    @Override
    @Contract(value="_ -> false")
    public final boolean isVisible(@NotNull Player player) {
        return false;
    }

    @Override
    @Contract(value="_ -> false")
    public final boolean isVisible(@NotNull UUID uuid) {
        return false;
    }

    @Override
    @Contract(value="_ -> false")
    public final boolean isVisible(@NotNull TeamProgression progression) {
        return false;
    }

    @Override
    @Nullable
    @Contract(value="_ -> null")
    public final @Nullable Function<@NotNull Player, @Nullable BaseComponent> getAnnouncementMessage(@NotNull Player advancementCompleter) {
        return null;
    }

    @Override
    protected void sendAnnouncementMessageOnGrant(@NotNull Player advancementCompleter, @NotNull TeamProgression progression) {
    }

    @Override
    protected void displayToastOnGrant(@NotNull Player advancementCompleter, @NotNull TeamProgression progression) {
    }

    @Override
    public boolean isValid() {
        return this.getMultiTasksAdvancement().isValid();
    }

    @NotNull
    public AbstractMultiTasksAdvancement getMultiTasksAdvancement() {
        return (AbstractMultiTasksAdvancement)this.parent;
    }

    @Override
    public void validateRegister() throws InvalidAdvancementException {
        throw new InvalidAdvancementException("TaskAdvancements cannot be registered in any AdvancementTab.");
    }

    @Override
    @NotNull
    public final PreparedAdvancementWrapper getNMSWrapper() throws ReflectiveOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void displayToastToPlayer(@NotNull Player player) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onUpdate(@NotNull TeamProgression teamProgression, @NotNull AdvancementUpdater advancementUpdater) throws ReflectiveOperationException {
        throw new UnsupportedOperationException();
    }
}

