/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement.tasks;

import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.tasks.AbstractMultiTasksAdvancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.tasks.TaskAdvancement;
import com.fren_gor.ultimateAdvancementAPI.database.ProgressionUpdateResult;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.AdvancementProgressionUpdateEvent;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.ProgressionUpdateEvent;
import com.fren_gor.ultimateAdvancementAPI.events.team.AsyncTeamUnloadEvent;
import com.fren_gor.ultimateAdvancementAPI.exceptions.ArbitraryMultiTaskProgressionUpdateException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.InvalidAdvancementException;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.UnmodifiableView;

public class MultiTasksAdvancement
extends AbstractMultiTasksAdvancement {
    private final Set<TaskAdvancement> tasks = new HashSet<TaskAdvancement>();
    private Set<AdvancementKey> tasksKeys = Collections.emptySet();
    private final Map<Integer, Integer> progressionsCache = Collections.synchronizedMap(new HashMap());
    private boolean initialised = false;

    public MultiTasksAdvancement(@NotNull Advancement parent, @NotNull String key, @NotNull AbstractAdvancementDisplay display) {
        this(parent, key, 1, display);
    }

    public MultiTasksAdvancement(@NotNull Advancement parent, @NotNull String key, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression, @NotNull AbstractAdvancementDisplay display) {
        super(parent, key, maxProgression, display);
    }

    public void registerTasks(TaskAdvancement ... tasks) {
        this.registerTasks(Sets.newHashSet((Object[])Objects.requireNonNull(tasks)));
    }

    public void registerTasks(@NotNull Set<TaskAdvancement> tasks) {
        if (this.initialised) {
            throw new IllegalStateException("MultiTaskAdvancement is already initialised.");
        }
        AdvancementUtils.checkSync();
        Preconditions.checkNotNull(tasks, (Object)"Set<TaskAdvancement> is null.");
        int progression = 0;
        for (TaskAdvancement t : tasks) {
            if (t == null) {
                throw new NullPointerException("A TaskAdvancement is null.");
            }
            if (t.getMultiTasksAdvancement() != this) {
                throw new IllegalArgumentException("TaskAdvancement's AbstractMultiTasksAdvancement (" + String.valueOf(t.getMultiTasksAdvancement().getKey()) + ") doesn't match with this MultiTasksAdvancement (" + String.valueOf(this.key) + ").");
            }
            progression += t.getMaxProgression();
        }
        if (progression != this.maxProgression) {
            throw new IllegalArgumentException("Expected max progression (" + this.maxProgression + ") doesn't match the tasks' total one (" + progression + ").");
        }
        this.tasks.addAll(tasks);
        this.tasksKeys = tasks.stream().map(Advancement::getKey).collect(Collectors.toUnmodifiableSet());
        this.registerEvent(AsyncTeamUnloadEvent.class, EventPriority.HIGHEST, e -> this.progressionsCache.remove(e.getTeamProgression().getTeamId()));
        this.registerEvent(ProgressionUpdateEvent.class, EventPriority.LOW, e -> {
            if (!this.tasksKeys.contains(e.getAdvancementKey())) {
                return;
            }
            this.resetProgressionCache(e.getTeamProgression());
        });
        this.initialised = true;
    }

    @NotNull
    public @NotNull @UnmodifiableView Set<@NotNull TaskAdvancement> getTasks() {
        this.checkInitialisation();
        return Collections.unmodifiableSet(this.tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Range(from=0L, to=0x7FFFFFFFL) int getProgression(@NotNull TeamProgression progression) {
        this.checkInitialisation();
        AdvancementUtils.validateTeamProgression(progression);
        Map<Integer, Integer> map = this.progressionsCache;
        synchronized (map) {
            Integer progr = this.progressionsCache.get(progression.getTeamId());
            if (progr == null) {
                int c = 0;
                for (TaskAdvancement t : this.tasks) {
                    c += progression.getProgression(t);
                }
                this.progressionsCache.put(progression.getTeamId(), c);
                return c;
            }
            return progr;
        }
    }

    @Override
    public boolean isGranted(@NotNull TeamProgression pro) {
        this.checkInitialisation();
        return super.isGranted(pro);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player) {
        return super.incrementProgression(player);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player, boolean giveReward) {
        return super.incrementProgression(player, giveReward);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player, int increment) {
        return super.incrementProgression(player, increment);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player, int increment, boolean giveReward) {
        return super.incrementProgression(player, increment, giveReward);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid) {
        return super.incrementProgression(uuid);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid, boolean giveReward) {
        return super.incrementProgression(uuid, giveReward);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid, int increment) {
        return super.incrementProgression(uuid, increment);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid, int increment, boolean giveReward) {
        return super.incrementProgression(uuid, increment, giveReward);
    }

    @Override
    protected CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull TeamProgression progression, @Nullable Player player, int increment, boolean giveRewards) throws ArbitraryMultiTaskProgressionUpdateException {
        this.checkInitialisation();
        AdvancementUtils.validateTeamProgression(progression);
        if (increment != 0) {
            throw new ArbitraryMultiTaskProgressionUpdateException();
        }
        CompletableFuture<ProgressionUpdateResult> completableFuture = new CompletableFuture<ProgressionUpdateResult>();
        TaskAdvancement task = this.tasks.iterator().next();
        CompletableFuture<ProgressionUpdateResult> res = task.incrementProgression(progression, player, 0, giveRewards);
        AdvancementUtils.runSync(res, this.getAdvancementTab().getOwningPlugin(), (result, err) -> {
            if (err != null) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while incrementing the progression of multi-task " + String.valueOf(this.key), (Throwable)err);
                completableFuture.completeExceptionally((Throwable)err);
                return;
            }
            int progr = 0;
            try {
                progr = this.getProgression(progression);
            }
            catch (Exception e) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while processing the result of incrementProgression of multi-task " + String.valueOf(this.key), e);
                completableFuture.completeExceptionally(e);
            }
            finally {
                completableFuture.complete(new ProgressionUpdateResult(progr, progr));
            }
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull Player player, @Range(from=0L, to=0x7FFFFFFFL) int progression) {
        return super.setProgression(player, progression);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull Player player, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean giveReward) {
        return super.setProgression(player, progression, giveReward);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull UUID uuid, @Range(from=0L, to=0x7FFFFFFFL) int progression) {
        return super.setProgression(uuid, progression);
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull UUID uuid, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean giveReward) {
        return super.setProgression(uuid, progression, giveReward);
    }

    @Override
    protected CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull TeamProgression progression, @Nullable Player player, @Range(from=0L, to=0x7FFFFFFFL) int newProgression, boolean giveRewards) throws ArbitraryMultiTaskProgressionUpdateException {
        this.checkInitialisation();
        AdvancementUtils.validateTeamProgression(progression);
        AdvancementUtils.validateProgressionValueStrict(newProgression, this.maxProgression);
        CompletableFuture[] results = new CompletableFuture[this.tasks.size()];
        int i = 0;
        if (newProgression == this.maxProgression) {
            for (TaskAdvancement t : this.tasks) {
                results[i++] = t.setProgression(progression, player, t.getMaxProgression(), giveRewards);
            }
        } else if (newProgression == 0) {
            for (TaskAdvancement t : this.tasks) {
                results[i++] = t.setProgression(progression, player, 0, giveRewards);
            }
        } else {
            throw new ArbitraryMultiTaskProgressionUpdateException();
        }
        CompletableFuture<ProgressionUpdateResult> completableFuture = new CompletableFuture<ProgressionUpdateResult>();
        CompletableFuture.allOf(results).whenComplete((result, err) -> {
            if (err != null) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while setting the progression of multi-task " + String.valueOf(this.key), (Throwable)err);
                completableFuture.completeExceptionally((Throwable)err);
                return;
            }
            int oldProgr = 0;
            int newProgr = 0;
            try {
                for (CompletableFuture res : results) {
                    ProgressionUpdateResult progr = (ProgressionUpdateResult)res.get(0L, TimeUnit.SECONDS);
                    oldProgr += progr.oldProgression();
                    newProgr += progr.newProgression();
                }
            }
            catch (Exception e) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while processing the result of setProgression of multi-task " + String.valueOf(this.key), e);
                completableFuture.completeExceptionally(e);
            }
            finally {
                completableFuture.complete(new ProgressionUpdateResult(oldProgr, newProgr));
            }
        });
        return completableFuture;
    }

    @Override
    protected void onTaskProgressionChange(@NotNull Advancement task, @NotNull TeamProgression progression, @Nullable Player player, @NotNull ProgressionUpdateResult result, int multiTaskProgression, boolean giveRewards) {
        this.checkInitialisation();
        AdvancementUtils.checkSync();
        AdvancementUtils.validateTeamProgression(progression);
        Preconditions.checkNotNull((Object)task, (Object)"Task is null");
        Preconditions.checkNotNull((Object)result, (Object)"ProgressionUpdateResult is null");
        Preconditions.checkArgument((boolean)this.tasksKeys.contains(task.getKey()), (Object)(String.valueOf(task.getKey()) + " is not a TaskAdvancement of this MultiTaskAdvancement (" + String.valueOf(this.getKey()) + ")"));
        AdvancementUtils.validateProgressionValueStrict(multiTaskProgression, this.maxProgression);
        AdvancementUtils.validateProgressionValueStrict(result.newProgression(), task.getMaxProgression());
        AdvancementUtils.validateProgressionValueStrict(result.oldProgression(), task.getMaxProgression());
        int oldMultiTaskProgression = multiTaskProgression - (result.newProgression() - result.oldProgression());
        AdvancementUtils.validateProgressionValueStrict(oldMultiTaskProgression, this.maxProgression);
        try {
            Bukkit.getPluginManager().callEvent((Event)new AdvancementProgressionUpdateEvent(this, progression, oldMultiTaskProgression, multiTaskProgression));
        }
        catch (Exception e) {
            this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while calling AdvancementProgressionUpdateEvent for " + String.valueOf(this.key), e);
        }
        this.handleAdvancementGranting(progression, player, multiTaskProgression, oldMultiTaskProgression, giveRewards);
        this.handleAdvancementUpdatingToTeam(progression, multiTaskProgression, oldMultiTaskProgression);
    }

    public void resetProgressionCache() {
        this.progressionsCache.clear();
    }

    public void resetProgressionCache(@NotNull TeamProgression pro) {
        AdvancementUtils.validateTeamProgression(pro);
        this.progressionsCache.remove(pro.getTeamId());
    }

    private void checkInitialisation() {
        if (!this.initialised) {
            throw new IllegalStateException("MultiTasksAdvancement hasn't been initialised yet.");
        }
    }

    @Override
    public void validateRegister() throws InvalidAdvancementException {
        if (!this.initialised) {
            throw new InvalidAdvancementException("MultiTasksAdvancement hasn't been initialised yet.");
        }
    }

    @Override
    public void onDispose() {
        this.checkInitialisation();
        for (TaskAdvancement t : this.tasks) {
            t.onDispose();
        }
        this.progressionsCache.clear();
        super.onDispose();
    }

    public boolean isInitialised() {
        return this.initialised;
    }
}

