/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement.tasks;

import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.BaseAdvancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.database.ProgressionUpdateResult;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class AbstractMultiTasksAdvancement
extends BaseAdvancement {
    public AbstractMultiTasksAdvancement(@NotNull Advancement parent, @NotNull String key, @NotNull AbstractAdvancementDisplay display) {
        this(parent, key, 1, display);
    }

    public AbstractMultiTasksAdvancement(@NotNull Advancement parent, @NotNull String key, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression, @NotNull AbstractAdvancementDisplay display) {
        super(parent, key, maxProgression, display);
    }

    public void onTaskProgressionChange(@NotNull Advancement task, @NotNull Player player, @NotNull ProgressionUpdateResult result, int multiTaskProgression) {
        this.onTaskProgressionChange(task, player, result, multiTaskProgression, true);
    }

    public void onTaskProgressionChange(@NotNull Advancement task, @NotNull UUID uuid, @NotNull ProgressionUpdateResult result, int multiTaskProgression) {
        this.onTaskProgressionChange(task, uuid, result, multiTaskProgression, true);
    }

    public void onTaskProgressionChange(@NotNull Advancement task, @NotNull Player player, @NotNull ProgressionUpdateResult result, int multiTaskProgression, boolean giveRewards) {
        this.onTaskProgressionChange(task, AdvancementUtils.progressionFromPlayer(player, this), player, result, multiTaskProgression, giveRewards);
    }

    public void onTaskProgressionChange(@NotNull Advancement task, @NotNull UUID uuid, @NotNull ProgressionUpdateResult result, int multiTaskProgression, boolean giveRewards) {
        this.onTaskProgressionChange(task, AdvancementUtils.progressionFromUUID(uuid, this), Bukkit.getPlayer((UUID)uuid), result, multiTaskProgression, giveRewards);
    }

    protected abstract void onTaskProgressionChange(@NotNull Advancement var1, @NotNull TeamProgression var2, @Nullable Player var3, @NotNull ProgressionUpdateResult var4, int var5, boolean var6);
}

