/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement.display;

import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementFrameTypeWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.display.DefaultStyle;
import java.util.Objects;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.NotNull;

public enum AdvancementFrameType {
    TASK(AdvancementFrameTypeWrapper.TASK, new DefaultStyle(ChatColor.GREEN), "has made the advancement"),
    GOAL(AdvancementFrameTypeWrapper.GOAL, new DefaultStyle(ChatColor.GREEN), "has reached the goal"),
    CHALLENGE(AdvancementFrameTypeWrapper.CHALLENGE, new DefaultStyle(ChatColor.DARK_PURPLE), "has completed the challenge");

    private final AdvancementFrameTypeWrapper wrapper;
    private final DefaultStyle style;
    private final String chatText;

    private AdvancementFrameType(@NotNull AdvancementFrameTypeWrapper wrapper, DefaultStyle style, String chatText) {
        this.wrapper = Objects.requireNonNull(wrapper);
        this.style = Objects.requireNonNull(style);
        this.chatText = Objects.requireNonNull(chatText);
    }

    @NotNull
    public static AdvancementFrameType fromNMS(@NotNull AdvancementFrameTypeWrapper nms) {
        for (AdvancementFrameType a : AdvancementFrameType.values()) {
            if (!a.wrapper.equals(nms)) continue;
            return a;
        }
        throw new IllegalArgumentException(String.valueOf(nms) + " isn't a valid enum constant.");
    }

    @NotNull
    public AdvancementFrameTypeWrapper getNMSWrapper() {
        return this.wrapper;
    }

    @NotNull
    public DefaultStyle getStyle() {
        return this.style;
    }

    @NotNull
    public String getChatText() {
        return this.chatText;
    }
}

