/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement.display;

import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementFrameType;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.fren_gor.ultimateAdvancementAPI.util.CoordAdapter;
import com.fren_gor.ultimateAdvancementAPI.util.display.DefaultStyle;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class AdvancementDisplayBuilder {
    @NotNull
    protected ItemStack icon;
    @NotNull
    protected BaseComponent title;
    @NotNull
    protected DefaultStyle defaultTitleStyle = DefaultStyle.MINECRAFT_DEFAULTS;
    @NotNull
    protected DefaultStyle announcementMessageDefaultTitleStyle = DefaultStyle.MINECRAFT_DEFAULTS;
    @NotNull
    protected @Unmodifiable List<BaseComponent> description = List.of();
    @NotNull
    protected DefaultStyle defaultDescriptionStyle = DefaultStyle.MINECRAFT_DEFAULTS;
    @NotNull
    protected DefaultStyle announcementMessageDefaultDescriptionStyle = DefaultStyle.MINECRAFT_DEFAULTS;
    @NotNull
    protected AdvancementFrameType frame = AdvancementFrameType.TASK;
    protected boolean showToast = false;
    protected boolean announceChat = false;
    protected float x = 0.0f;
    protected float y = 0.0f;

    public AdvancementDisplayBuilder(@NotNull Material icon, @NotNull String legacyTitle) {
        this(icon, AdvancementUtils.fromLegacy(Objects.requireNonNull(legacyTitle, "Title is null.")));
    }

    public AdvancementDisplayBuilder(@NotNull ItemStack icon, @NotNull String legacyTitle) {
        this(icon, AdvancementUtils.fromLegacy(Objects.requireNonNull(legacyTitle, "Title is null.")));
    }

    public AdvancementDisplayBuilder(@NotNull Material icon, @NotNull BaseComponent title) {
        this.icon = new ItemStack(Objects.requireNonNull(icon, "Icon is null."));
        this.title = Objects.requireNonNull(title, "Title is null.").duplicate();
    }

    public AdvancementDisplayBuilder(@NotNull ItemStack icon, @NotNull BaseComponent title) {
        this.icon = Objects.requireNonNull(icon, "Icon is null.").clone();
        this.title = Objects.requireNonNull(title, "Title is null.").duplicate();
    }

    @NotNull
    public AdvancementDisplayBuilder coords(@NotNull CoordAdapter adapter, @NotNull AdvancementKey key) {
        Preconditions.checkNotNull((Object)adapter, (Object)"CoordAdapter is null.");
        CoordAdapter.Coord coord = adapter.getXAndY(Objects.requireNonNull(key, "AdvancementKey is null."));
        this.coords(coord.x(), coord.y());
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder coords(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder x(float x) {
        Preconditions.checkArgument((x >= 0.0f ? 1 : 0) != 0, (Object)"x is not zero or positive.");
        this.x = x;
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder y(float y) {
        Preconditions.checkArgument((y >= 0.0f ? 1 : 0) != 0, (Object)"y is not zero or positive.");
        this.y = y;
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder icon(@NotNull Material icon) {
        this.icon = new ItemStack(Objects.requireNonNull(icon, "Icon is null."));
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder icon(@NotNull ItemStack icon) {
        this.icon = Objects.requireNonNull(icon, "Icon is null.").clone();
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder title(@NotNull String legacyTitle) {
        this.title = AdvancementUtils.fromLegacy(Objects.requireNonNull(legacyTitle, "Title is null."));
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder title(@NotNull BaseComponent title) {
        this.title = Objects.requireNonNull(title, "Title is null.").duplicate();
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder description(String ... legacyDescription) {
        Preconditions.checkNotNull((Object)legacyDescription, (Object)"Description is null.");
        this.description = Arrays.stream(legacyDescription).map(AdvancementUtils::fromLegacy).toList();
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder description(BaseComponent ... description) {
        Preconditions.checkNotNull((Object)description, (Object)"Description is null.");
        this.description = Arrays.stream(description).map(BaseComponent::duplicate).toList();
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder description(@NotNull List<BaseComponent> description) {
        Preconditions.checkNotNull(description, (Object)"Description is null.");
        this.description = description.stream().map(BaseComponent::duplicate).toList();
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder frame(@NotNull AdvancementFrameType frame) {
        this.frame = Objects.requireNonNull(frame, "Frame is null.");
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder taskFrame() {
        return this.frame(AdvancementFrameType.TASK);
    }

    @NotNull
    public AdvancementDisplayBuilder goalFrame() {
        return this.frame(AdvancementFrameType.GOAL);
    }

    @NotNull
    public AdvancementDisplayBuilder challengeFrame() {
        return this.frame(AdvancementFrameType.CHALLENGE);
    }

    @NotNull
    public AdvancementDisplayBuilder showToast() {
        return this.showToast(true);
    }

    public AdvancementDisplayBuilder showToast(boolean showToast) {
        this.showToast = showToast;
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder announceChat() {
        return this.announceChat(true);
    }

    @NotNull
    public AdvancementDisplayBuilder announceChat(boolean announceChat) {
        this.announceChat = announceChat;
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder defaultTitleStyle(@NotNull DefaultStyle defaultStyle) {
        this.defaultTitleStyle = Objects.requireNonNull(defaultStyle, "DefaultStyle is null.");
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder announcementMessageDefaultTitleStyle(@NotNull DefaultStyle defaultStyle) {
        this.announcementMessageDefaultTitleStyle = Objects.requireNonNull(defaultStyle, "DefaultStyle is null.");
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder defaultDescriptionStyle(@NotNull DefaultStyle defaultStyle) {
        this.defaultDescriptionStyle = Objects.requireNonNull(defaultStyle, "DefaultStyle is null.");
        return this;
    }

    @NotNull
    public AdvancementDisplayBuilder announcementMessageDefaultDescriptionStyle(@NotNull DefaultStyle defaultStyle) {
        this.announcementMessageDefaultDescriptionStyle = Objects.requireNonNull(defaultStyle, "DefaultStyle is null.");
        return this;
    }

    @NotNull
    public AdvancementDisplay build() {
        return new AdvancementDisplay(this.icon, this.title, this.description, this.defaultTitleStyle, this.announcementMessageDefaultTitleStyle, this.defaultDescriptionStyle, this.announcementMessageDefaultDescriptionStyle, this.frame, this.showToast, this.announceChat, this.x, this.y);
    }

    @NotNull
    public ItemStack getIcon() {
        return this.icon.clone();
    }

    @NotNull
    public String getLegacyTitle() {
        return TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{this.title});
    }

    @NotNull
    public BaseComponent getTitle() {
        return this.title.duplicate();
    }

    @NotNull
    public @Unmodifiable List<String> getLegacyDescription() {
        return this.description.stream().map(xva$0 -> TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{xva$0})).toList();
    }

    @NotNull
    public @Unmodifiable List<BaseComponent> getDescription() {
        return this.description.stream().map(BaseComponent::duplicate).toList();
    }

    @NotNull
    public AdvancementFrameType getFrame() {
        return this.frame;
    }

    public boolean doesShowToast() {
        return this.showToast;
    }

    public boolean doesAnnounceToChat() {
        return this.announceChat;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    @NotNull
    public DefaultStyle getDefaultTitleStyle() {
        return this.defaultTitleStyle;
    }

    @NotNull
    public DefaultStyle getAnnouncementMessageDefaultTitleStyle() {
        return this.announcementMessageDefaultTitleStyle;
    }

    @NotNull
    public DefaultStyle getDefaultDescriptionStyle() {
        return this.defaultDescriptionStyle;
    }

    @NotNull
    public DefaultStyle getAnnouncementMessageDefaultDescriptionStyle() {
        return this.announcementMessageDefaultDescriptionStyle;
    }
}

