/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement.display;

import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractImmutableAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementFrameType;
import com.fren_gor.ultimateAdvancementAPI.util.display.DefaultStyle;
import com.google.common.base.Preconditions;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class AdvancementDisplay
extends AbstractImmutableAdvancementDisplay {
    @NotNull
    protected final ItemStack icon;
    @NotNull
    protected final BaseComponent title;
    @NotNull
    protected final DefaultStyle defaultTitleStyle;
    @NotNull
    protected final DefaultStyle announcementMessageDefaultTitleStyle;
    protected final @Unmodifiable List<BaseComponent> description;
    @NotNull
    protected final DefaultStyle defaultDescriptionStyle;
    @NotNull
    protected final DefaultStyle announcementMessageDefaultDescriptionStyle;
    @NotNull
    protected final AdvancementFrameType frame;
    protected final boolean showToast;
    protected final boolean announceChat;
    protected final float x;
    protected final float y;

    protected AdvancementDisplay(@NotNull ItemStack icon, @NotNull BaseComponent title, @NotNull List<BaseComponent> description, @NotNull DefaultStyle defaultTitleStyle, @NotNull DefaultStyle amDefaultTitleStyle, @NotNull DefaultStyle defaultDescStyle, @NotNull DefaultStyle amDefaultDescStyle, @NotNull AdvancementFrameType frame, boolean showToast, boolean announceChat, float x, float y) {
        Preconditions.checkNotNull((Object)icon, (Object)"Icon is null.");
        Preconditions.checkNotNull((Object)title, (Object)"Title is null.");
        Preconditions.checkNotNull((Object)((Object)frame), (Object)"Frame is null.");
        Preconditions.checkNotNull(description, (Object)"Description is null.");
        Preconditions.checkNotNull((Object)defaultTitleStyle, (Object)"Default title style is null.");
        Preconditions.checkNotNull((Object)amDefaultTitleStyle, (Object)"Default announcement message title style is null.");
        Preconditions.checkNotNull((Object)defaultDescStyle, (Object)"Default description style is null.");
        Preconditions.checkNotNull((Object)amDefaultDescStyle, (Object)"Default announcement message description style is null.");
        Preconditions.checkArgument((boolean)Float.isFinite(x), (Object)"x is NaN or infinite.");
        Preconditions.checkArgument((boolean)Float.isFinite(y), (Object)"y is NaN or infinite.");
        Preconditions.checkArgument((x >= 0.0f ? 1 : 0) != 0, (Object)"x is not zero or positive.");
        Preconditions.checkArgument((y >= 0.0f ? 1 : 0) != 0, (Object)"y is not zero or positive.");
        this.icon = icon.clone();
        this.title = title.duplicate();
        this.defaultTitleStyle = defaultTitleStyle;
        this.announcementMessageDefaultTitleStyle = amDefaultTitleStyle;
        this.description = description.stream().map(BaseComponent::duplicate).toList();
        this.defaultDescriptionStyle = defaultDescStyle;
        this.announcementMessageDefaultDescriptionStyle = amDefaultDescStyle;
        this.frame = frame;
        this.showToast = showToast;
        this.announceChat = announceChat;
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean doesShowToast() {
        return this.showToast;
    }

    @Override
    public boolean doesAnnounceToChat() {
        return this.announceChat;
    }

    @Override
    @NotNull
    public ItemStack getIcon() {
        return this.icon.clone();
    }

    @Override
    @NotNull
    public BaseComponent getTitle() {
        return this.title.duplicate();
    }

    @Override
    @NotNull
    public DefaultStyle getDefaultTitleStyle() {
        return this.defaultTitleStyle;
    }

    @Override
    @NotNull
    public DefaultStyle getAnnouncementMessageDefaultTitleStyle() {
        return this.announcementMessageDefaultTitleStyle;
    }

    @Override
    @NotNull
    public @Unmodifiable List<BaseComponent> getDescription() {
        return this.description.stream().map(BaseComponent::duplicate).toList();
    }

    @Override
    @NotNull
    public DefaultStyle getDefaultDescriptionStyle() {
        return this.defaultDescriptionStyle;
    }

    @Override
    @NotNull
    public DefaultStyle getAnnouncementMessageDefaultDescriptionStyle() {
        return this.announcementMessageDefaultDescriptionStyle;
    }

    @Override
    @NotNull
    public AdvancementFrameType getFrame() {
        return this.frame;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }
}

