/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement.display;

import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementFrameType;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.fren_gor.ultimateAdvancementAPI.util.LazyValue;
import com.fren_gor.ultimateAdvancementAPI.util.display.DefaultStyle;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractImmutableAdvancementDisplay
extends AbstractAdvancementDisplay {
    @LazyValue
    private PreparedAdvancementDisplayWrapper wrapper;

    public abstract boolean doesShowToast();

    public abstract boolean doesAnnounceToChat();

    @NotNull
    public abstract ItemStack getIcon();

    @NotNull
    public String getLegacyTitle() {
        return TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{this.getTitle()});
    }

    @NotNull
    public abstract BaseComponent getTitle();

    @NotNull
    public DefaultStyle getDefaultTitleStyle() {
        return DefaultStyle.MINECRAFT_DEFAULTS;
    }

    @NotNull
    public DefaultStyle getAnnouncementMessageDefaultTitleStyle() {
        return DefaultStyle.MINECRAFT_DEFAULTS;
    }

    @NotNull
    public @Unmodifiable List<String> getLegacyDescription() {
        return this.getDescription().stream().map(xva$0 -> TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{xva$0})).toList();
    }

    @NotNull
    public abstract @Unmodifiable List<BaseComponent> getDescription();

    @NotNull
    public DefaultStyle getDefaultDescriptionStyle() {
        return DefaultStyle.MINECRAFT_DEFAULTS;
    }

    @NotNull
    public DefaultStyle getAnnouncementMessageDefaultDescriptionStyle() {
        return DefaultStyle.MINECRAFT_DEFAULTS;
    }

    @NotNull
    public abstract AdvancementFrameType getFrame();

    public abstract float getX();

    public abstract float getY();

    @NotNull
    public PreparedAdvancementDisplayWrapper getNMSWrapper() throws ReflectiveOperationException {
        if (this.wrapper != null) {
            return this.wrapper;
        }
        BaseComponent title = AdvancementUtils.applyDefaultStyle(this.getTitle(), this.getDefaultTitleStyle());
        BaseComponent description = AdvancementUtils.joinBaseComponents((BaseComponent)new TextComponent("\n"), this.getDefaultDescriptionStyle(), this.getDescription());
        this.wrapper = PreparedAdvancementDisplayWrapper.craft(this.getIcon(), title, description, this.getFrame().getNMSWrapper(), this.getX(), this.getY());
        return this.wrapper;
    }

    @Override
    public final boolean dispatchDoesShowToast(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.doesShowToast();
    }

    @Override
    public final boolean dispatchDoesShowToast(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.doesShowToast();
    }

    @Override
    public final boolean dispatchDoesAnnounceToChat(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.doesAnnounceToChat();
    }

    @Override
    public final boolean dispatchDoesAnnounceToChat(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.doesAnnounceToChat();
    }

    @Override
    @NotNull
    public final ItemStack dispatchGetIcon(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getIcon();
    }

    @Override
    @NotNull
    public final ItemStack dispatchGetIcon(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getIcon();
    }

    @Override
    @NotNull
    public final String dispatchGetLegacyTitle(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getLegacyTitle();
    }

    @Override
    @NotNull
    public final String dispatchGetLegacyTitle(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getLegacyTitle();
    }

    @Override
    @NotNull
    public final BaseComponent dispatchGetTitle(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getTitle();
    }

    @Override
    @NotNull
    public final BaseComponent dispatchGetTitle(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getTitle();
    }

    @Override
    @NotNull
    public final DefaultStyle dispatchGetDefaultTitleStyle(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getDefaultTitleStyle();
    }

    @Override
    @NotNull
    public final DefaultStyle dispatchGetDefaultTitleStyle(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getDefaultTitleStyle();
    }

    @Override
    @NotNull
    public final DefaultStyle dispatchGetAnnouncementMessageDefaultTitleStyle(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getAnnouncementMessageDefaultTitleStyle();
    }

    @Override
    @NotNull
    public final DefaultStyle dispatchGetAnnouncementMessageDefaultTitleStyle(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getAnnouncementMessageDefaultTitleStyle();
    }

    @Override
    @NotNull
    public final @Unmodifiable List<String> dispatchGetLegacyDescription(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getLegacyDescription();
    }

    @Override
    @NotNull
    public final @Unmodifiable List<String> dispatchGetLegacyDescription(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getLegacyDescription();
    }

    @Override
    @NotNull
    public final @Unmodifiable List<BaseComponent> dispatchGetDescription(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getDescription();
    }

    @Override
    @NotNull
    public final @Unmodifiable List<BaseComponent> dispatchGetDescription(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getDescription();
    }

    @Override
    @NotNull
    public final DefaultStyle dispatchGetDefaultDescriptionStyle(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getDefaultDescriptionStyle();
    }

    @Override
    @NotNull
    public final DefaultStyle dispatchGetDefaultDescriptionStyle(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getDefaultDescriptionStyle();
    }

    @Override
    @NotNull
    public final DefaultStyle dispatchGetAnnouncementMessageDefaultDescriptionStyle(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getAnnouncementMessageDefaultDescriptionStyle();
    }

    @Override
    @NotNull
    public final DefaultStyle dispatchGetAnnouncementMessageDefaultDescriptionStyle(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getAnnouncementMessageDefaultDescriptionStyle();
    }

    @Override
    @NotNull
    public final AdvancementFrameType dispatchGetFrame(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getFrame();
    }

    @Override
    @NotNull
    public final AdvancementFrameType dispatchGetFrame(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getFrame();
    }

    @Override
    public final float dispatchGetX(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getX();
    }

    @Override
    public final float dispatchGetX(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getX();
    }

    @Override
    public final float dispatchGetY(@NotNull Player player, @NotNull TeamProgression teamProgression) {
        return this.getY();
    }

    @Override
    public final float dispatchGetY(@NotNull OfflinePlayer player, @NotNull TeamProgression teamProgression) {
        return this.getY();
    }

    @Override
    @NotNull
    public final PreparedAdvancementDisplayWrapper dispatchGetNMSWrapper(@NotNull Player player, @NotNull TeamProgression teamProgression) throws ReflectiveOperationException {
        return this.getNMSWrapper();
    }
}

