/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement;

import com.fren_gor.ultimateAdvancementAPI.AdvancementTab;
import com.fren_gor.ultimateAdvancementAPI.AdvancementUpdater;
import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.LazyValue;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class RootAdvancement
extends Advancement {
    @LazyValue
    private PreparedAdvancementWrapper wrapper;

    public RootAdvancement(@NotNull AdvancementTab advancementTab, @NotNull String key, @NotNull AbstractAdvancementDisplay display) {
        this(advancementTab, key, 1, display);
    }

    public RootAdvancement(@NotNull AdvancementTab advancementTab, @NotNull String key, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression, @NotNull AbstractAdvancementDisplay display) {
        super(advancementTab, key, maxProgression, display);
    }

    @Override
    public void onUpdate(@NotNull TeamProgression teamProgression, @NotNull AdvancementUpdater advancementUpdater) throws ReflectiveOperationException {
        advancementUpdater.addRootAdvancement(this.getNMSWrapper(), this.display, this.getProgression(teamProgression));
    }

    @Override
    @NotNull
    public PreparedAdvancementWrapper getNMSWrapper() throws ReflectiveOperationException {
        if (this.wrapper != null) {
            return this.wrapper;
        }
        this.wrapper = PreparedAdvancementWrapper.craft(this.key.getNMSWrapper(), this.maxProgression);
        return this.wrapper;
    }

    @Override
    @Contract(value="_ -> true")
    public final boolean isVisible(@NotNull Player player) {
        return true;
    }

    @Override
    @Contract(value="_ -> true")
    public final boolean isVisible(@NotNull UUID uuid) {
        return true;
    }

    @Override
    @Contract(value="_ -> true")
    public final boolean isVisible(@NotNull TeamProgression progression) {
        return true;
    }
}

