/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement;

import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.BaseAdvancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractImmutableAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractPerPlayerAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractPerTeamAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementDisplayBuilder;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementFrameType;
import com.fren_gor.ultimateAdvancementAPI.database.ProgressionUpdateResult;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.LazyValue;
import com.fren_gor.ultimateAdvancementAPI.util.display.ImmutableAdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.display.PerPlayerAdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.display.PerTeamAdvancementDisplayWrapper;
import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class FakeAdvancement
extends BaseAdvancement {
    private static final AtomicInteger FAKE_NUMBER = new AtomicInteger(0);

    @NotNull
    private static String generateKey() {
        return "_-uaapi-internal-_fakeadvancement-" + FAKE_NUMBER.getAndIncrement();
    }

    public FakeAdvancement(@NotNull Advancement parent, float x, float y) {
        this(parent, FakeAdvancement.generateKey(), x, y);
    }

    public FakeAdvancement(@NotNull Advancement parent, @NotNull String key, float x, float y) {
        this(parent, key, new AdvancementDisplayBuilder(Material.GRASS_BLOCK, "FakeAdvancement").x(x).y(y).build());
    }

    public FakeAdvancement(@NotNull Advancement parent, @NotNull AbstractAdvancementDisplay display) {
        this(parent, FakeAdvancement.generateKey(), display);
    }

    public FakeAdvancement(@NotNull Advancement parent, @NotNull String key, @NotNull AbstractAdvancementDisplay display) {
        super(parent, key, FakeAdvancement.wrapDisplay(display));
    }

    @Override
    public int getProgression(@NotNull Player player) {
        return 0;
    }

    @Override
    public int getProgression(@NotNull UUID uuid) {
        return 0;
    }

    @Override
    public int getProgression(@NotNull TeamProgression progression) {
        return 0;
    }

    @Override
    @Contract(value="_ -> true")
    public boolean isVisible(@NotNull Player player) {
        return true;
    }

    @Override
    @Contract(value="_ -> true")
    public boolean isVisible(@NotNull UUID uuid) {
        return true;
    }

    @Override
    @Contract(value="_ -> true")
    public boolean isVisible(@NotNull TeamProgression progression) {
        return true;
    }

    @Override
    @Nullable
    @Contract(value="_ -> null")
    public @Nullable Function<@NotNull Player, @Nullable BaseComponent> getAnnouncementMessage(@NotNull Player advancementCompleter) {
        return null;
    }

    private static AbstractAdvancementDisplay wrapDisplay(@NotNull AbstractAdvancementDisplay display) {
        Preconditions.checkNotNull((Object)display, (Object)"AbstractAdvancementDisplay is null.");
        if (display instanceof AbstractImmutableAdvancementDisplay) {
            AbstractImmutableAdvancementDisplay immutable = (AbstractImmutableAdvancementDisplay)display;
            return new ImmutableAdvancementDisplayWrapper(immutable){
                @LazyValue
                private PreparedAdvancementDisplayWrapper wrapper;

                @Override
                @NotNull
                public PreparedAdvancementDisplayWrapper getNMSWrapper() throws ReflectiveOperationException {
                    if (this.wrapper != null) {
                        return this.wrapper;
                    }
                    this.wrapper = PreparedAdvancementDisplayWrapper.craft(new ItemStack(Material.GRASS_BLOCK), (BaseComponent)new TextComponent("FakeAdvancement"), (BaseComponent)new TextComponent(""), AdvancementFrameType.GOAL.getNMSWrapper(), this.wrapped.getX(), this.wrapped.getY(), false, false, true);
                    return this.wrapper;
                }
            };
        }
        if (display instanceof AbstractPerTeamAdvancementDisplay) {
            AbstractPerTeamAdvancementDisplay perTeam = (AbstractPerTeamAdvancementDisplay)display;
            return new PerTeamAdvancementDisplayWrapper(perTeam){

                @Override
                @NotNull
                public PreparedAdvancementDisplayWrapper getNMSWrapper(@NotNull TeamProgression progression) throws ReflectiveOperationException {
                    return PreparedAdvancementDisplayWrapper.craft(new ItemStack(Material.GRASS_BLOCK), (BaseComponent)new TextComponent("FakeAdvancement"), (BaseComponent)new TextComponent(""), AdvancementFrameType.GOAL.getNMSWrapper(), this.wrapped.getX(progression), this.wrapped.getY(progression), false, false, true);
                }
            };
        }
        if (display instanceof AbstractPerPlayerAdvancementDisplay) {
            AbstractPerPlayerAdvancementDisplay perPlayer = (AbstractPerPlayerAdvancementDisplay)display;
            return new PerPlayerAdvancementDisplayWrapper(perPlayer){

                @Override
                @NotNull
                public PreparedAdvancementDisplayWrapper getNMSWrapper(@NotNull Player player) throws ReflectiveOperationException {
                    return PreparedAdvancementDisplayWrapper.craft(new ItemStack(Material.GRASS_BLOCK), (BaseComponent)new TextComponent("FakeAdvancement"), (BaseComponent)new TextComponent(""), AdvancementFrameType.GOAL.getNMSWrapper(), this.wrapped.getX(player), this.wrapped.getY(player), false, false, true);
                }
            };
        }
        throw new ClassCastException(display.getClass().getName() + " is not an immutable, per-team or per-player display.");
    }

    @Override
    public boolean isGranted(@NotNull Player player) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isGranted(@NotNull UUID uuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isGranted(@NotNull TeamProgression progression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid, boolean giveReward) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid, @Range(from=0L, to=0x7FFFFFFFL) int increment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid, @Range(from=0L, to=0x7FFFFFFFL) int increment, boolean giveReward) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player, boolean giveReward) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player, int increment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player, int increment, boolean giveReward) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull TeamProgression pro, @Nullable Player player, int increment, boolean giveRewards) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull UUID uuid, @Range(from=0L, to=0x7FFFFFFFL) int progression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull UUID uuid, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean giveReward) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull Player player, @Range(from=0L, to=0x7FFFFFFFL) int progression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull Player player, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean giveReward) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull TeamProgression pro, @Nullable Player player, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean giveRewards) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleAdvancementGranting(@NotNull TeamProgression pro, @Nullable Player player, int newProgression, int oldProgression, boolean giveRewards) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleAdvancementUpdatingToTeam(@NotNull TeamProgression pro, int newProgression, int oldProgression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayToastToPlayer(@NotNull Player player) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onGrant(@NotNull Player advancementCompleter, boolean giveRewards) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void sendAnnouncementMessageOnGrant(@NotNull Player advancementCompleter, @NotNull TeamProgression progression) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void displayToastOnGrant(@NotNull Player advancementCompleter, @NotNull TeamProgression progression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void giveReward(@NotNull Player player) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void grant(@NotNull Player player) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void grant(@NotNull Player player, boolean giveRewards) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void revoke(@NotNull Player player) {
        throw new UnsupportedOperationException();
    }
}

