/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement;

import com.fren_gor.ultimateAdvancementAPI.AdvancementUpdater;
import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.exceptions.InvalidAdvancementException;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.LazyValue;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class BaseAdvancement
extends Advancement {
    @NotNull
    protected final Advancement parent;
    @LazyValue
    private PreparedAdvancementWrapper wrapper;

    public BaseAdvancement(@NotNull Advancement parent, @NotNull String key, @NotNull AbstractAdvancementDisplay display) {
        this(parent, key, 1, display);
    }

    public BaseAdvancement(@NotNull Advancement parent, @NotNull String key, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression, @NotNull AbstractAdvancementDisplay display) {
        super(Objects.requireNonNull(parent, (String)"Parent advancement is null.").advancementTab, key, maxProgression, display);
        this.parent = parent;
    }

    @Override
    public void validateRegister() throws InvalidAdvancementException {
        if (!this.parent.isValid()) {
            throw new InvalidAdvancementException("Parent advancement is not valid (" + String.valueOf(this.parent.getKey()) + ").");
        }
    }

    @Override
    public void onUpdate(@NotNull TeamProgression teamProgression, @NotNull AdvancementUpdater advancementUpdater) throws ReflectiveOperationException {
        if (this.isVisible(teamProgression)) {
            advancementUpdater.addBaseAdvancement(this.getNMSWrapper(), this.display, this.getProgression(teamProgression));
        }
    }

    @Override
    @NotNull
    public PreparedAdvancementWrapper getNMSWrapper() throws ReflectiveOperationException {
        if (this.wrapper != null) {
            return this.wrapper;
        }
        this.wrapper = PreparedAdvancementWrapper.craft(this.key.getNMSWrapper(), this.parent.getNMSWrapper(), this.maxProgression);
        return this.wrapper;
    }

    @NotNull
    public Advancement getParent() {
        return this.parent;
    }
}

