/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.advancement;

import com.fren_gor.ultimateAdvancementAPI.AdvancementTab;
import com.fren_gor.ultimateAdvancementAPI.AdvancementUpdater;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.announcementMessage.IAnnouncementMessage;
import com.fren_gor.ultimateAdvancementAPI.database.DatabaseManager;
import com.fren_gor.ultimateAdvancementAPI.database.ProgressionUpdateResult;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.AdvancementGrantEvent;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.AdvancementProgressionUpdateEvent;
import com.fren_gor.ultimateAdvancementAPI.exceptions.DisposedException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.IllegalOperationException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.InvalidAdvancementException;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.fren_gor.ultimateAdvancementAPI.visibilities.IVisibility;
import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Advancement {
    @NotNull
    protected final AdvancementKey key;
    @NotNull
    protected final AdvancementTab advancementTab;
    @NotNull
    protected final AbstractAdvancementDisplay display;
    protected final @Range(from=1L, to=0x7FFFFFFFL) int maxProgression;
    @Nullable
    private final MethodHandle iVisibilityMethod;
    @Nullable
    private final MethodHandle iAnnouncementMessageMethod;

    Advancement(@NotNull AdvancementTab advancementTab, @NotNull String key, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression, @NotNull AbstractAdvancementDisplay display) {
        Preconditions.checkArgument((maxProgression > 0 ? 1 : 0) != 0, (Object)"Maximum progression cannot be <= 0");
        this.advancementTab = Objects.requireNonNull(advancementTab, "AdvancementTab is null.");
        Preconditions.checkArgument((!advancementTab.isInitialised() ? 1 : 0) != 0, (Object)"AdvancementTab is already initialised.");
        Preconditions.checkArgument((!advancementTab.isDisposed() ? 1 : 0) != 0, (Object)"AdvancementTab is disposed.");
        this.key = new AdvancementKey(advancementTab.getNamespace(), key);
        this.display = Objects.requireNonNull(display, "Display is null.");
        this.maxProgression = maxProgression;
        this.iVisibilityMethod = this instanceof IVisibility ? this.getIVisibilityMethod() : null;
        this.iAnnouncementMessageMethod = this instanceof IAnnouncementMessage ? this.getIAnnouncementMessageMethod() : null;
    }

    @NotNull
    public final AdvancementKey getKey() {
        return this.key;
    }

    @NotNull
    public final AdvancementTab getAdvancementTab() {
        return this.advancementTab;
    }

    public final @Range(from=1L, to=0x7FFFFFFFL) int getMaxProgression() {
        return this.maxProgression;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getProgression(@NotNull Player player) {
        return this.getProgression(AdvancementUtils.uuidFromPlayer(player));
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getProgression(@NotNull UUID uuid) {
        return this.getProgression(AdvancementUtils.progressionFromUUID(uuid, this));
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getProgression(@NotNull TeamProgression progression) {
        AdvancementUtils.validateTeamProgression(progression);
        return progression.getProgression(this);
    }

    public boolean isGranted(@NotNull Player player) {
        return this.isGranted(AdvancementUtils.uuidFromPlayer(player));
    }

    public boolean isGranted(@NotNull UUID uuid) {
        return this.isGranted(AdvancementUtils.progressionFromUUID(uuid, this));
    }

    public boolean isGranted(@NotNull TeamProgression progression) {
        AdvancementUtils.validateTeamProgression(progression);
        return this.getProgression(progression) >= this.maxProgression;
    }

    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player) {
        return this.incrementProgression(player, true);
    }

    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player, boolean giveReward) {
        return this.incrementProgression(player, 1, giveReward);
    }

    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player, int increment) {
        return this.incrementProgression(player, increment, true);
    }

    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull Player player, int increment, boolean giveReward) {
        return this.incrementProgression(AdvancementUtils.progressionFromPlayer(player, this), player, increment, giveReward);
    }

    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid) {
        return this.incrementProgression(uuid, true);
    }

    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid, boolean giveReward) {
        return this.incrementProgression(uuid, 1, giveReward);
    }

    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid, int increment) {
        return this.incrementProgression(uuid, increment, true);
    }

    public CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull UUID uuid, int increment, boolean giveReward) {
        return this.incrementProgression(AdvancementUtils.progressionFromUUID(uuid, this), Bukkit.getPlayer((UUID)uuid), increment, giveReward);
    }

    protected CompletableFuture<ProgressionUpdateResult> incrementProgression(@NotNull TeamProgression pro, @Nullable Player player, int increment, boolean giveRewards) {
        AdvancementUtils.validateTeamProgression(pro);
        DatabaseManager ds = this.advancementTab.getDatabaseManager();
        CompletableFuture<ProgressionUpdateResult> completableFuture = ds.incrementProgression(this.key, pro, increment, this.maxProgression);
        AdvancementUtils.runSync(completableFuture, this.advancementTab.getOwningPlugin(), (result, err) -> {
            if (err != null) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while incrementing the progression of " + String.valueOf(this.key), (Throwable)err);
                return;
            }
            try {
                Bukkit.getPluginManager().callEvent((Event)new AdvancementProgressionUpdateEvent(this, pro, result.oldProgression(), result.newProgression()));
            }
            catch (Exception e) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while calling AdvancementProgressionUpdateEvent for " + String.valueOf(this.key), e);
            }
            this.handleAdvancementGranting(pro, player, result.newProgression(), result.oldProgression(), giveRewards);
            this.handleAdvancementUpdatingToTeam(pro, result.newProgression(), result.oldProgression());
        });
        return completableFuture;
    }

    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull Player player, @Range(from=0L, to=0x7FFFFFFFL) int progression) {
        return this.setProgression(player, progression, true);
    }

    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull Player player, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean giveReward) {
        return this.setProgression(AdvancementUtils.progressionFromPlayer(player, this), player, progression, giveReward);
    }

    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull UUID uuid, @Range(from=0L, to=0x7FFFFFFFL) int progression) {
        return this.setProgression(uuid, progression, true);
    }

    public CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull UUID uuid, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean giveReward) {
        return this.setProgression(AdvancementUtils.progressionFromUUID(uuid, this), Bukkit.getPlayer((UUID)uuid), progression, giveReward);
    }

    protected CompletableFuture<ProgressionUpdateResult> setProgression(@NotNull TeamProgression pro, @Nullable Player player, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean giveRewards) {
        AdvancementUtils.validateTeamProgression(pro);
        AdvancementUtils.validateProgressionValueStrict(progression, this.maxProgression);
        DatabaseManager ds = this.advancementTab.getDatabaseManager();
        CompletableFuture<ProgressionUpdateResult> completableFuture = ds.setProgression(this.key, pro, progression);
        AdvancementUtils.runSync(completableFuture, this.advancementTab.getOwningPlugin(), (result, err) -> {
            if (err != null) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while setting the progression of " + String.valueOf(this.key), (Throwable)err);
                return;
            }
            try {
                Bukkit.getPluginManager().callEvent((Event)new AdvancementProgressionUpdateEvent(this, pro, result.oldProgression(), result.newProgression()));
            }
            catch (Exception e) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while calling AdvancementProgressionUpdateEvent for " + String.valueOf(this.key), e);
            }
            this.handleAdvancementGranting(pro, player, result.newProgression(), result.oldProgression(), giveRewards);
            this.handleAdvancementUpdatingToTeam(pro, result.newProgression(), result.oldProgression());
        });
        return completableFuture;
    }

    protected void handleAdvancementGranting(@NotNull TeamProgression pro, @Nullable Player player, @Range(from=0L, to=0x7FFFFFFFL) int newProgression, @Range(from=0L, to=0x7FFFFFFFL) int oldProgression, boolean giveRewards) {
        AdvancementUtils.checkSync();
        AdvancementUtils.validateTeamProgression(pro);
        if (newProgression >= this.maxProgression && oldProgression < this.maxProgression) {
            if (player != null) {
                this.onGrant(player, giveRewards);
            } else {
                DatabaseManager ds = this.advancementTab.getDatabaseManager();
                player = pro.getAnOnlineMember(ds);
                if (player != null) {
                    this.onGrant(player, giveRewards);
                } else {
                    ds.setUnredeemed(this.key, pro, giveRewards);
                }
            }
        }
    }

    protected void handleAdvancementUpdatingToTeam(@NotNull TeamProgression pro, @Range(from=0L, to=0x7FFFFFFFL) int newProgression, @Range(from=0L, to=0x7FFFFFFFL) int oldProgression) {
        AdvancementUtils.checkSync();
        AdvancementUtils.validateTeamProgression(pro);
        if (newProgression != oldProgression) {
            this.advancementTab.updateAdvancementsToTeam(pro);
        }
    }

    public void displayToastToPlayer(@NotNull Player player) {
        TeamProgression team = this.advancementTab.getDatabaseManager().getTeamProgression(player);
        AdvancementUtils.displayToast(player, this.display.dispatchGetIcon(player, team), this.display.dispatchGetTitle(player, team), this.display.dispatchGetFrame(player, team));
    }

    public boolean isVisible(@NotNull Player player) {
        return this.isVisible(AdvancementUtils.uuidFromPlayer(player));
    }

    public boolean isVisible(@NotNull UUID uuid) {
        return this.isVisible(AdvancementUtils.progressionFromUUID(uuid, this));
    }

    public boolean isVisible(@NotNull TeamProgression progression) {
        AdvancementUtils.validateTeamProgression(progression);
        if (this.iVisibilityMethod != null) {
            try {
                return (Boolean)this.iVisibilityMethod.invokeWithArguments(this, progression);
            }
            catch (Throwable e) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred evaluating the visibility of " + String.valueOf(this.key), e);
            }
        }
        return true;
    }

    @Nullable
    public @Nullable Function<@NotNull Player, @Nullable BaseComponent> getAnnouncementMessage(@NotNull Player advancementCompleter) {
        Preconditions.checkNotNull((Object)advancementCompleter, (Object)"Player is null.");
        if (this.iAnnouncementMessageMethod != null) {
            try {
                return (Function)this.iAnnouncementMessageMethod.invokeWithArguments(this, advancementCompleter);
            }
            catch (Throwable e) {
                this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred evaluating the announcement message of " + String.valueOf(this.key), e);
            }
        }
        BaseComponent announcementMsg = AdvancementUtils.getAnnouncementMessage(this, advancementCompleter);
        return player -> announcementMsg;
    }

    public void onGrant(@NotNull Player advancementCompleter, boolean giveRewards) {
        Preconditions.checkNotNull((Object)advancementCompleter, (Object)"Player is null.");
        TeamProgression progression = this.advancementTab.getDatabaseManager().getTeamProgression(advancementCompleter);
        try {
            Bukkit.getPluginManager().callEvent((Event)new AdvancementGrantEvent(this, progression, advancementCompleter, giveRewards));
        }
        catch (Exception e) {
            this.advancementTab.getOwningPlugin().getLogger().log(Level.SEVERE, "An exception occurred while calling AdvancementGrantEvent for " + String.valueOf(this.key), e);
        }
        this.sendAnnouncementMessageOnGrant(advancementCompleter, progression);
        this.displayToastOnGrant(advancementCompleter, progression);
        if (giveRewards) {
            this.giveReward(advancementCompleter);
        }
    }

    protected void sendAnnouncementMessageOnGrant(@NotNull Player advancementCompleter, @NotNull TeamProgression progression) {
        Function<Player, BaseComponent> perPlayerMsgGetter;
        Preconditions.checkNotNull((Object)advancementCompleter, (Object)"Player is null.");
        AdvancementUtils.validateTeamProgression(progression);
        Boolean gameRule = (Boolean)advancementCompleter.getWorld().getGameRuleValue(AdvancementUtils.SHOW_ADVANCEMENT_MESSAGES_GAMERULE);
        if ((gameRule == null || gameRule.booleanValue()) && this.display.dispatchDoesAnnounceToChat(advancementCompleter, progression) && (perPlayerMsgGetter = this.getAnnouncementMessage(advancementCompleter)) != null) {
            Stream<Object> players = this.advancementTab.doesSendAnnouncementMessageOnlyToTeam() ? progression.getMembers().stream().map(Bukkit::getPlayer).filter(Objects::nonNull) : Bukkit.getOnlinePlayers().stream();
            players.forEach(p -> {
                @Nullable BaseComponent msg = (BaseComponent)perPlayerMsgGetter.apply((Player)p);
                if (msg != null) {
                    p.spigot().sendMessage(msg);
                }
            });
        }
    }

    protected void displayToastOnGrant(@NotNull Player advancementCompleter, @NotNull TeamProgression progression) {
        Preconditions.checkNotNull((Object)advancementCompleter, (Object)"Player is null.");
        AdvancementUtils.validateTeamProgression(progression);
        if (this.display.dispatchDoesShowToast(advancementCompleter, progression)) {
            Stream<Player> players = this.advancementTab.doesShowToastToTeam() ? progression.getMembers().stream().map(Bukkit::getPlayer).filter(Objects::nonNull) : Stream.of(advancementCompleter);
            players.forEach(p -> AdvancementUtils.runSync(this.advancementTab.getOwningPlugin(), 2L, () -> AdvancementUtils.displayToastDuringUpdate(p, this)));
        }
    }

    public void grant(@NotNull Player player) {
        this.grant(player, true);
    }

    public void grant(@NotNull Player player, boolean giveRewards) {
        Preconditions.checkNotNull((Object)player, (Object)"Player is null.");
        this.setProgression(player, this.maxProgression, giveRewards);
    }

    public void revoke(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player is null.");
        this.setProgression(player, 0, false);
    }

    public void giveReward(@NotNull Player player) {
    }

    public void onRegister() {
    }

    public void validateRegister() throws InvalidAdvancementException {
    }

    public void onDispose() {
    }

    public boolean isValid() {
        return this.advancementTab.isActive() && this.advancementTab.hasAdvancement(this);
    }

    public abstract void onUpdate(@NotNull TeamProgression var1, @NotNull AdvancementUpdater var2) throws ReflectiveOperationException;

    @NotNull
    public abstract PreparedAdvancementWrapper getNMSWrapper() throws ReflectiveOperationException;

    protected final <E extends Event> void registerEvent(@NotNull Class<E> eventClass, @NotNull Consumer<E> consumer) {
        try {
            this.advancementTab.getEventManager().register(this, eventClass, consumer);
        }
        catch (IllegalStateException e) {
            throw new DisposedException(e);
        }
    }

    protected final <E extends Event> void registerEvent(@NotNull Class<E> eventClass, @NotNull EventPriority priority, @NotNull Consumer<E> consumer) {
        try {
            this.advancementTab.getEventManager().register(this, eventClass, priority, consumer);
        }
        catch (IllegalStateException e) {
            throw new DisposedException(e);
        }
    }

    public String toString() {
        return this.key.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Advancement that = (Advancement)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Nullable
    private MethodHandle getIVisibilityMethod() {
        return this.getMethod(this.getClass(), IVisibility.class, "isVisible", Advancement.class, TeamProgression.class);
    }

    @Nullable
    private MethodHandle getIAnnouncementMessageMethod() {
        return this.getMethod(this.getClass(), IAnnouncementMessage.class, "getAnnouncementMessage", Advancement.class, Player.class);
    }

    @Nullable
    private MethodHandle getMethod(Class<? extends Advancement> clazz, Class<?> interfaceClass, String methodName, Class<?> ... methodParameters) {
        for (Class<?> i : clazz.getInterfaces()) {
            if (i == interfaceClass || !interfaceClass.isAssignableFrom(i)) continue;
            try {
                Method m = i.getDeclaredMethod(methodName, methodParameters);
                if (!m.isDefault()) continue;
                return MethodHandles.lookup().unreflectSpecial(m, i).bindTo(this);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        Class<? extends Advancement> sClazz = clazz.getSuperclass();
        if (Advancement.class.isAssignableFrom(sClazz) && sClazz != Advancement.class) {
            return this.getMethod(sClazz.asSubclass(Advancement.class), interfaceClass, methodName, methodParameters);
        }
        return null;
    }

    @NotNull
    public final AbstractAdvancementDisplay getDisplay() {
        return this.display;
    }

    @Deprecated
    @ApiStatus.Internal
    @Contract(value="_, _ -> fail")
    public final boolean isVisible(Advancement advancement, TeamProgression progression) {
        throw new IllegalOperationException("This method cannot be called. Use Advancement#isVisible(TeamProgression).");
    }

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    @Contract(value="_, _ -> fail")
    public final @Nullable Function<@NotNull Player, @Nullable BaseComponent> getAnnouncementMessage(@NotNull Advancement advancement, @NotNull Player advancementCompleter) {
        throw new IllegalOperationException("This method cannot be called. Use Advancement#getAnnouncementMessage(Player).");
    }
}

