/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.AdvancementTab;
import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementFrameType;
import com.fren_gor.ultimateAdvancementAPI.database.DatabaseManager;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.exceptions.APINotInstantiatedException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.DuplicatedException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.NotGrantedException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.UserNotLoadedException;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class UltimateAdvancementAPI {
    static AdvancementMain main;
    private final Plugin plugin;

    private static AdvancementMain getMain() throws IllegalStateException {
        if (main == null) {
            throw new IllegalStateException("UltimateAdvancementAPI is not enabled.");
        }
        return main;
    }

    @NotNull
    public static UltimateAdvancementAPI getInstance(@NotNull Plugin plugin) throws APINotInstantiatedException {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin is null.");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (Object)"Plugin is not enabled.");
        if (main == null) {
            throw new APINotInstantiatedException();
        }
        return new UltimateAdvancementAPI(plugin);
    }

    private UltimateAdvancementAPI(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public AdvancementTab createAdvancementTab(@NotNull String namespace, @NotNull String backgroundTexture) throws DuplicatedException {
        return UltimateAdvancementAPI.getMain().createAdvancementTab(this.plugin, namespace, backgroundTexture);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public AdvancementTab createAdvancementTab(@NotNull String namespace, @NotNull AdvancementTab.ImmutableTabDisplay tabDisplay) throws DuplicatedException {
        return UltimateAdvancementAPI.getMain().createAdvancementTab(this.plugin, namespace, tabDisplay);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public AdvancementTab createAdvancementTab(@NotNull String namespace, @NotNull AdvancementTab.PerTeamTabDisplay tabDisplay) throws DuplicatedException {
        return UltimateAdvancementAPI.getMain().createAdvancementTab(this.plugin, namespace, tabDisplay);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public AdvancementTab createAdvancementTab(@NotNull String namespace, @NotNull AdvancementTab.PerPlayerTabDisplay tabDisplay) throws DuplicatedException {
        return UltimateAdvancementAPI.getMain().createAdvancementTab(this.plugin, namespace, tabDisplay);
    }

    @Nullable
    public AdvancementTab getAdvancementTab(@NotNull String namespace) {
        return UltimateAdvancementAPI.getMain().getAdvancementTab(namespace);
    }

    public boolean isAdvancementTabRegistered(@NotNull String namespace) {
        return UltimateAdvancementAPI.getMain().isAdvancementTabRegistered(namespace);
    }

    @NotNull
    public @UnmodifiableView @NotNull Collection<@NotNull AdvancementTab> getPluginAdvancementTabs() {
        return UltimateAdvancementAPI.getMain().getPluginAdvancementTabs(this.plugin);
    }

    public void unregisterAdvancementTab(@NotNull String namespace) {
        UltimateAdvancementAPI.getMain().unregisterAdvancementTab(namespace);
    }

    public void unregisterPluginAdvancementTabs() {
        UltimateAdvancementAPI.getMain().unregisterAdvancementTabs(this.plugin);
    }

    @NotNull
    @Contract(pure=true)
    public @NotNull @UnmodifiableView Set<@NotNull String> getAdvancementTabNamespaces() {
        return UltimateAdvancementAPI.getMain().getAdvancementTabNamespaces();
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public @NotNull List<@NotNull String> filterNamespaces(@Nullable String input) {
        return UltimateAdvancementAPI.getMain().filterNamespaces(input);
    }

    @NotNull
    public @NotNull @UnmodifiableView Collection<@NotNull AdvancementTab> getTabs() {
        return UltimateAdvancementAPI.getMain().getTabs();
    }

    public void updateAdvancementsToTeam(@NotNull Player player) throws UserNotLoadedException {
        UltimateAdvancementAPI.getMain().updateAdvancementsToTeam(player);
    }

    public void updateAdvancementsToTeam(@NotNull UUID uuid) throws UserNotLoadedException {
        UltimateAdvancementAPI.getMain().updateAdvancementsToTeam(uuid);
    }

    public void updateAdvancementsToTeam(@NotNull TeamProgression teamProgression) {
        UltimateAdvancementAPI.getMain().updateAdvancementsToTeam(teamProgression);
    }

    @Nullable
    public Advancement getAdvancement(@NotNull String namespacedKey) {
        return UltimateAdvancementAPI.getMain().getAdvancement(namespacedKey);
    }

    @Nullable
    public Advancement getAdvancement(@NotNull String namespace, @NotNull String key) {
        return UltimateAdvancementAPI.getMain().getAdvancement(namespace, key);
    }

    @Nullable
    public Advancement getAdvancement(@NotNull AdvancementKey namespacedKey) {
        return UltimateAdvancementAPI.getMain().getAdvancement(namespacedKey);
    }

    public void displayCustomToast(@NotNull Player player, @NotNull AbstractAdvancementDisplay display) {
        TeamProgression pro = main.getDatabaseManager().getTeamProgression(player);
        this.displayCustomToast(player, display.dispatchGetIcon(player, pro), display.dispatchGetLegacyTitle(player, pro), display.dispatchGetFrame(player, pro));
    }

    public void displayCustomToast(@NotNull Player player, @NotNull ItemStack icon, @NotNull String title, @NotNull AdvancementFrameType frame) {
        AdvancementUtils.displayToast(player, icon, title, frame);
    }

    public void disableVanillaAdvancements() throws RuntimeException {
        try {
            AdvancementUtils.disableVanillaAdvancements();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't disable minecraft advancements.", e);
        }
    }

    public void disableVanillaRecipeAdvancements() throws RuntimeException {
        try {
            AdvancementUtils.disableVanillaRecipeAdvancements();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't disable minecraft recipe advancements.", e);
        }
    }

    @NotNull
    public TeamProgression getTeamProgression(@NotNull Player player) throws UserNotLoadedException {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().getTeamProgression(player);
    }

    @NotNull
    public TeamProgression getTeamProgression(@NotNull OfflinePlayer player) throws UserNotLoadedException {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().getTeamProgression(player);
    }

    @NotNull
    public TeamProgression getTeamProgression(@NotNull UUID uuid) throws UserNotLoadedException {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().getTeamProgression(uuid);
    }

    public CompletableFuture<Void> updatePlayerTeam(@NotNull Player playerToMove, @NotNull Player aDestTeamPlayer) {
        Preconditions.checkNotNull((Object)playerToMove, (Object)"Player to move is null.");
        Preconditions.checkNotNull((Object)aDestTeamPlayer, (Object)"Destination player (representing destination team) is null.");
        return this.callAfterLoad(playerToMove, aDestTeamPlayer, (DatabaseManager ds) -> ds.updatePlayerTeam(playerToMove, aDestTeamPlayer));
    }

    public CompletableFuture<Void> updatePlayerTeam(@NotNull UUID playerToMove, @NotNull UUID aDestTeamPlayer) {
        Preconditions.checkNotNull((Object)playerToMove, (Object)"Player to move is null.");
        Preconditions.checkNotNull((Object)aDestTeamPlayer, (Object)"Destination player (representing destination team) is null.");
        return this.callAfterLoad(playerToMove, aDestTeamPlayer, (DatabaseManager ds) -> ds.updatePlayerTeam(playerToMove, aDestTeamPlayer));
    }

    public CompletableFuture<Void> updatePlayerTeam(@NotNull Player playerToMove, @NotNull TeamProgression destinationTeam) {
        Preconditions.checkNotNull((Object)playerToMove, (Object)"Player to move is null.");
        Preconditions.checkNotNull((Object)destinationTeam, (Object)"Destination team is null.");
        return this.callAfterLoad(playerToMove, destinationTeam, (DatabaseManager ds) -> ds.updatePlayerTeam(playerToMove, destinationTeam));
    }

    public CompletableFuture<Void> updatePlayerTeam(@NotNull UUID playerToMove, @NotNull TeamProgression destinationTeam) {
        Preconditions.checkNotNull((Object)playerToMove, (Object)"Player to move is null.");
        Preconditions.checkNotNull((Object)destinationTeam, (Object)"Destination team is null.");
        return this.callAfterLoad(playerToMove, destinationTeam, (DatabaseManager ds) -> ds.updatePlayerTeam(playerToMove, destinationTeam));
    }

    public CompletableFuture<TeamProgression> movePlayerInNewTeam(@NotNull Player playerToMove) {
        return this.callAfterLoad(playerToMove, (DatabaseManager ds) -> ds.movePlayerInNewTeam(playerToMove));
    }

    public CompletableFuture<TeamProgression> movePlayerInNewTeam(@NotNull UUID playerToMove) {
        return this.callAfterLoad(playerToMove, (DatabaseManager ds) -> ds.movePlayerInNewTeam(playerToMove));
    }

    public CompletableFuture<Void> unregisterOfflinePlayer(@NotNull OfflinePlayer player) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().unregisterOfflinePlayer(player);
    }

    public CompletableFuture<Void> unregisterOfflinePlayer(@NotNull UUID uuid) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().unregisterOfflinePlayer(uuid);
    }

    public CompletableFuture<Void> updatePlayerName(@NotNull Player player) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().updatePlayerName(player);
    }

    public CompletableFuture<Boolean> isUnredeemed(@NotNull Advancement advancement, @NotNull Player player) {
        return this.isUnredeemed(advancement, AdvancementUtils.uuidFromPlayer(player));
    }

    public CompletableFuture<Boolean> isUnredeemed(@NotNull Advancement advancement, @NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        return this.callAfterLoad(uuid, (DatabaseManager ds) -> ds.isUnredeemed(advancement.getKey(), uuid));
    }

    public CompletableFuture<Boolean> isUnredeemed(@NotNull Advancement advancement, @NotNull TeamProgression teamProgression) {
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        Preconditions.checkNotNull((Object)teamProgression, (Object)"TeamProgression is null.");
        return this.callAfterLoad(teamProgression, (DatabaseManager ds) -> ds.isUnredeemed(advancement.getKey(), teamProgression));
    }

    public CompletableFuture<Void> setUnredeemed(@NotNull Advancement advancement, @NotNull Player player) {
        return this.setUnredeemed(advancement, player, true);
    }

    public CompletableFuture<Void> setUnredeemed(@NotNull Advancement advancement, @NotNull Player player, boolean giveRewards) {
        return this.setUnredeemed(advancement, AdvancementUtils.uuidFromPlayer(player), giveRewards);
    }

    public CompletableFuture<Void> setUnredeemed(@NotNull Advancement advancement, @NotNull UUID uuid) {
        return this.setUnredeemed(advancement, uuid, true);
    }

    public CompletableFuture<Void> setUnredeemed(@NotNull Advancement advancement, @NotNull UUID uuid, boolean giveRewards) {
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        int maxProgression = advancement.getMaxProgression();
        AdvancementKey key = advancement.getKey();
        return this.callAfterLoad(uuid, (DatabaseManager ds) -> {
            TeamProgression pro = ds.getTeamProgression(uuid);
            if (pro.getRawProgression(key) != maxProgression) {
                throw new NotGrantedException(key, pro.getTeamId());
            }
            return ds.setUnredeemed(advancement.getKey(), uuid, giveRewards);
        });
    }

    public CompletableFuture<Void> setUnredeemed(@NotNull Advancement advancement, @NotNull TeamProgression teamProgression) {
        return this.setUnredeemed(advancement, teamProgression, true);
    }

    public CompletableFuture<Void> setUnredeemed(@NotNull Advancement advancement, @NotNull TeamProgression teamProgression, boolean giveRewards) {
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        Preconditions.checkNotNull((Object)teamProgression, (Object)"TeamProgression is null.");
        int maxProgression = advancement.getMaxProgression();
        AdvancementKey key = advancement.getKey();
        return this.callAfterLoad(teamProgression, (DatabaseManager ds) -> {
            if (teamProgression.getRawProgression(key) != maxProgression) {
                throw new NotGrantedException(key, teamProgression.getTeamId());
            }
            return ds.setUnredeemed(advancement.getKey(), teamProgression, giveRewards);
        });
    }

    public CompletableFuture<Void> unsetUnredeemed(@NotNull Advancement advancement, @NotNull Player player) {
        return this.unsetUnredeemed(advancement, AdvancementUtils.uuidFromPlayer(player));
    }

    public CompletableFuture<Void> unsetUnredeemed(@NotNull Advancement advancement, @NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        return this.callAfterLoad(uuid, (DatabaseManager ds) -> ds.unsetUnredeemed(advancement.getKey(), uuid));
    }

    public CompletableFuture<Void> unsetUnredeemed(@NotNull Advancement advancement, @NotNull TeamProgression teamProgression) {
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        Preconditions.checkNotNull((Object)teamProgression, (Object)"TeamProgression is null.");
        return this.callAfterLoad(teamProgression, (DatabaseManager ds) -> ds.unsetUnredeemed(advancement.getKey(), teamProgression));
    }

    public boolean isLoaded(@NotNull Player player) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().isLoaded(player);
    }

    public boolean isLoaded(@NotNull OfflinePlayer player) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().isLoaded(player);
    }

    public boolean isLoaded(@NotNull UUID uuid) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().isLoaded(uuid);
    }

    public boolean isLoaded(int teamId) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().isLoaded(teamId);
    }

    public CompletableFuture<TeamProgression> loadAndAddLoadingRequest(@NotNull Player player) {
        return this.loadAndAddLoadingRequest(AdvancementUtils.uuidFromPlayer(player));
    }

    public CompletableFuture<TeamProgression> loadAndAddLoadingRequest(@NotNull OfflinePlayer player) {
        return this.loadAndAddLoadingRequest(AdvancementUtils.uuidFromPlayer(player));
    }

    public CompletableFuture<TeamProgression> loadAndAddLoadingRequest(@NotNull UUID uuid) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().loadAndAddLoadingRequest(uuid, this.plugin);
    }

    public CompletableFuture<TeamProgression> createNewTeamWithOneLoadingRequest() {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().createNewTeamWithOneLoadingRequest(this.plugin);
    }

    public CompletableFuture<TeamProgression> loadAndAddLoadingRequest(int teamId) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().loadAndAddLoadingRequest(teamId, this.plugin);
    }

    public void addLoadingRequest(@NotNull TeamProgression teamProgression) {
        UltimateAdvancementAPI.getMain().getDatabaseManager().addLoadingRequest(teamProgression, this.plugin);
    }

    public void removeLoadingRequest(@NotNull Player player) {
        this.removeLoadingRequest(AdvancementUtils.uuidFromPlayer(player));
    }

    public void removeLoadingRequest(@NotNull OfflinePlayer player) {
        this.removeLoadingRequest(AdvancementUtils.uuidFromPlayer(player));
    }

    public void removeLoadingRequest(@NotNull UUID uuid) {
        UltimateAdvancementAPI.getMain().getDatabaseManager().removeLoadingRequest(uuid, this.plugin);
    }

    public void removeLoadingRequest(@NotNull TeamProgression teamProgression) {
        UltimateAdvancementAPI.getMain().getDatabaseManager().removeLoadingRequest(teamProgression, this.plugin);
    }

    public int getLoadingRequestsAmount(@NotNull Player player) {
        return this.getLoadingRequestsAmount(AdvancementUtils.uuidFromPlayer(player));
    }

    public int getLoadingRequestsAmount(@NotNull OfflinePlayer offlinePlayer) {
        return this.getLoadingRequestsAmount(AdvancementUtils.uuidFromPlayer(offlinePlayer));
    }

    public int getLoadingRequestsAmount(@NotNull UUID uuid) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().getLoadingRequestsAmount(uuid, this.plugin);
    }

    public int getLoadingRequestsAmount(@NotNull TeamProgression teamProgression) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().getLoadingRequestsAmount(teamProgression, this.plugin);
    }

    @NotNull
    public CompletableFuture<Void> setTeamPermanent(@NotNull TeamProgression progression, boolean permanent) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().setTeamPermanent(progression, permanent);
    }

    @NotNull
    public CompletableFuture<Void> setTeamPermanent(int teamId, boolean permanent) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().setTeamPermanent(teamId, permanent);
    }

    @NotNull
    public CompletableFuture<Boolean> isTeamPermanent(@NotNull TeamProgression progression) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().isTeamPermanent(progression);
    }

    @NotNull
    public CompletableFuture<Boolean> isTeamPermanent(int teamId) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().isTeamPermanent(teamId);
    }

    @NotNull
    public CompletableFuture<List<Integer>> getPermanentTeams() {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().getPermanentTeams();
    }

    public CompletableFuture<String> getStoredPlayerName(@NotNull OfflinePlayer player) {
        return this.getStoredPlayerName(AdvancementUtils.uuidFromPlayer(player));
    }

    public CompletableFuture<String> getStoredPlayerName(@NotNull UUID uuid) {
        return UltimateAdvancementAPI.getMain().getDatabaseManager().getStoredPlayerName(uuid);
    }

    private <T> CompletableFuture<T> callAfterLoad(@NotNull TeamProgression progression, @NotNull Function<DatabaseManager, CompletableFuture<T>> internalAction) {
        Preconditions.checkNotNull(internalAction, (Object)"internalAction is null.");
        AdvancementMain main = UltimateAdvancementAPI.getMain();
        DatabaseManager ds = main.getDatabaseManager();
        CompletableFuture completableFuture = new CompletableFuture();
        ds.addLoadingRequest(progression, this.plugin);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> (CompletableFuture)internalAction.apply(ds)).thenCompose(c -> c)).thenAcceptAsync(completableFuture::complete)).exceptionallyAsync(err -> {
            this.handleException((Throwable)err, completableFuture, main, "An exception occurred while calling an API method");
            return null;
        })).whenComplete((r, e) -> ds.removeLoadingRequest(progression, this.plugin));
        return completableFuture;
    }

    private <T> CompletableFuture<T> callAfterLoad(@NotNull Player player, @NotNull Function<DatabaseManager, CompletableFuture<T>> internalAction) {
        return this.callAfterLoad(AdvancementUtils.uuidFromPlayer(player), internalAction);
    }

    private <T> CompletableFuture<T> callAfterLoad(@NotNull UUID uuid, @NotNull Function<DatabaseManager, CompletableFuture<T>> internalAction) {
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        Preconditions.checkNotNull(internalAction, (Object)"internalAction is null.");
        AdvancementMain main = UltimateAdvancementAPI.getMain();
        DatabaseManager ds = main.getDatabaseManager();
        CompletableFuture completableFuture = new CompletableFuture();
        ((CompletableFuture)ds.loadAndAddLoadingRequest(uuid, this.plugin).thenRun(() -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> (CompletableFuture)internalAction.apply(ds)).thenCompose(c -> c)).thenAcceptAsync(completableFuture::complete)).exceptionallyAsync(err -> {
            this.handleException((Throwable)err, completableFuture, main, "An exception occurred while calling an API method");
            return null;
        })).whenComplete((r, e) -> ds.removeLoadingRequest(uuid, this.plugin)))).exceptionallyAsync(err -> {
            this.handleException((Throwable)err, completableFuture, main, "An exception occurred while loading user " + String.valueOf(uuid));
            return null;
        });
        return completableFuture;
    }

    private <T> CompletableFuture<T> callAfterLoad(@NotNull Player player, @NotNull TeamProgression progression, @NotNull Function<DatabaseManager, CompletableFuture<T>> internalAction) {
        return this.callAfterLoad(AdvancementUtils.uuidFromPlayer(player), progression, internalAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CompletableFuture<T> callAfterLoad(@NotNull UUID uuid, @NotNull TeamProgression progression, @NotNull Function<DatabaseManager, CompletableFuture<T>> internalAction) {
        AdvancementMain main = UltimateAdvancementAPI.getMain();
        DatabaseManager ds = main.getDatabaseManager();
        ds.addLoadingRequest(progression, this.plugin);
        CompletableFuture<T> completableFuture = null;
        try {
            completableFuture = this.callAfterLoad(uuid, internalAction);
        }
        finally {
            if (completableFuture == null) {
                ds.removeLoadingRequest(progression, this.plugin);
            } else {
                completableFuture.whenComplete((r, e) -> ds.removeLoadingRequest(progression, this.plugin));
            }
        }
        return completableFuture;
    }

    private <T> CompletableFuture<T> callAfterLoad(@NotNull Player player1, @NotNull Player player2, @NotNull Function<DatabaseManager, CompletableFuture<T>> internalAction) {
        return this.callAfterLoad(Objects.requireNonNull(player1, "Player1 is null.").getUniqueId(), Objects.requireNonNull(player2, "Player2 is null.").getUniqueId(), internalAction);
    }

    private <T> CompletableFuture<T> callAfterLoad(@NotNull UUID uuid1, @NotNull UUID uuid2, @NotNull Function<DatabaseManager, CompletableFuture<T>> internalAction) {
        Preconditions.checkNotNull((Object)uuid1, (Object)"1st UUID is null.");
        Preconditions.checkNotNull((Object)uuid2, (Object)"2nd UUID is null.");
        Preconditions.checkNotNull(internalAction, (Object)"internalAction is null.");
        AdvancementMain main = UltimateAdvancementAPI.getMain();
        DatabaseManager ds = main.getDatabaseManager();
        CompletableFuture completableFuture = new CompletableFuture();
        ((CompletableFuture)ds.loadAndAddLoadingRequest(uuid1, this.plugin).thenRun(() -> ((CompletableFuture)ds.loadAndAddLoadingRequest(uuid2, this.plugin).thenRun(() -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> (CompletableFuture)internalAction.apply(ds)).thenCompose(c -> c)).thenAcceptAsync(completableFuture::complete)).exceptionallyAsync(err -> {
            this.handleException((Throwable)err, completableFuture, main, "An exception occurred while calling an API method");
            return null;
        })).whenComplete((r, e) -> {
            try {
                ds.removeLoadingRequest(uuid1, this.plugin);
            }
            finally {
                ds.removeLoadingRequest(uuid2, this.plugin);
            }
        }))).exceptionallyAsync(err -> {
            try {
                this.handleException((Throwable)err, completableFuture, main, "An exception occurred while loading user " + String.valueOf(uuid2));
            }
            finally {
                ds.removeLoadingRequest(uuid1, this.plugin);
            }
            return null;
        }))).exceptionallyAsync(err -> {
            this.handleException((Throwable)err, completableFuture, main, "An exception occurred while loading user " + String.valueOf(uuid1));
            return null;
        });
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void handleException(@NotNull Throwable err, @NotNull CompletableFuture<T> completableFuture, @NotNull AdvancementMain main, @NotNull String msg) {
        try {
            err = this.getCause(err);
            main.getLogger().log(Level.SEVERE, msg, err);
        }
        finally {
            completableFuture.completeExceptionally(err);
        }
    }

    private Throwable getCause(Throwable t) {
        return t instanceof CompletionException ? t.getCause() : t;
    }

    private UltimateAdvancementAPI() {
        throw new UnsupportedOperationException();
    }
}

