/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI;

import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractImmutableAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractPerPlayerAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractPerTeamAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.exceptions.DuplicatedException;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.MinecraftKeyWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.UnmodifiableView;

public final class AdvancementUpdater {
    private final MinecraftKeyWrapper tabRootKey;
    private PreparedAdvancementWrapper rootWrapper;
    private AbstractAdvancementDisplay rootDisplay;
    private int rootProgression;
    private final List<ImmutableUpdateEntry> immutableAdvancements;
    private final List<PerTeamUpdateEntry> perTeamAdvancements;
    private final List<PerPlayerUpdateEntry> perPlayerAdvancements;
    private final Set<MinecraftKeyWrapper> keys;

    AdvancementUpdater(@NotNull AdvancementKey tabRootKey, int sizeApprox) {
        this.tabRootKey = tabRootKey.getNMSWrapper();
        this.keys = Sets.newHashSetWithExpectedSize((int)sizeApprox);
        this.immutableAdvancements = new ArrayList<ImmutableUpdateEntry>(sizeApprox /= 2);
        this.perTeamAdvancements = new ArrayList<PerTeamUpdateEntry>(sizeApprox);
        this.perPlayerAdvancements = new ArrayList<PerPlayerUpdateEntry>(sizeApprox);
    }

    public void addBaseAdvancement(@NotNull PreparedAdvancementWrapper advancementWrapper, @NotNull AbstractAdvancementDisplay display, @Range(from=0L, to=0x7FFFFFFFL) int progression) throws DuplicatedException {
        this.validateParams(advancementWrapper, display, progression, false);
        if (display instanceof AbstractPerPlayerAdvancementDisplay) {
            AbstractPerPlayerAdvancementDisplay perPlayer = (AbstractPerPlayerAdvancementDisplay)display;
            this.perPlayerAdvancements.add(new PerPlayerUpdateEntry(advancementWrapper, perPlayer, progression));
        } else if (display instanceof AbstractPerTeamAdvancementDisplay) {
            AbstractPerTeamAdvancementDisplay perTeam = (AbstractPerTeamAdvancementDisplay)display;
            this.perTeamAdvancements.add(new PerTeamUpdateEntry(advancementWrapper, perTeam, progression));
        } else if (display instanceof AbstractImmutableAdvancementDisplay) {
            AbstractImmutableAdvancementDisplay immutable = (AbstractImmutableAdvancementDisplay)display;
            this.immutableAdvancements.add(new ImmutableUpdateEntry(advancementWrapper, immutable, progression));
        } else {
            throw new ClassCastException(display.getClass().getName() + " is not an immutable, per-team or per-player display.");
        }
    }

    public void addRootAdvancement(@NotNull PreparedAdvancementWrapper advancementWrapper, @NotNull AbstractAdvancementDisplay display, @Range(from=0L, to=0x7FFFFFFFL) int progression) throws DuplicatedException {
        this.validateParams(advancementWrapper, display, progression, true);
        this.rootWrapper = advancementWrapper;
        this.rootDisplay = display;
        this.rootProgression = progression;
    }

    private void validateParams(@NotNull PreparedAdvancementWrapper advancementWrapper, @NotNull AbstractAdvancementDisplay display, @Range(from=0L, to=0x7FFFFFFFL) int progression, boolean root) {
        Preconditions.checkNotNull((Object)advancementWrapper, (Object)"Advancement wrapper is null.");
        Preconditions.checkNotNull((Object)display, (Object)"Display is null.");
        AdvancementUtils.validateProgressionValue(progression);
        if (root) {
            if (advancementWrapper.getParent() != null) {
                throw new IllegalArgumentException("Wrapper of root advancement " + String.valueOf(advancementWrapper.getKey()) + " has advancement " + String.valueOf(advancementWrapper.getParent().getKey()) + " as parent.");
            }
            Preconditions.checkArgument((boolean)this.tabRootKey.equals(advancementWrapper.getKey()), (Object)("The key of the provided root wrapper (" + String.valueOf(advancementWrapper.getKey()) + ") is different from the one of the registered RootAdvancement (" + String.valueOf(this.tabRootKey) + ")."));
            if (this.rootWrapper != null) {
                throw new DuplicatedException("Another root advancement is already present, cannot add " + String.valueOf(advancementWrapper.getKey()));
            }
        } else {
            Preconditions.checkNotNull((Object)advancementWrapper.getParent(), (Object)("Wrapper of base advancement " + String.valueOf(advancementWrapper.getKey()) + " has no parent."));
        }
        if (!this.keys.add(advancementWrapper.getKey())) {
            throw new DuplicatedException("Advancement " + String.valueOf(advancementWrapper.getKey()) + " has already been added.");
        }
    }

    @NotNull
    PreparedAdvancementWrapper getRootWrapper() {
        return this.rootWrapper;
    }

    @NotNull
    AbstractAdvancementDisplay getRootDisplay() {
        return this.rootDisplay;
    }

    int getRootProgression() {
        return this.rootProgression;
    }

    List<ImmutableUpdateEntry> getImmutableAdvancements() {
        return this.immutableAdvancements;
    }

    List<PerTeamUpdateEntry> getPerTeamAdvancements() {
        return this.perTeamAdvancements;
    }

    List<PerPlayerUpdateEntry> getPerPlayerAdvancements() {
        return this.perPlayerAdvancements;
    }

    @NotNull
    @UnmodifiableView Set<MinecraftKeyWrapper> getKeys() {
        return Collections.unmodifiableSet(this.keys);
    }

    record PerPlayerUpdateEntry(PreparedAdvancementWrapper advancementWrapper, AbstractPerPlayerAdvancementDisplay display, int progression) {
    }

    record PerTeamUpdateEntry(PreparedAdvancementWrapper advancementWrapper, AbstractPerTeamAdvancementDisplay display, int progression) {
    }

    record ImmutableUpdateEntry(PreparedAdvancementWrapper advancementWrapper, AbstractImmutableAdvancementDisplay display, int progression) {
    }
}

