/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI;

import com.fren_gor.ultimateAdvancementAPI.AdvancementUpdater;
import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.BaseAdvancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.RootAdvancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractImmutableAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractPerPlayerAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractPerTeamAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.database.DatabaseManager;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.events.EventManager;
import com.fren_gor.ultimateAdvancementAPI.events.PlayerLoadingCompletedEvent;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.AdvancementDisposeEvent;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.AdvancementDisposedEvent;
import com.fren_gor.ultimateAdvancementAPI.events.advancement.AdvancementRegistrationEvent;
import com.fren_gor.ultimateAdvancementAPI.exceptions.DisposedException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.DuplicatedException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.InvalidAdvancementException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.UserNotLoadedException;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.MinecraftKeyWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementFrameTypeWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.packets.ISendable;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.packets.PacketPlayOutAdvancementsWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.packets.PacketPlayOutSelectAdvancementTabWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.fren_gor.ultimateAdvancementAPI.util.CompositeMap;
import com.fren_gor.ultimateAdvancementAPI.util.LazyValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

public final class AdvancementTab {
    private final Plugin owningPlugin;
    private final EventManager eventManager;
    private final String namespace;
    private final TabDisplay tabDisplay;
    private final DatabaseManager databaseManager;
    private volatile @Unmodifiable Map<AdvancementKey, Advancement> advancements = Collections.emptyMap();
    private final Map<Player, Set<MinecraftKeyWrapper>> players = new HashMap<Player, Set<MinecraftKeyWrapper>>();
    private final AdvsUpdateRunnable updateManager;
    private RootAdvancement rootAdvancement;
    private volatile boolean initialised = false;
    private volatile boolean disposed = false;
    private boolean automaticallyShown = false;
    private boolean automaticallyGrant = false;
    private boolean showToastToTeam = true;
    private boolean sendAnnouncementMessageOnlyToTeam = false;
    @LazyValue
    private Collection<String> advNamespacedKeys;
    @LazyValue
    private Collection<BaseAdvancement> advsWithoutRoot;

    AdvancementTab(@NotNull Plugin owningPlugin, @NotNull DatabaseManager databaseManager, @NotNull String namespace, @NotNull TabDisplay tabDisplay) {
        AdvancementKey.checkNamespace(namespace);
        this.namespace = namespace;
        this.tabDisplay = Objects.requireNonNull(tabDisplay, "Tab display is null.");
        this.owningPlugin = Objects.requireNonNull(owningPlugin, "Plugin is null.");
        this.eventManager = new EventManager(owningPlugin);
        this.databaseManager = Objects.requireNonNull(databaseManager, "DatabaseManager is null.");
        this.updateManager = new AdvsUpdateRunnable();
        this.eventManager.register(this, PlayerQuitEvent.class, e -> this.players.remove(e.getPlayer()));
    }

    public boolean isActive() {
        return this.initialised && !this.disposed;
    }

    @NotNull
    @Contract(pure=true)
    public RootAdvancement getRootAdvancement() {
        this.checkInitialisation();
        return this.rootAdvancement;
    }

    @NotNull
    @Contract(pure=true)
    public @UnmodifiableView @NotNull Collection<@NotNull Advancement> getAdvancements() {
        this.checkInitialisation();
        return Collections.unmodifiableCollection(this.advancements.values());
    }

    @NotNull
    public @Unmodifiable @NotNull Collection<@NotNull BaseAdvancement> getAdvancementsWithoutRoot() {
        this.checkInitialisation();
        if (this.advsWithoutRoot != null) {
            return this.advsWithoutRoot;
        }
        ArrayList<BaseAdvancement> list = new ArrayList<BaseAdvancement>(this.advancements.size());
        for (Advancement a : this.advancements.values()) {
            if (!(a instanceof BaseAdvancement)) continue;
            BaseAdvancement base = (BaseAdvancement)a;
            list.add(base);
        }
        this.advsWithoutRoot = Collections.unmodifiableList(list);
        return this.advsWithoutRoot;
    }

    @NotNull
    @Contract(pure=true)
    public @Unmodifiable @NotNull Collection<@NotNull Advancement> getAdvancementsByClass(Class<? extends Advancement> filterClass) {
        this.checkInitialisation();
        if (filterClass == null) {
            return Collections.emptyList();
        }
        if (filterClass == Advancement.class) {
            return Collections.unmodifiableCollection(this.advancements.values());
        }
        if (this.rootAdvancement.getClass().isInstance(filterClass)) {
            return Collections.singletonList(this.rootAdvancement);
        }
        if (filterClass.isInstance(BaseAdvancement.class)) {
            ArrayList<Advancement> coll = new ArrayList<Advancement>(this.advancements.size());
            for (Advancement a : this.advancements.values()) {
                if (!a.getClass().isInstance(filterClass)) continue;
                coll.add(a);
            }
            return Collections.unmodifiableCollection(coll);
        }
        return Collections.emptyList();
    }

    @NotNull
    @Contract(pure=true)
    public @UnmodifiableView @NotNull Set<@NotNull AdvancementKey> getAdvancementsNamespacedKeys() {
        this.checkInitialisation();
        return Collections.unmodifiableSet(this.advancements.keySet());
    }

    @Contract(pure=true, value="null -> false")
    public boolean hasAdvancement(Advancement advancement) {
        this.checkInitialisation();
        if (advancement == null) {
            return false;
        }
        return this.advancements.containsKey(advancement.getKey());
    }

    @Contract(pure=true, value="null -> false")
    public boolean hasAdvancement(AdvancementKey namespacedKey) {
        this.checkInitialisation();
        return this.advancements.containsKey(namespacedKey);
    }

    @Nullable
    @Contract(pure=true, value="null -> null")
    public Advancement getAdvancement(AdvancementKey namespacedKey) {
        this.checkInitialisation();
        return this.advancements.get(namespacedKey);
    }

    @NotNull
    @Contract(pure=true)
    public @UnmodifiableView @NotNull Set<@NotNull Player> getPlayers() {
        this.checkInitialisation();
        return Collections.unmodifiableSet(this.players.keySet());
    }

    public void grantRootAdvancement(@NotNull Player player) {
        this.checkInitialisation();
        this.rootAdvancement.setProgression(player, this.rootAdvancement.getMaxProgression());
    }

    public void grantRootAdvancement(@NotNull UUID uuid) {
        this.checkInitialisation();
        this.rootAdvancement.setProgression(uuid, this.rootAdvancement.getMaxProgression());
    }

    public void grantRootAdvancement(@NotNull Player player, boolean giveRewards) {
        this.checkInitialisation();
        this.rootAdvancement.setProgression(player, this.rootAdvancement.getMaxProgression(), giveRewards);
    }

    public void grantRootAdvancement(@NotNull UUID uuid, boolean giveRewards) {
        this.checkInitialisation();
        this.rootAdvancement.setProgression(uuid, this.rootAdvancement.getMaxProgression(), giveRewards);
    }

    public void updateAdvancementsToTeam(@NotNull Player player) throws UserNotLoadedException {
        this.updateAdvancementsToTeam(AdvancementUtils.uuidFromPlayer(player));
    }

    public void updateAdvancementsToTeam(@NotNull UUID uuid) throws UserNotLoadedException {
        this.updateAdvancementsToTeam(this.databaseManager.getTeamProgression(uuid));
    }

    public void updateAdvancementsToTeam(@NotNull TeamProgression pro) {
        this.checkInitialisation();
        AdvancementUtils.validateTeamProgression(pro);
        this.updateManager.schedule(pro);
    }

    public void registerAdvancements(@NotNull RootAdvancement rootAdvancement, BaseAdvancement ... advancements) {
        this.registerAdvancements(rootAdvancement, Sets.newHashSet((Object[])advancements));
    }

    public void registerAdvancements(@NotNull RootAdvancement rootAdvancement, @NotNull Set<BaseAdvancement> advancements) {
        if (this.disposed) {
            throw new DisposedException("AdvancementTab is disposed.");
        }
        if (this.initialised) {
            throw new IllegalStateException("Tab is already initialised.");
        }
        Preconditions.checkNotNull((Object)rootAdvancement, (Object)"RootAdvancement is null.");
        Preconditions.checkArgument((boolean)this.isOwnedByThisTab(rootAdvancement), (Object)("RootAdvancement " + String.valueOf(rootAdvancement) + " is not owned by this tab."));
        for (BaseAdvancement a : advancements) {
            if (a == null) {
                throw new IllegalArgumentException("An advancement is null.");
            }
            if (this.isOwnedByThisTab(a)) continue;
            throw new IllegalArgumentException("Advancement " + a.getKey().toString() + " is not owned by this tab.");
        }
        HashMap<AdvancementKey, Advancement> map = new HashMap<AdvancementKey, Advancement>();
        this.rootAdvancement = rootAdvancement;
        map.put(rootAdvancement.getKey(), rootAdvancement);
        PluginManager pluginManager = Bukkit.getPluginManager();
        this.callOnRegister(rootAdvancement);
        try {
            pluginManager.callEvent((Event)new AdvancementRegistrationEvent(rootAdvancement));
        }
        catch (Exception e) {
            this.onRegisterFail();
            throw e;
        }
        for (BaseAdvancement baseAdvancement : advancements) {
            if (map.put(baseAdvancement.getKey(), baseAdvancement) != null) {
                this.onRegisterFail();
                throw new DuplicatedException("Advancement " + String.valueOf(baseAdvancement.getKey()) + " is duplicated.");
            }
            this.callOnRegister(baseAdvancement);
            try {
                pluginManager.callEvent((Event)new AdvancementRegistrationEvent(baseAdvancement));
            }
            catch (Exception e) {
                this.onRegisterFail();
                throw e;
            }
        }
        this.advancements = Collections.unmodifiableMap(map);
        this.initialised = true;
        for (Advancement advancement : this.advancements.values()) {
            this.callValidation(advancement);
        }
    }

    private void callOnRegister(Advancement adv) {
        try {
            adv.onRegister();
        }
        catch (Exception e) {
            this.onRegisterFail();
            throw new RuntimeException("Exception occurred while registering advancement " + String.valueOf(adv.getKey()) + ":", e);
        }
    }

    private void callValidation(Advancement adv) {
        try {
            adv.validateRegister();
        }
        catch (InvalidAdvancementException e) {
            this.onRegisterFail();
            throw new RuntimeException("Advancement " + String.valueOf(adv.getKey()) + " is not valid:", e);
        }
        catch (Exception e) {
            this.onRegisterFail();
            throw new RuntimeException("Exception occurred while validating advancement " + String.valueOf(adv.getKey()) + ":", e);
        }
    }

    private void onRegisterFail() {
        this.initialised = false;
        this.advancements = Collections.emptyMap();
        this.rootAdvancement = null;
    }

    public void showTab(Player ... players) {
        this.checkInitialisation();
        Preconditions.checkNotNull((Object)players, (Object)"Player[] is null.");
        for (Player p : players) {
            try {
                this.showTab(p);
            }
            catch (Exception e) {
                this.owningPlugin.getLogger().log(Level.SEVERE, "Couldn't show tab " + this.namespace + " to player " + p.getName(), e);
            }
        }
    }

    public void showTab(@NotNull Player player) {
        this.checkInitialisation();
        Preconditions.checkNotNull((Object)player, (Object)"Player is null.");
        if (!this.players.containsKey(player)) {
            this.players.put(player, Collections.emptySet());
            this.updateAdvancementsToTeam(player);
        }
    }

    public void hideTab(Player ... players) {
        this.checkInitialisation();
        Preconditions.checkNotNull((Object)players, (Object)"Player[] is null.");
        for (Player p : players) {
            try {
                this.hideTab(p);
            }
            catch (Exception e) {
                this.owningPlugin.getLogger().log(Level.SEVERE, "Couldn't hide tab " + this.namespace + " to player " + p.getName(), e);
            }
        }
    }

    public void hideTab(@NotNull Player player) {
        this.checkInitialisation();
        Preconditions.checkNotNull((Object)player, (Object)"Player is null.");
        if (this.isShownTo(player)) {
            this.removePlayer(player, this.players.remove(player));
        }
    }

    private void removePlayer(@NotNull Player player, Set<MinecraftKeyWrapper> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        try {
            PacketPlayOutAdvancementsWrapper.craftRemovePacket(keys).sendTo(player);
        }
        catch (ReflectiveOperationException e) {
            this.owningPlugin.getLogger().log(Level.SEVERE, "Couldn't send remove packet to player " + player.getName(), e);
        }
    }

    void dispose() {
        AdvancementUtils.checkSync();
        if (this.disposed) {
            throw new DisposedException("AdvancementTab is already disposed");
        }
        this.disposed = true;
        this.eventManager.disable();
        this.updateManager.dispose();
        if (!this.initialised) {
            return;
        }
        Iterator<Map.Entry<Player, Set<MinecraftKeyWrapper>>> it = this.players.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Player, Set<MinecraftKeyWrapper>> e = it.next();
            this.removePlayer(e.getKey(), e.getValue());
            it.remove();
        }
        PluginManager pluginManager = Bukkit.getPluginManager();
        for (Advancement a : this.advancements.values()) {
            try {
                try {
                    pluginManager.callEvent((Event)new AdvancementDisposeEvent(a));
                }
                catch (Exception e) {
                    this.owningPlugin.getLogger().log(Level.WARNING, "An exception has occurred while calling AdvancementDisposeEvent for " + String.valueOf(a), e);
                }
                a.onDispose();
                try {
                    pluginManager.callEvent((Event)new AdvancementDisposedEvent(a.getKey()));
                }
                catch (Exception e) {
                    this.owningPlugin.getLogger().log(Level.WARNING, "An exception has occurred while calling AdvancementDisposedEvent for " + String.valueOf(a), e);
                }
            }
            catch (Exception e) {
                this.owningPlugin.getLogger().log(Level.SEVERE, "An exception occurred disposing advancement " + String.valueOf(a), e);
            }
        }
        this.advancements = Collections.emptyMap();
        this.rootAdvancement = null;
        this.advNamespacedKeys = null;
        this.advsWithoutRoot = null;
    }

    @Contract(pure=true, value="null -> false")
    public boolean isShownTo(Player player) {
        this.checkInitialisation();
        return this.players.containsKey(player);
    }

    @NotNull
    public @Unmodifiable @NotNull Collection<@NotNull String> getAdvancementsAsStrings() {
        this.checkInitialisation();
        if (this.advNamespacedKeys != null) {
            return this.advNamespacedKeys;
        }
        ArrayList<String> list = new ArrayList<String>(this.advancements.size());
        for (AdvancementKey key : this.advancements.keySet()) {
            list.add(key.toString());
        }
        this.advNamespacedKeys = Collections.unmodifiableCollection(list);
        return this.advNamespacedKeys;
    }

    @Contract(pure=true)
    public boolean isOwnedByThisTab(@NotNull Advancement advancement) {
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        return advancement.getKey().getNamespace().equals(this.namespace);
    }

    @NotNull
    @Contract(value="-> this")
    public AdvancementTab automaticallyShowToPlayers() {
        this.checkInitialisation();
        if (!this.automaticallyShown) {
            this.automaticallyShown = true;
            this.registerEvent(PlayerLoadingCompletedEvent.class, EventPriority.LOWEST, e -> this.showTab(e.getPlayer()));
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!this.databaseManager.isLoadedAndOnline(p)) continue;
                this.showTab(p);
            }
        }
        return this;
    }

    @NotNull
    @Contract(value="-> this")
    public AdvancementTab automaticallyGrantRootAdvancement() {
        this.checkInitialisation();
        if (!this.automaticallyGrant) {
            this.automaticallyGrant = true;
            this.registerEvent(PlayerLoadingCompletedEvent.class, EventPriority.LOW, e -> this.grantRootAdvancement(e.getPlayer()));
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!this.databaseManager.isLoadedAndOnline(p)) continue;
                this.grantRootAdvancement(p);
            }
        }
        return this;
    }

    public <E extends Event> void registerEvent(@NotNull Class<E> eventClass, @NotNull Consumer<E> consumer) {
        try {
            this.eventManager.register(this, eventClass, consumer);
        }
        catch (IllegalStateException e) {
            throw new DisposedException(e);
        }
    }

    public <E extends Event> void registerEvent(@NotNull Class<E> eventClass, @NotNull EventPriority priority, @NotNull Consumer<E> consumer) {
        try {
            this.eventManager.register(this, eventClass, priority, consumer);
        }
        catch (IllegalStateException e) {
            throw new DisposedException(e);
        }
    }

    private void checkInitialisation() {
        if (this.disposed) {
            throw new DisposedException("AdvancementTab is disposed");
        }
        if (!this.initialised) {
            throw new IllegalStateException("AdvancementTab has not been initialised yet.");
        }
    }

    @NotNull
    public String toString() {
        return this.namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancementTab that = (AdvancementTab)o;
        return this.namespace.equals(that.namespace);
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    @NotNull
    public Plugin getOwningPlugin() {
        return this.owningPlugin;
    }

    @NotNull
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public TabDisplay getTabDisplay() {
        return this.tabDisplay;
    }

    public boolean doesShowToastToTeam() {
        return this.showToastToTeam;
    }

    public void setShowToastToTeam(boolean showToastToTeam) {
        this.showToastToTeam = showToastToTeam;
    }

    public boolean doesSendAnnouncementMessageOnlyToTeam() {
        return this.sendAnnouncementMessageOnlyToTeam;
    }

    public void setSendAnnouncementMessageOnlyToTeam(boolean sendAnnouncementMessageOnlyToTeam) {
        this.sendAnnouncementMessageOnlyToTeam = sendAnnouncementMessageOnlyToTeam;
    }

    @NotNull
    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TabDisplay {
    }

    private class AdvsUpdateRunnable
    implements Runnable {
        private final Set<TeamProgression> advsToUpdate = new HashSet<TeamProgression>();
        private boolean scheduled = false;
        private BukkitTask task;
        private final PreparedAdvancementWrapper internalRoot;
        @LazyValue
        private TabDisplayData immutableDisplayData;

        public AdvsUpdateRunnable() {
            try {
                MinecraftKeyWrapper internalRootKey = MinecraftKeyWrapper.craft(AdvancementTab.this.namespace, "_-uaapi-internal-_root");
                this.internalRoot = PreparedAdvancementWrapper.craft(internalRootKey, 1);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        public void schedule(@NotNull TeamProgression progression) {
            if (!this.scheduled) {
                this.scheduled = true;
                this.task = Bukkit.getScheduler().runTaskLater(AdvancementTab.this.owningPlugin, (Runnable)this, 1L);
            }
            this.advsToUpdate.add(progression);
        }

        public void dispose() {
            if (this.task != null) {
                this.task.cancel();
                this.advsToUpdate.clear();
                this.scheduled = false;
            }
        }

        @Override
        public void run() {
            TabDisplay tabDisplay;
            int sizeApprox = AdvancementTab.this.advancements.size() + 16;
            if (this.immutableDisplayData == null && (tabDisplay = AdvancementTab.this.tabDisplay) instanceof ImmutableTabDisplay) {
                ImmutableTabDisplay display = (ImmutableTabDisplay)tabDisplay;
                try {
                    this.immutableDisplayData = new TabDisplayData(display.getBackgroundTexture(), display.getIcon(), display.getTitle());
                }
                catch (Exception e) {
                    AdvancementTab.this.owningPlugin.getLogger().log(Level.SEVERE, "Error sending advancements", e);
                    return;
                }
            }
            block6: for (TeamProgression pro : this.advsToUpdate) {
                if (!pro.isValid()) continue;
                ImmutableAndPerTeamUpdateData update = null;
                for (UUID u : pro.getMembers()) {
                    try {
                        Player player = Bukkit.getPlayer((UUID)u);
                        if (player == null || !AdvancementTab.this.players.containsKey(player) || !AdvancementTab.this.databaseManager.isLoadedAndOnline(player)) continue;
                        if (update == null) {
                            try {
                                update = this.updateTeam(pro, this.immutableDisplayData, sizeApprox);
                            }
                            catch (Exception e) {
                                AdvancementTab.this.owningPlugin.getLogger().log(Level.SEVERE, "Error sending advancements to team with id " + pro.getTeamId(), e);
                                continue block6;
                            }
                        }
                        this.updatePlayer(player, update, sizeApprox);
                    }
                    catch (Exception e) {
                        AdvancementTab.this.owningPlugin.getLogger().log(Level.SEVERE, "Error sending advancements to player " + String.valueOf(u), e);
                    }
                }
            }
            this.task = null;
            this.advsToUpdate.clear();
            this.scheduled = false;
        }

        private ImmutableAndPerTeamUpdateData updateTeam(TeamProgression pro, TabDisplayData displayData, int sizeApprox) throws ReflectiveOperationException {
            AdvancementDisplayWrapper display;
            AdvancementDisplayWrapper internalRootDisplay;
            boolean tabDisplayAndRootAreImmutableOrPerTeam;
            PreparedAdvancementDisplayWrapper rootDisplay;
            Object object;
            if (displayData == null && (object = AdvancementTab.this.tabDisplay) instanceof PerTeamTabDisplay) {
                PerTeamTabDisplay display2 = (PerTeamTabDisplay)object;
                displayData = new TabDisplayData(display2.getBackgroundTexture(pro), display2.getIcon(pro), display2.getTitle(pro));
            }
            AdvancementUpdater updater = new AdvancementUpdater(AdvancementTab.this.rootAdvancement.getKey(), sizeApprox);
            for (Advancement advancement : AdvancementTab.this.advancements.values()) {
                advancement.onUpdate(pro, updater);
            }
            PacketPlayOutSelectAdvancementTabWrapper noTab = PacketPlayOutSelectAdvancementTabWrapper.craftSelectNone();
            PacketPlayOutSelectAdvancementTabWrapper thisTab = PacketPlayOutSelectAdvancementTabWrapper.craftSelect(this.internalRoot.getKey());
            HashMap perTeamToSend = Maps.newHashMapWithExpectedSize((int)sizeApprox);
            Object object2 = updater.getRootDisplay();
            if (object2 instanceof AbstractImmutableAdvancementDisplay) {
                AbstractImmutableAdvancementDisplay immutable = (AbstractImmutableAdvancementDisplay)object2;
                rootDisplay = immutable.getNMSWrapper();
            } else {
                object2 = updater.getRootDisplay();
                if (object2 instanceof AbstractPerTeamAdvancementDisplay) {
                    AbstractPerTeamAdvancementDisplay perTeam = (AbstractPerTeamAdvancementDisplay)object2;
                    rootDisplay = perTeam.getNMSWrapper(pro);
                } else {
                    rootDisplay = null;
                }
            }
            if (rootDisplay != null) {
                perTeamToSend.put(updater.getRootWrapper().withParent(this.internalRoot).toAdvancementWrapper(rootDisplay.toBaseAdvancementDisplay()), updater.getRootProgression());
            }
            boolean bl = tabDisplayAndRootAreImmutableOrPerTeam = rootDisplay != null && displayData != null;
            if (tabDisplayAndRootAreImmutableOrPerTeam) {
                internalRootDisplay = displayData.toRootDisplayWrapper(rootDisplay.getX(), rootDisplay.getY(), rootDisplay::getIcon, rootDisplay::getTitle);
                perTeamToSend.put(this.internalRoot.toAdvancementWrapper(internalRootDisplay), 0);
            } else {
                internalRootDisplay = null;
            }
            for (AdvancementUpdater.ImmutableUpdateEntry immutableUpdateEntry : updater.getImmutableAdvancements()) {
                display = immutableUpdateEntry.display().getNMSWrapper().toBaseAdvancementDisplay();
                perTeamToSend.put(immutableUpdateEntry.advancementWrapper().toAdvancementWrapper(display), immutableUpdateEntry.progression());
            }
            for (AdvancementUpdater.PerTeamUpdateEntry perTeamUpdateEntry : updater.getPerTeamAdvancements()) {
                display = perTeamUpdateEntry.display().getNMSWrapper(pro).toBaseAdvancementDisplay();
                perTeamToSend.put(perTeamUpdateEntry.advancementWrapper().toAdvancementWrapper(display), perTeamUpdateEntry.progression());
            }
            return new ImmutableAndPerTeamUpdateData(updater, perTeamToSend, displayData, tabDisplayAndRootAreImmutableOrPerTeam, internalRootDisplay, rootDisplay, noTab, thisTab);
        }

        private void updatePlayer(Player player, ImmutableAndPerTeamUpdateData update, int sizeApprox) throws ReflectiveOperationException {
            AdvancementDisplayWrapper internalRootDisplay;
            TabDisplayData displayData = update.displayData;
            if (displayData == null) {
                TabDisplay tabDisplay = AdvancementTab.this.tabDisplay;
                if (tabDisplay instanceof PerPlayerTabDisplay) {
                    PerPlayerTabDisplay display = (PerPlayerTabDisplay)tabDisplay;
                    displayData = new TabDisplayData(display.getBackgroundTexture(player), display.getIcon(player), display.getTitle(player));
                } else {
                    throw new RuntimeException("Invalid tab display " + AdvancementTab.this.tabDisplay.getClass().getName());
                }
            }
            HashMap perPlayerToSend = Maps.newHashMapWithExpectedSize((int)sizeApprox);
            PreparedAdvancementDisplayWrapper rootDisplay = update.rootDisplay;
            if (rootDisplay == null) {
                AbstractAdvancementDisplay abstractAdvancementDisplay = update.updater.getRootDisplay();
                if (!(abstractAdvancementDisplay instanceof AbstractPerPlayerAdvancementDisplay)) {
                    throw new RuntimeException("Invalid root display " + update.updater.getRootDisplay().getClass().getName());
                }
                AbstractPerPlayerAdvancementDisplay perPlayer = (AbstractPerPlayerAdvancementDisplay)abstractAdvancementDisplay;
                rootDisplay = perPlayer.getNMSWrapper(player);
                perPlayerToSend.put(update.updater.getRootWrapper().withParent(this.internalRoot).toAdvancementWrapper(rootDisplay.toBaseAdvancementDisplay()), update.updater.getRootProgression());
            }
            if ((internalRootDisplay = update.internalRootDisplay) == null) {
                internalRootDisplay = displayData.toRootDisplayWrapper(rootDisplay.getX(), rootDisplay.getY(), rootDisplay::getIcon, rootDisplay::getTitle);
            }
            if (!update.internalRootAlreadyAddedToMap) {
                perPlayerToSend.put(this.internalRoot.toAdvancementWrapper(internalRootDisplay), 0);
            }
            for (AdvancementUpdater.PerPlayerUpdateEntry entry : update.updater.getPerPlayerAdvancements()) {
                AdvancementDisplayWrapper display = entry.display().getNMSWrapper(player).toBaseAdvancementDisplay();
                perPlayerToSend.put(entry.advancementWrapper().toAdvancementWrapper(display), entry.progression());
            }
            Map toSendMap = perPlayerToSend.isEmpty() ? update.perTeamToSend : (update.perTeamToSend.isEmpty() ? perPlayerToSend : CompositeMap.of(new Map[]{update.perTeamToSend, perPlayerToSend}));
            PacketPlayOutAdvancementsWrapper sendPacket = PacketPlayOutAdvancementsWrapper.craftSendPacket(toSendMap);
            update.noTab.sendTo(player);
            @Nullable Set<MinecraftKeyWrapper> oldKeys = AdvancementTab.this.players.put(player, update.updater.getKeys());
            if (oldKeys != null && !oldKeys.isEmpty()) {
                try {
                    PacketPlayOutAdvancementsWrapper.craftRemovePacket(oldKeys).sendTo(player);
                }
                catch (ReflectiveOperationException e) {
                    AdvancementTab.this.players.put(player, oldKeys);
                    update.thisTab.sendTo(player);
                    throw e;
                }
            }
            sendPacket.sendTo(player);
            update.thisTab.sendTo(player);
        }

        private record TabDisplayData(@NotNull String backgroundTexture, @NotNull Optional<ItemStack> icon, @NotNull Optional<BaseComponent> title) {
            @NotNull
            public AdvancementDisplayWrapper toRootDisplayWrapper(float rootX, float rootY, Supplier<? extends ItemStack> rootIcon, Supplier<? extends BaseComponent> rootTitle) throws ReflectiveOperationException {
                ItemStack icon = this.icon.orElseGet(rootIcon);
                BaseComponent title = this.title.orElseGet(rootTitle);
                return AdvancementDisplayWrapper.craft(icon, title, (BaseComponent)new TextComponent(""), AdvancementFrameTypeWrapper.TASK, rootX - 0.2f, rootY, false, false, true, this.backgroundTexture);
            }
        }

        private record ImmutableAndPerTeamUpdateData(@NotNull AdvancementUpdater updater, @NotNull Map<AdvancementWrapper, Integer> perTeamToSend, @Nullable TabDisplayData displayData, boolean internalRootAlreadyAddedToMap, @Nullable AdvancementDisplayWrapper internalRootDisplay, @Nullable PreparedAdvancementDisplayWrapper rootDisplay, @NotNull ISendable noTab, @NotNull ISendable thisTab) {
        }
    }

    @FunctionalInterface
    public static interface PerPlayerTabDisplay
    extends TabDisplay {
        @NotNull
        public String getBackgroundTexture(@NotNull Player var1);

        @NotNull
        default public Optional<ItemStack> getIcon(@NotNull Player player) {
            return Optional.empty();
        }

        @NotNull
        default public Optional<BaseComponent> getTitle(@NotNull Player player) {
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface PerTeamTabDisplay
    extends TabDisplay {
        @NotNull
        public String getBackgroundTexture(@NotNull TeamProgression var1);

        @NotNull
        default public Optional<ItemStack> getIcon(@NotNull TeamProgression teamProgression) {
            return Optional.empty();
        }

        @NotNull
        default public Optional<BaseComponent> getTitle(@NotNull TeamProgression teamProgression) {
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface ImmutableTabDisplay
    extends TabDisplay {
        @NotNull
        public String getBackgroundTexture();

        @NotNull
        default public Optional<ItemStack> getIcon() {
            return Optional.empty();
        }

        @NotNull
        default public Optional<BaseComponent> getTitle() {
            return Optional.empty();
        }
    }
}

