/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.ConfigManager;
import com.fren_gor.ultimateAdvancementAPI.PaperEvents;
import com.fren_gor.ultimateAdvancementAPI.commands.CommandAPIManager;
import com.fren_gor.ultimateAdvancementAPI.exceptions.InvalidVersionException;
import com.fren_gor.ultimateAdvancementAPI.metrics.BStats;
import com.fren_gor.ultimateAdvancementAPI.nms.util.ReflectionUtil;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.VanillaAdvancementDisablerWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class AdvancementPlugin
extends JavaPlugin {
    private static final int RESOURCE_ID = 95585;
    private static final boolean IS_PAPER = ReflectionUtil.classExists("io.papermc.paper.advancement.AdvancementDisplay");
    private static AdvancementPlugin instance;
    private AdvancementMain main;
    private ConfigManager configManager;
    private boolean correctVersion = true;
    private boolean commandsEnabled = false;
    @Nullable
    private CommandAPIManager.ILoadable commandAPIManager;

    public void onLoad() {
        instance = this;
        this.main = new AdvancementMain((Plugin)this);
        try {
            this.main.load();
        }
        catch (InvalidVersionException e) {
            ConsoleCommandSender sender = Bukkit.getConsoleSender();
            sender.sendMessage("\u00a74================================================================================");
            sender.sendMessage("");
            sender.sendMessage("\u00a7cInvalid Minecraft Version!");
            if (e.getExpected() != null) {
                sender.sendMessage("\u00a7eThis version of UltimateAdvancementAPI supports only " + e.getExpected());
            } else {
                sender.sendMessage("\u00a7eThis version of UltimateAdvancementAPI does not support your minecraft version");
            }
            sender.sendMessage("\u00a7ePlease download and use the correct plugin version");
            sender.sendMessage("");
            sender.sendMessage("\u00a74================================================================================");
            this.correctVersion = false;
            return;
        }
        this.commandAPIManager = CommandAPIManager.loadManager(this.main.getLibbyManager());
        if (this.commandAPIManager != null) {
            try {
                this.commandAPIManager.onLoad(this.main, this);
            }
            catch (Throwable t) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[UltimateAdvancementAPI] An exception occurred while loading commands for UltimateAdvancementAPI, continuing without them.");
                this.getLogger().log(Level.WARNING, "An exception occurred while loading commands for UltimateAdvancementAPI", t);
                this.commandAPIManager = null;
            }
        }
    }

    public void onEnable() {
        if (!this.correctVersion) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.configManager = new ConfigManager(this);
        this.configManager.saveDefault(false);
        if (this.configManager.loadVariables()) {
            this.main.disable();
            this.configManager = null;
            return;
        }
        try {
            this.configManager.enable(this.main);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[UltimateAdvancementAPI] An exception occurred while enabling UltimateAdvancementAPI.");
            this.getLogger().log(Level.SEVERE, "An exception occurred while enabling UltimateAdvancementAPI", e);
            return;
        }
        if (this.commandAPIManager != null) {
            try {
                this.commandAPIManager.onEnable();
                this.commandsEnabled = true;
            }
            catch (Throwable t) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[UltimateAdvancementAPI] An exception occurred while enabling commands for UltimateAdvancementAPI, continuing without them.");
                this.getLogger().log(Level.WARNING, "An exception occurred while enabling commands for UltimateAdvancementAPI", t);
            }
        }
        if (this.configManager.getDisableVanillaAdvancements() || this.configManager.getDisableVanillaRecipeAdvancements()) {
            this.disableVanillaAdvancements();
            if (IS_PAPER && PaperEvents.IS_SERVER_RESOURCES_RELOADED_EVENT_SUPPORTED) {
                PaperEvents events = new PaperEvents(this.main.getEventManager());
                events.registerServerResourcesReloadedEvent((Object)this, this::disableVanillaAdvancements);
            }
        }
        BStats.init(this);
        this.checkForUpdates();
    }

    public void onDisable() {
        if (!this.correctVersion) {
            return;
        }
        if (this.commandAPIManager != null && this.commandsEnabled) {
            try {
                this.commandAPIManager.onDisable();
            }
            catch (Throwable t) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[UltimateAdvancementAPI] An exception occurred while disabling commands for UltimateAdvancementAPI:");
                this.getLogger().log(Level.WARNING, "An exception occurred while disabling commands for UltimateAdvancementAPI", t);
            }
        }
        this.main.disable();
        this.main = null;
    }

    private void disableVanillaAdvancements() {
        new BukkitRunnable(){

            public void run() {
                try {
                    VanillaAdvancementDisablerWrapper.disableVanillaAdvancements(AdvancementPlugin.this.configManager.getDisableVanillaAdvancements(), AdvancementPlugin.this.configManager.getDisableVanillaRecipeAdvancements());
                }
                catch (Exception e) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[UltimateAdvancementAPI] Cannot disable vanilla advancements.");
                    AdvancementPlugin.this.getLogger().log(Level.WARNING, "Cannot disable vanilla advancements", e);
                }
            }
        }.runTaskLater((Plugin)this, 20L);
    }

    private void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=95585").openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNextLine() && !this.getDescription().getVersion().equalsIgnoreCase(scanner.next())) {
                    AdvancementUtils.runSync((Plugin)this, () -> this.getLogger().info("A new version of " + this.getDescription().getName() + " is out! Download it at https://modrinth.com/plugin/ultimateadvancementapi"));
                }
            }
            catch (Exception e) {
                AdvancementUtils.runSync((Plugin)this, () -> this.getLogger().info("Cannot look for updates: " + e.getMessage()));
            }
        });
    }

    public static AdvancementPlugin getInstance() {
        return instance;
    }

    public AdvancementMain getMain() {
        return this.main;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

