/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI;

import com.fren_gor.ultimateAdvancementAPI.AdvancementTab;
import com.fren_gor.ultimateAdvancementAPI.PaperEvents;
import com.fren_gor.ultimateAdvancementAPI.UltimateAdvancementAPI;
import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.database.DatabaseManager;
import com.fren_gor.ultimateAdvancementAPI.database.IDatabase;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.events.EventManager;
import com.fren_gor.ultimateAdvancementAPI.exceptions.AsyncExecutionException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.DuplicatedException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.InvalidVersionException;
import com.fren_gor.ultimateAdvancementAPI.exceptions.UserNotLoadedException;
import com.fren_gor.ultimateAdvancementAPI.libs.net.byteflux.libby.BukkitLibraryManager;
import com.fren_gor.ultimateAdvancementAPI.nms.util.ReflectionUtil;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementKey;
import com.fren_gor.ultimateAdvancementAPI.util.AdvancementUtils;
import com.fren_gor.ultimateAdvancementAPI.util.Versions;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

public final class AdvancementMain {
    private static final AtomicBoolean LOADED = new AtomicBoolean(false);
    private static final AtomicBoolean ENABLED = new AtomicBoolean(false);
    private static final AtomicBoolean INVALID_VERSION = new AtomicBoolean(false);
    private static final boolean IS_PAPER = ReflectionUtil.classExists("io.papermc.paper.advancement.AdvancementDisplay");
    private final Plugin owningPlugin;
    private EventManager eventManager;
    private DatabaseManager databaseManager;
    private BukkitLibraryManager libbyManager;
    private final String libFolder;
    private final Map<String, AdvancementTab> tabs = Collections.synchronizedMap(new HashMap());
    private final Map<Plugin, List<AdvancementTab>> pluginMap = new HashMap<Plugin, List<AdvancementTab>>();

    public AdvancementMain(@NotNull Plugin owningPlugin) {
        Preconditions.checkNotNull((Object)owningPlugin, (Object)"Plugin is null.");
        this.owningPlugin = owningPlugin;
        this.libFolder = ".libs";
    }

    public AdvancementMain(@NotNull Plugin owningPlugin, String libFolder) {
        Preconditions.checkNotNull((Object)owningPlugin, (Object)"Plugin is null.");
        Preconditions.checkNotNull((Object)libFolder, (Object)"Lib folder is null.");
        this.owningPlugin = owningPlugin;
        this.libFolder = libFolder;
    }

    public void load() throws InvalidVersionException {
        AdvancementMain.checkSync();
        Optional<String> version = Versions.getNMSVersion();
        INVALID_VERSION.set(version.isEmpty());
        if (version.isEmpty()) {
            String fancy = Versions.getSupportedNMSVersions().stream().map(Versions::getNMSVersionsRange).collect(Collectors.joining(", ", "[", "]"));
            throw new InvalidVersionException(fancy, ReflectionUtil.MINECRAFT_VERSION, "Invalid minecraft version, couldn't load UltimateAdvancementAPI. Supported versions are " + fancy + ".");
        }
        if (!LOADED.compareAndSet(false, true)) {
            throw new IllegalStateException("UltimateAdvancementAPI is getting loaded twice.");
        }
        this.libbyManager = new BukkitLibraryManager(this.owningPlugin, this.libFolder);
        this.libbyManager.addMavenCentral();
    }

    public void enable(@NotNull @NotNull Callable<@NotNull IDatabase> databaseImplProvider) {
        Preconditions.checkNotNull(databaseImplProvider, (Object)"Database impl provider is null");
        this.commonEnablePreDatabase();
        try {
            this.databaseManager = new DatabaseManager(this, databaseImplProvider.call());
        }
        catch (Exception e) {
            this.failEnable(e);
        }
        this.commonEnablePostDatabase();
    }

    private void commonEnablePreDatabase() {
        AdvancementMain.checkSync();
        if (INVALID_VERSION.get()) {
            throw new InvalidVersionException("Incorrect minecraft version. Couldn't enable UltimateAdvancementAPI.");
        }
        if (!LOADED.get()) {
            throw new IllegalStateException("UltimateAdvancementAPI is not loaded.");
        }
        if (!this.owningPlugin.isEnabled()) {
            throw new IllegalStateException(this.owningPlugin.getName() + " is not enabled, cannot enable UltimateAdvancementAPI.");
        }
        if (!ENABLED.compareAndSet(false, true)) {
            throw new IllegalStateException("UltimateAdvancementAPI is getting enabled twice.");
        }
        this.eventManager = new EventManager(this.owningPlugin);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
    }

    private void commonEnablePostDatabase() {
        this.eventManager.register(this, PluginDisableEvent.class, EventPriority.HIGHEST, e -> this.unregisterAdvancementTabs(e.getPlugin()));
        if (IS_PAPER && PaperEvents.IS_SERVER_RESOURCES_RELOADED_EVENT_SUPPORTED) {
            PaperEvents events = new PaperEvents(this.eventManager);
            events.registerServerResourcesReloadedEvent(this, this::resendAdvancementsOnReload);
        } else {
            this.eventManager.register(this, ServerCommandEvent.class, e -> {
                if (AdvancementMain.isMcReload(e.getCommand())) {
                    this.resendAdvancementsOnReload();
                }
            });
            this.eventManager.register(this, PlayerCommandPreprocessEvent.class, e -> {
                if (AdvancementMain.isMcReload(e.getMessage())) {
                    this.resendAdvancementsOnReload();
                }
            });
        }
        UltimateAdvancementAPI.main = this;
    }

    private void resendAdvancementsOnReload() {
        AdvancementUtils.runSync(this, 20L, () -> Bukkit.getOnlinePlayers().forEach(p -> {
            try {
                this.updateAdvancementsToTeam((Player)p);
            }
            catch (UserNotLoadedException userNotLoadedException) {
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Could not resend advancements to " + p.getName(), e);
            }
        }));
    }

    @Contract(value="_ -> fail")
    private void failEnable(Exception e) {
        this.disable();
        throw new RuntimeException("Exception setting up database.", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        AdvancementMain.checkSync();
        if (INVALID_VERSION.get()) {
            throw new InvalidVersionException("Incorrect minecraft version. Couldn't disable UltimateAdvancementAPI.");
        }
        if (!LOADED.compareAndSet(true, false)) {
            return;
        }
        UltimateAdvancementAPI.main = null;
        if (ENABLED.getAndSet(false)) {
            if (this.eventManager != null) {
                this.eventManager.disable();
            }
            this.pluginMap.clear();
            Map<String, AdvancementTab> map = this.tabs;
            synchronized (map) {
                Iterator<AdvancementTab> it = this.tabs.values().iterator();
                while (it.hasNext()) {
                    AdvancementTab tab = it.next();
                    try {
                        if (tab.isActive()) {
                            tab.dispose();
                        }
                        it.remove();
                    }
                    catch (Exception t) {
                        this.owningPlugin.getLogger().log(Level.SEVERE, "Couldn't disable tab " + tab.getNamespace(), t);
                    }
                }
            }
            if (this.databaseManager != null) {
                this.databaseManager.close();
            }
        }
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public AdvancementTab createAdvancementTab(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String backgroundTexture) throws DuplicatedException {
        Preconditions.checkNotNull((Object)backgroundTexture, (Object)"Background texture is null.");
        return this.createAdvancementTab(plugin, namespace, () -> backgroundTexture);
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public AdvancementTab createAdvancementTab(@NotNull Plugin plugin, @NotNull String namespace, @NotNull AdvancementTab.ImmutableTabDisplay tabDisplay) throws DuplicatedException {
        Preconditions.checkNotNull((Object)tabDisplay, (Object)"ImmutableTabDisplay is null.");
        return this.createAdvancementTab(plugin, namespace, (AdvancementTab.TabDisplay)tabDisplay);
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public AdvancementTab createAdvancementTab(@NotNull Plugin plugin, @NotNull String namespace, @NotNull AdvancementTab.PerTeamTabDisplay tabDisplay) throws DuplicatedException {
        Preconditions.checkNotNull((Object)tabDisplay, (Object)"PerTeamTabDisplay is null.");
        return this.createAdvancementTab(plugin, namespace, (AdvancementTab.TabDisplay)tabDisplay);
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public AdvancementTab createAdvancementTab(@NotNull Plugin plugin, @NotNull String namespace, @NotNull AdvancementTab.PerPlayerTabDisplay tabDisplay) throws DuplicatedException {
        Preconditions.checkNotNull((Object)tabDisplay, (Object)"PerPlayerTabDisplay is null.");
        return this.createAdvancementTab(plugin, namespace, (AdvancementTab.TabDisplay)tabDisplay);
    }

    @NotNull
    private AdvancementTab createAdvancementTab(@NotNull Plugin plugin, @NotNull String namespace, @NotNull AdvancementTab.TabDisplay tabDisplay) {
        AdvancementMain.checkInitialisation();
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin is null.");
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace is null.");
        if (this.tabs.containsKey(namespace)) {
            throw new DuplicatedException("An AdvancementTab with '" + namespace + "' namespace already exists.");
        }
        AdvancementTab tab = new AdvancementTab(plugin, this.databaseManager, namespace, tabDisplay);
        this.tabs.put(namespace, tab);
        this.pluginMap.computeIfAbsent(plugin, p -> new LinkedList()).add(tab);
        return tab;
    }

    @Nullable
    public AdvancementTab getAdvancementTab(@NotNull String namespace) {
        AdvancementMain.checkInitialisation();
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace is null.");
        return this.tabs.get(namespace);
    }

    public boolean isAdvancementTabRegistered(@NotNull String namespace) {
        AdvancementMain.checkInitialisation();
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace is null.");
        return this.tabs.containsKey(namespace);
    }

    @NotNull
    public @UnmodifiableView @NotNull Collection<@NotNull AdvancementTab> getPluginAdvancementTabs(@NotNull Plugin plugin) {
        AdvancementMain.checkInitialisation();
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin is null.");
        return Collections.unmodifiableCollection(this.pluginMap.getOrDefault(plugin, Collections.emptyList()));
    }

    public void unregisterAdvancementTab(@NotNull String namespace) {
        AdvancementMain.checkInitialisation();
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace is null.");
        AdvancementTab tab = this.tabs.remove(namespace);
        if (tab != null) {
            tab.dispose();
        }
    }

    public void unregisterAdvancementTabs(@NotNull Plugin plugin) {
        AdvancementMain.checkInitialisation();
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin is null.");
        List<AdvancementTab> tabs = this.pluginMap.remove(plugin);
        if (tabs != null) {
            for (AdvancementTab t : tabs) {
                this.unregisterAdvancementTab(t.getNamespace());
            }
        }
    }

    @Nullable
    public Advancement getAdvancement(@NotNull String namespacedKey) {
        AdvancementMain.checkInitialisation();
        int colon = namespacedKey.indexOf(58);
        if (colon <= 0 || colon == namespacedKey.length() - 1) {
            throw new IllegalArgumentException("Malformed namespaced key '" + namespacedKey + "'");
        }
        return this.getAdvancement(namespacedKey.substring(0, colon), namespacedKey.substring(colon + 1));
    }

    @Nullable
    public Advancement getAdvancement(@NotNull String namespace, @NotNull String key) {
        AdvancementMain.checkInitialisation();
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace is null.");
        Preconditions.checkNotNull((Object)key, (Object)"Key is null.");
        return this.getAdvancement(new AdvancementKey(namespace, key));
    }

    @Nullable
    public Advancement getAdvancement(@NotNull AdvancementKey namespacedKey) {
        AdvancementMain.checkInitialisation();
        Preconditions.checkNotNull((Object)namespacedKey, (Object)"AdvancementKey is null.");
        AdvancementTab tab = this.tabs.get(namespacedKey.getNamespace());
        if (tab == null || !tab.isActive()) {
            return null;
        }
        return tab.getAdvancement(namespacedKey);
    }

    @NotNull
    @Contract(pure=true)
    public @NotNull @Unmodifiable Set<@NotNull String> getAdvancementTabNamespaces() {
        AdvancementMain.checkInitialisation();
        return Set.copyOf(this.tabs.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @Contract(pure=true, value="_ -> new")
    public @NotNull List<@NotNull String> filterNamespaces(@Nullable String input) {
        AdvancementMain.checkInitialisation();
        LinkedList<String> l = new LinkedList<String>();
        Map<String, AdvancementTab> map = this.tabs;
        synchronized (map) {
            if (input == null || input.isEmpty()) {
                for (Map.Entry<String, AdvancementTab> e : this.tabs.entrySet()) {
                    if (!e.getValue().isActive()) continue;
                    l.addAll(e.getValue().getAdvancementsAsStrings());
                }
            } else {
                int index = input.indexOf(58);
                if (index != -1) {
                    String sub = input.substring(0, index);
                    for (Map.Entry<String, AdvancementTab> e : this.tabs.entrySet()) {
                        if (!e.getValue().isActive() || !e.getKey().equals(sub)) continue;
                        for (String s : e.getValue().getAdvancementsAsStrings()) {
                            if (!s.startsWith(input)) continue;
                            l.add(s);
                        }
                    }
                } else {
                    for (Map.Entry<String, AdvancementTab> e : this.tabs.entrySet()) {
                        if (!e.getValue().isActive() || !e.getKey().startsWith(input)) continue;
                        l.addAll(e.getValue().getAdvancementsAsStrings());
                    }
                }
            }
        }
        return l;
    }

    @NotNull
    public @Unmodifiable @NotNull Collection<@NotNull AdvancementTab> getTabs() {
        AdvancementMain.checkInitialisation();
        return List.copyOf(this.tabs.values());
    }

    public void updateAdvancementsToTeam(@NotNull Player player) throws UserNotLoadedException {
        this.updateAdvancementsToTeam(AdvancementUtils.uuidFromPlayer(player));
    }

    public void updateAdvancementsToTeam(@NotNull UUID uuid) throws UserNotLoadedException {
        this.updateAdvancementsToTeam(this.databaseManager.getTeamProgression(uuid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdvancementsToTeam(@NotNull TeamProgression teamProgression) {
        AdvancementMain.checkInitialisation();
        AdvancementUtils.validateTeamProgression(teamProgression);
        Map<String, AdvancementTab> map = this.tabs;
        synchronized (map) {
            for (AdvancementTab tab : this.tabs.values()) {
                if (!tab.isActive()) continue;
                tab.updateAdvancementsToTeam(teamProgression);
            }
        }
    }

    private static void checkInitialisation() {
        if (!AdvancementMain.isLoaded() || !AdvancementMain.isEnabled()) {
            throw new IllegalStateException("UltimateAdvancementAPI is not enabled.");
        }
    }

    private static boolean isMcReload(@NotNull String command) {
        return command.startsWith("/minecraft:reload") || command.startsWith("minecraft:reload");
    }

    @NotNull
    public Plugin getOwningPlugin() {
        return this.owningPlugin;
    }

    @NotNull
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @NotNull
    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    @NotNull
    public BukkitLibraryManager getLibbyManager() {
        return this.libbyManager;
    }

    public static boolean isLoaded() {
        return LOADED.get() && !INVALID_VERSION.get();
    }

    public static boolean isEnabled() {
        return ENABLED.get();
    }

    @NotNull
    public Logger getLogger() {
        return this.owningPlugin.getLogger();
    }

    public File getDataFolder() {
        return this.owningPlugin.getDataFolder();
    }

    private static void checkSync() {
        if (!Bukkit.isPrimaryThread()) {
            throw new AsyncExecutionException("Illegal async method call. This method can be called only from the main thread.");
        }
    }
}

