/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.nms.v1_21_R6;

import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.VanillaAdvancementDisablerWrapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.simple.SimpleLogger;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.slf4j.Logger;

public class VanillaAdvancementDisablerWrapper_v1_21_R6
extends VanillaAdvancementDisablerWrapper {
    private static org.apache.logging.log4j.Logger LOGGER = null;
    private static Field listener;
    private static Field firstPacket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableVanillaAdvancements(boolean vanillaAdvancements, boolean vanillaRecipeAdvancements) throws Exception {
        ServerAdvancementManager serverAdvancements = ((CraftServer)Bukkit.getServer()).getServer().getAdvancements();
        AdvancementTree tree = serverAdvancements.tree();
        if (serverAdvancements.advancements.isEmpty()) {
            return;
        }
        final HashSet removed = Sets.newHashSetWithExpectedSize((int)serverAdvancements.advancements.size());
        final AdvancementTree.Listener old = (AdvancementTree.Listener)listener.get(tree);
        try {
            listener.set(tree, new AdvancementTree.Listener(){

                public void onAddAdvancementRoot(AdvancementNode advancement) {
                    if (old != null) {
                        old.onAddAdvancementRoot(advancement);
                    }
                }

                public void onRemoveAdvancementRoot(AdvancementNode advancement) {
                    removed.add(advancement.holder().id());
                    if (old != null) {
                        old.onRemoveAdvancementRoot(advancement);
                    }
                }

                public void onAddAdvancementTask(AdvancementNode advancement) {
                    if (old != null) {
                        old.onAddAdvancementTask(advancement);
                    }
                }

                public void onRemoveAdvancementTask(AdvancementNode advancement) {
                    removed.add(advancement.holder().id());
                    if (old != null) {
                        old.onRemoveAdvancementTask(advancement);
                    }
                }

                public void onAdvancementsCleared() {
                    if (old != null) {
                        old.onAdvancementsCleared();
                    }
                }
            });
            HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : serverAdvancements.advancements.entrySet()) {
                ResourceLocation key = (ResourceLocation)entry.getKey();
                boolean isRecipe = key.getPath().startsWith("recipes/");
                if (key.getNamespace().equals("minecraft") && (vanillaAdvancements && !isRecipe || vanillaRecipeAdvancements && isRecipe)) {
                    locations.add(key);
                    continue;
                }
                builder.put((Object)key, (Object)((AdvancementHolder)entry.getValue()));
            }
            serverAdvancements.advancements = builder.buildOrThrow();
            Level oldLevel = VanillaAdvancementDisablerWrapper_v1_21_R6.disableLogger();
            try {
                tree.remove(locations);
            }
            finally {
                VanillaAdvancementDisablerWrapper_v1_21_R6.enableLogger(oldLevel);
            }
        }
        finally {
            listener.set(tree, old);
        }
        ClientboundUpdateAdvancementsPacket removePacket = new ClientboundUpdateAdvancementsPacket(false, Collections.emptyList(), (Set)removed, Collections.emptyMap(), false);
        for (Player player : Bukkit.getOnlinePlayers()) {
            ServerPlayer mcPlayer = ((CraftPlayer)player).getHandle();
            PlayerAdvancements advs = mcPlayer.getAdvancements();
            advs.reload(serverAdvancements);
            firstPacket.setBoolean(advs, false);
            mcPlayer.connection.send((Packet)removePacket);
        }
    }

    private static Level disableLogger() {
        if (LOGGER == null) {
            return null;
        }
        Level old = LOGGER.getLevel();
        org.apache.logging.log4j.Logger logger = LOGGER;
        if (logger instanceof org.apache.logging.log4j.core.Logger) {
            org.apache.logging.log4j.core.Logger coreLogger = (org.apache.logging.log4j.core.Logger)logger;
            coreLogger.setLevel(Level.OFF);
        } else {
            logger = LOGGER;
            if (logger instanceof SimpleLogger) {
                SimpleLogger simple = (SimpleLogger)logger;
                simple.setLevel(Level.OFF);
            }
        }
        return old;
    }

    private static void enableLogger(Level toSet) {
        if (LOGGER == null || toSet == null) {
            return;
        }
        org.apache.logging.log4j.Logger logger = LOGGER;
        if (logger instanceof org.apache.logging.log4j.core.Logger) {
            org.apache.logging.log4j.core.Logger coreLogger = (org.apache.logging.log4j.core.Logger)logger;
            coreLogger.setLevel(toSet);
        } else {
            logger = LOGGER;
            if (logger instanceof SimpleLogger) {
                SimpleLogger simple = (SimpleLogger)logger;
                simple.setLevel(toSet);
            }
        }
    }

    private VanillaAdvancementDisablerWrapper_v1_21_R6() {
        throw new UnsupportedOperationException("Utility class.");
    }

    static {
        try {
            listener = Arrays.stream(AdvancementTree.class.getDeclaredFields()).filter(f -> f.getType() == AdvancementTree.Listener.class).findFirst().orElseThrow();
            listener.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            firstPacket = Arrays.stream(PlayerAdvancements.class.getDeclaredFields()).filter(f -> f.getType() == Boolean.TYPE).findFirst().orElseThrow();
            firstPacket.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Field logger = Arrays.stream(AdvancementTree.class.getDeclaredFields()).filter(f -> f.getType() == Logger.class).findFirst().orElseThrow();
            logger.setAccessible(true);
            Logger slf4jLogger = (Logger)logger.get(null);
            LOGGER = Arrays.stream(slf4jLogger.getClass().getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).map(f -> {
                try {
                    f.setAccessible(true);
                    Object patt0$temp = f.get(slf4jLogger);
                    if (patt0$temp instanceof org.apache.logging.log4j.Logger) {
                        org.apache.logging.log4j.Logger log = (org.apache.logging.log4j.Logger)patt0$temp;
                        return log;
                    }
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElseThrow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

