/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.commands.commandAPI_v11_1_0;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.commands.CommandAPIManager;
import com.fren_gor.ultimateAdvancementAPI.commands.MojangMappingsHandler;
import com.fren_gor.ultimateAdvancementAPI.commands.commandAPI_v11_1_0.UltimateAdvancementAPICommand;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.CommandAPI;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.CommandAPIBukkitConfig;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.CommandAPIConfig;
import com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.RegisteredCommand;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CommandAPIManager
implements CommandAPIManager.ILoadable {
    @Override
    public void onLoad(@NotNull AdvancementMain main, @NotNull JavaPlugin plugin) {
        CommandAPIBukkitConfig config;
        try {
            if (MojangMappingsHandler.isMojangMapped()) {
                Class<?> lifecycleEventOwnerClass = Class.forName("io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner");
                Class<?> paperConfigClass = Class.forName("com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.CommandAPIPaperConfig");
                config = (CommandAPIBukkitConfig)paperConfigClass.getDeclaredConstructor(lifecycleEventOwnerClass).newInstance(plugin);
            } else {
                Class<?> spigotConfigClass = Class.forName("com.fren_gor.ultimateAdvancementAPI.libs.dev.jorel.commandapi.CommandAPISpigotConfig");
                config = (CommandAPIBukkitConfig)spigotConfigClass.getDeclaredConstructor(JavaPlugin.class).newInstance(plugin);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot create CommandAPI config", e);
        }
        CommandAPI.onLoad((CommandAPIConfig)((CommandAPIBukkitConfig)((CommandAPIBukkitConfig)((CommandAPIBukkitConfig)config.verboseOutput(false)).silentLogs(true)).enableNetworking(false)).setNamespace(plugin.getName().toLowerCase(Locale.ENGLISH)));
        new UltimateAdvancementAPICommand(main).register();
    }

    @Override
    public void onEnable() {
        CommandAPI.onEnable();
    }

    @Override
    public void onDisable() {
        if (!MojangMappingsHandler.isMojangMapped()) {
            Stream.concat(CommandAPI.getRegisteredCommands().stream().map(RegisteredCommand::commandName), CommandAPI.getRegisteredCommands().stream().flatMap(cmd -> Arrays.stream(cmd.aliases()))).distinct().forEach(command -> CommandAPI.unregister((String)command, (boolean)true));
        }
        CommandAPI.onDisable();
    }
}

