/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.commands;

import com.fren_gor.ultimateAdvancementAPI.commands.MojangMappingsHandler;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public enum CommandAPIVersion {
    v9_3_0("9.3.0", "commandapi-bukkit-shade", null, "K9cYHoWiGLP8z+cyYb5NIarVE9fzMeJRqHu1UJ+Li/U=", null, "9_3_0", List.of("v1_15_R1", "v1_16_R1", "v1_16_R2", "v1_16_R3")),
    v9_7_0("9.7.0", "commandapi-bukkit-shade", "commandapi-bukkit-shade-mojang-mapped", "q1XHz7oYfdoeous1MOQoP7zopfjdnxMh9Za1ToN0x2s=", "TFSpIzREfb8ChAkZ/sl1Nmk/ACUpuNk5c4PARCFlj80=", "9_7_0", List.of("v1_17_R1", "v1_18_R1", "v1_18_R2", "v1_19_R1", "v1_19_R2", "v1_19_R3")),
    v10_1_2("10.1.2", "commandapi-bukkit-shade", "commandapi-bukkit-shade-mojang-mapped", "vwfO0UPX+wKoOgbv0SLS6YmzBjf0Inkuh6e00LKcekg=", "K1BBUo+b2ZReI2qsuSlWAGmpG0WAyEfDcZOnZS7u6z4=", "10_1_2", List.of("v1_20_R1", "v1_20_R2", "v1_20_R3", "v1_20_R4", "v1_21_R1", "v1_21_R2", "v1_21_R3", "v1_21_R4")),
    LATEST("11.1.0", "commandapi-spigot-shade", "commandapi-paper-shade", "E0rUSMwJKIHP5skpdscHMhq4VslVNnfcxh4QnY8N2Vw=", "WG0DkQHBm8me54fVf5e3lVY+50qwvvOFhApxT+na+Ho=", "11_1_0", List.of("v1_21_R5", "v1_21_R6", "v1_21_R7"));

    private final String version;
    private final String suffix;
    final String artifactId;
    final String mojangMappedArtifactId;
    final String checksum;
    final String mojangMappedChecksum;
    private final List<String> supportedVersions;

    private CommandAPIVersion(@Nullable String version, @NotNull String artifactId, @Nullable String mojangMappedArtifactId, @NotNull String checksum, @NotNull String mojangMappedChecksum, String suffix, List<String> supportedVersions) {
        this.version = Objects.requireNonNull(version, "Version is null.");
        this.artifactId = Objects.requireNonNull(artifactId, "Artifact id is null.");
        this.mojangMappedArtifactId = mojangMappedArtifactId;
        this.checksum = Objects.requireNonNull(checksum, "Checksum is null.");
        this.mojangMappedChecksum = mojangMappedChecksum;
        this.suffix = Objects.requireNonNull(suffix, "Suffix is null.");
        this.supportedVersions = Objects.requireNonNull(supportedVersions, "SupportedVersions is null.");
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public String getArtifactId() {
        String artifactId = MojangMappingsHandler.isMojangMapped() ? this.mojangMappedArtifactId : this.artifactId;
        Preconditions.checkArgument((artifactId != null ? 1 : 0) != 0, (Object)("CommandAPI " + this.version + " doesn't support Mojang mappings."));
        return artifactId;
    }

    @NotNull
    public String getChecksum() {
        String checksum = MojangMappingsHandler.isMojangMapped() ? this.mojangMappedChecksum : this.checksum;
        Preconditions.checkArgument((checksum != null ? 1 : 0) != 0, (Object)("CommandAPI " + this.version + " doesn't support Mojang mappings."));
        return checksum;
    }

    @NotNull
    public String getClasspathSuffix() {
        return this.suffix;
    }

    public @Unmodifiable @NotNull List<String> getSupportedVersions() {
        return this.supportedVersions;
    }

    @Nullable
    public static CommandAPIVersion getVersionToLoad(String nms) {
        for (CommandAPIVersion v : CommandAPIVersion.values()) {
            if (!v.supportedVersions.contains(nms)) continue;
            return v;
        }
        return null;
    }
}

