/*
 * Decompiled with CFR 0.152.
 */
package me.dergamer09.bungeesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Base64;
import me.dergamer09.bungeesystem.commands.BlockBungeeCommand;
import me.dergamer09.bungeesystem.commands.FindCommand;
import me.dergamer09.bungeesystem.commands.JoinMeCommand;
import me.dergamer09.bungeesystem.commands.ListCommand;
import me.dergamer09.bungeesystem.commands.OnlineTimeCommand;
import me.dergamer09.bungeesystem.commands.PingCommand;
import me.dergamer09.bungeesystem.commands.PlayCommand;
import me.dergamer09.bungeesystem.commands.ServerListCommand;
import me.dergamer09.bungeesystem.commands.TeamChatCommand;
import me.dergamer09.bungeesystem.commands.ToggleNotifyCommand;
import me.dergamer09.bungeesystem.commands.VanishCommand;
import me.dergamer09.bungeesystem.listeners.PlayerEventListener;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public final class BungeeSystem
extends Plugin {
    private final String prefix = ChatColor.DARK_GRAY + "| " + ChatColor.RED + "\u1d0d\u026a\u0274\u1d07\u1d04\u1d0f\ua731\u026a\u1d00 " + ChatColor.GRAY + "\u00bb ";
    private String webhookUrl;
    private final String currentVersion = "1.1.5-BETA";
    private final String jenkinsApiUrl = "https://dergamer09.at/job/BungeeSystem/lastSuccessfulBuild/api/json";
    private Configuration config;
    private File configFile;
    private static BungeeSystem instance;
    private Connection connection;

    public void onEnable() {
        this.loadConfig();
        if (this.getConfig() == null) {
            this.getLogger().severe("Config file could not be loaded! Disabling plugin...");
            return;
        }
        PluginManager pm = this.getProxy().getPluginManager();
        pm.registerCommand((Plugin)this, (Command)new TeamChatCommand());
        pm.registerCommand((Plugin)this, (Command)new JoinMeCommand("joinme", "bungeesystem.joinme.use"));
        pm.registerCommand((Plugin)this, (Command)new PingCommand());
        pm.registerCommand((Plugin)this, (Command)new ServerListCommand());
        pm.registerCommand((Plugin)this, (Command)new FindCommand());
        pm.registerCommand((Plugin)this, (Command)new VanishCommand());
        pm.registerCommand((Plugin)this, (Command)new PlayCommand());
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new LobbyCommand("l"));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new LobbyCommand("lobby"));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new LobbyCommand("hub"));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BlockBungeeCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ReportCommand());
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ListCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ToggleNotifyCommand());
        OnlineTimeCommand onlineTimeCommand = new OnlineTimeCommand(this);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)onlineTimeCommand);
        this.webhookUrl = this.getConfig().getString("webhookUrl");
        this.getLogger().info("Discord Webhook URL: " + this.webhookUrl);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PlayerEventListener(this));
        instance = this;
        this.connectToDatabase();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.getLogger().info(this.prefix + ChatColor.GRAY + "-------------------------------------");
        this.getLogger().info(this.prefix + ChatColor.GREEN + "Plugin wurde erfolgreich gestartet!");
        this.getLogger().info(this.prefix + ChatColor.DARK_AQUA + "Plugin by DerGamer09");
        this.getLogger().info(this.prefix + ChatColor.DARK_AQUA + "Version " + "1.1.5-BETA");
        this.getLogger().info(this.prefix + ChatColor.GRAY + "-------------------------------------");
        this.checkForUpdates();
    }

    public void onDisable() {
        this.closeDatabaseConnection();
    }

    private void checkForUpdates() {
        try {
            URL url = new URL("https://dergamer09.at/job/BungeeSystem/lastSuccessfulBuild/api/json");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            String userCredentials = "dergamer09:112f9f6cfeecac7c9f5a2ca09df155280e";
            String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userCredentials.getBytes()));
            connection.setRequestProperty("Authorization", basicAuth);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                in.close();
                connection.disconnect();
                String jsonResponse = content.toString();
                String latestVersion = this.extractVersionFromJson(jsonResponse);
                if (latestVersion != null) {
                    if (!"1.1.5-BETA".equals(latestVersion)) {
                        this.getLogger().warning(ChatColor.YELLOW + "Ein neues Update ist verf\u00fcgbar: " + latestVersion + " (aktuelle Version: " + "1.1.5-BETA" + ")");
                    } else if (this.isSameSnapshot(latestVersion)) {
                        this.getLogger().info(ChatColor.GREEN + "Dein Plugin ist auf dem neuesten Stand.");
                    } else {
                        this.getLogger().warning(ChatColor.YELLOW + "Es gibt ein neues Snapshot-Build: " + latestVersion + " (aktuelles Build: " + "1.1.5-BETA" + ")");
                    }
                } else {
                    this.getLogger().severe(ChatColor.RED + "Fehler beim Extrahieren der Versionsinformation.");
                }
            } else {
                this.getLogger().severe(ChatColor.RED + "Fehler beim Abrufen der Versionsinformation. HTTP Fehlercode: " + responseCode);
            }
        }
        catch (Exception e) {
            this.getLogger().severe(ChatColor.RED + "Fehler beim \u00dcberpr\u00fcfen auf Updates: " + e.getMessage());
        }
    }

    private boolean isSameSnapshot(String latestVersion) {
        return "1.1.5-BETA".equals(latestVersion);
    }

    private String extractVersionFromJson(String jsonResponse) {
        try {
            int index = jsonResponse.indexOf("\"displayName\":\"");
            if (index != -1) {
                int start = index + 14;
                int end = jsonResponse.indexOf("\"", start);
                return jsonResponse.substring(start, end);
            }
        }
        catch (Exception e) {
            this.getLogger().severe(ChatColor.RED + "Fehler beim Extrahieren der Version aus der JSON-Antwort: " + e.getMessage());
        }
        return null;
    }

    private void loadConfig() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.configFile = new File(this.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            try (InputStream in = this.getResourceAsStream("config.yml");){
                if (in != null) {
                    Files.copy(in, this.configFile.toPath(), new CopyOption[0]);
                } else {
                    this.getLogger().severe("Could not find config.yml inside the plugin jar!");
                }
            }
            catch (IOException e) {
                this.getLogger().severe("Error creating config.yml: " + e.getMessage());
            }
        }
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.configFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Error loading config.yml: " + e.getMessage());
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getPrefix() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("prefix"));
    }

    public String getDefaultMessageColor() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("defaultMessageColor"));
    }

    public String getUpdateMessageColor() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("updateMessageColor"));
    }

    public String getSuccessMessageColor() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("successMessageColor"));
    }

    public String getErrorMessageColor() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("errorMessageColor"));
    }

    private String joinArray(String[] array, int start, int end) {
        StringBuilder result = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(array[i]);
        }
        return result.toString();
    }

    public static BungeeSystem getInstance() {
        return instance;
    }

    public Connection getConnection() {
        return this.connection;
    }

    private void connectToDatabase() {
        String host = this.config.getString("mysql.host");
        String port = this.config.getString("mysql.port");
        String database = this.config.getString("mysql.database");
        String username = this.config.getString("mysql.username");
        String password = this.config.getString("mysql.password");
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
        try {
            this.connection = DriverManager.getConnection(url, username, password);
            this.getLogger().info("MySQL connection established.");
        }
        catch (SQLException e) {
            this.getLogger().severe("MySQL connection failed: " + e.getMessage());
        }
    }

    private void closeDatabaseConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.getLogger().info("MySQL connection closed.");
            }
            catch (SQLException e) {
                this.getLogger().severe("Failed to close MySQL connection: " + e.getMessage());
            }
        }
    }

    public class LobbyCommand
    extends Command {
        public LobbyCommand(String name) {
            super(name);
        }

        public void execute(CommandSender sender, String[] args) {
            if (!(sender instanceof ProxiedPlayer)) {
                sender.sendMessage(BungeeSystem.this.prefix + ChatColor.RED + "Dieser Befehl kann nur von einem Spieler ausgef\u00fchrt werden.");
                return;
            }
            ProxiedPlayer player = (ProxiedPlayer)sender;
            ServerInfo lobby = BungeeSystem.this.getProxy().getServerInfo("Lobby");
            if (lobby != null) {
                player.connect(lobby);
                player.sendMessage(BungeeSystem.this.prefix + ChatColor.GREEN + "Du wirst zur" + ChatColor.YELLOW + " Lobby" + ChatColor.GREEN + " teleportiert...");
            } else {
                player.sendMessage(BungeeSystem.this.prefix + ChatColor.RED + "Die" + ChatColor.YELLOW + " Lobby" + ChatColor.RED + " ist derzeit nicht verf\u00fcgbar.");
            }
        }
    }

    public class ReportCommand
    extends Command {
        public ReportCommand() {
            super("report");
        }

        public void execute(CommandSender sender, String[] args) {
            if (!(sender instanceof ProxiedPlayer)) {
                sender.sendMessage(BungeeSystem.this.prefix + ChatColor.RED + "Dieser Befehl kann nur von einem Spieler ausgef\u00fchrt werden.");
                return;
            }
            ProxiedPlayer player = (ProxiedPlayer)sender;
            if (args.length < 2) {
                player.sendMessage(BungeeSystem.this.prefix + ChatColor.GRAY + "/report" + ChatColor.DARK_AQUA + " <Spieler>" + ChatColor.DARK_AQUA + " <Grund>");
                return;
            }
            String reportedPlayer = args[0];
            String reason = BungeeSystem.this.joinArray(args, 1, args.length);
            player.sendMessage(BungeeSystem.this.prefix + ChatColor.GREEN + "Danke f\u00fcr deinen " + ChatColor.YELLOW + "Report! " + ChatColor.GREEN + "Wir werden den Fall pr\u00fcfen.");
            this.sendReportToDiscord(player.getName(), reportedPlayer, reason);
        }

        private void sendReportToDiscord(String reporter, String reportedPlayer, String reason) {
            try {
                URL url = new URL(BungeeSystem.this.webhookUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                String jsonPayload = String.format("{\"content\": null, \"embeds\": [{\"title\": \"Neuer Report\",\"color\": 14177041,\"fields\": [{\"name\": \"Reporter\",\"value\": \"%s\",\"inline\": true},{\"name\": \"Gemeldeter Spieler\",\"value\": \"%s\",\"inline\": true},{\"name\": \"Grund\",\"value\": \"%s\",\"inline\": false}]}]}", reporter, reportedPlayer, reason);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(jsonPayload.getBytes());
                    os.flush();
                }
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    System.err.println(BungeeSystem.this.prefix + ChatColor.RED + "Fehler beim Senden des Reports. HTTP Fehlercode: " + responseCode);
                }
                connection.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

