/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.hologram;

import com.github.devcyntrix.hologram.NativeHologramTextLine;
import com.github.devcyntrix.hologram.api.Hologram;
import com.github.devcyntrix.hologram.api.HologramService;
import com.github.devcyntrix.hologram.api.HologramTextLine;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class NativeHologram
implements Hologram {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final HologramService service;
    private final double lineHeight;
    @NotNull
    private Location location;
    private final List<NativeHologramTextLine> list = new ArrayList<NativeHologramTextLine>();

    public NativeHologram(@NotNull JavaPlugin plugin, @NotNull HologramService service, @NotNull Location location, double lineHeight) {
        Preconditions.checkNotNull((Object)plugin);
        Preconditions.checkNotNull((Object)service);
        Preconditions.checkNotNull((Object)location);
        this.plugin = plugin;
        this.service = service;
        this.location = location;
        this.lineHeight = lineHeight;
    }

    @Override
    @NotNull
    public Location getLocation() {
        return this.location.clone();
    }

    @Override
    public void teleport(@NotNull Location location) {
        for (NativeHologramTextLine line : this.list) {
            Location oldPos = line.getLocation().clone();
            Location diff = oldPos.subtract(this.location.clone());
            line.teleport(location.clone().add(diff));
        }
        this.location = location;
    }

    @Override
    public HologramTextLine appendLine(@NotNull String line) {
        this.list.forEach(lineRef -> lineRef.teleport(lineRef.getLocation().add(0.0, this.lineHeight, 0.0)));
        NativeHologramTextLine l = new NativeHologramTextLine((Plugin)this.plugin, this.location.clone(), line);
        this.list.add(l);
        return l;
    }

    @Override
    public void delete() {
        this.list.forEach(NativeHologramTextLine::remove);
        this.list.clear();
    }

    @Override
    @NotNull
    public HologramService getService() {
        return this.service;
    }
}

