/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.view.chest;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.ChestView;
import com.github.devcyntrix.deathchest.config.ParticleOptions;
import com.github.devcyntrix.deathchest.tasks.ParticleRunnable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ParticleView
implements ChestView {
    private final DeathChestPlugin plugin;
    private final ParticleOptions options;

    public ParticleView(DeathChestPlugin plugin, ParticleOptions options) {
        this.plugin = plugin;
        this.options = options;
    }

    @Override
    public void onCreate(DeathChestModel model) {
        if (this.plugin.isTest()) {
            return;
        }
        World world = model.getWorld();
        if (world == null) {
            return;
        }
        Particle.DustOptions orangeDustOptions = new Particle.DustOptions(Color.ORANGE, 0.75f);
        Particle.DustOptions aquaDustOptions = new Particle.DustOptions(Color.AQUA, 0.75f);
        this.plugin.debug(0, new Object[]{"Starting particle runner..."});
        BukkitTask bukkitTask = new ParticleRunnable(model.getLocation(), this.options.count(), this.options.radius(), particleLocation -> {
            Location orangeDust = particleLocation.clone().add(0.5, 0.5, 0.5);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> world.spawnParticle(Particle.REDSTONE, orangeDust, 1, (Object)orangeDustOptions));
            Location aquaDust = orangeDust.clone().subtract(0.0, 0.1, 0.0);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> world.spawnParticle(Particle.REDSTONE, aquaDust, 1, (Object)aquaDustOptions));
        }).runTaskTimerAsynchronously(this.plugin, 0L, (long)(20.0 / this.options.speed()));
        model.getTasks().add(() -> ((BukkitTask)bukkitTask).cancel());
    }

    @Override
    public void onDestroy(DeathChestModel model) {
    }

    @Override
    public void onLoad(DeathChestModel model) {
        this.onCreate(model);
    }

    @Override
    public void onUnload(DeathChestModel model) {
    }
}

