/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.view.chest;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.ChestView;
import com.github.devcyntrix.deathchest.config.HologramOptions;
import com.github.devcyntrix.deathchest.controller.HologramController;
import com.github.devcyntrix.deathchest.controller.PlaceholderController;
import com.github.devcyntrix.deathchest.tasks.HologramRunnable;
import com.github.devcyntrix.hologram.api.Hologram;
import com.github.devcyntrix.hologram.api.HologramTextLine;
import java.util.LinkedHashMap;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.scheduler.BukkitTask;

public class HologramView
implements ChestView {
    private final DeathChestPlugin plugin;
    private final HologramController controller;
    private final HologramOptions options;
    private final PlaceholderController placeHolderController;

    public HologramView(DeathChestPlugin plugin, HologramController controller, HologramOptions options, PlaceholderController placeHolderController) {
        this.plugin = plugin;
        this.controller = controller;
        this.options = options;
        this.placeHolderController = placeHolderController;
    }

    @Override
    public void onCreate(DeathChestModel model) {
        Chunk chunk = model.getLocation().getChunk();
        boolean loaded = chunk.isLoaded();
        if (!loaded) {
            chunk.load();
        }
        Location holoPos = model.getLocation().clone().add(0.5, this.options.height(), 0.5);
        Hologram hologram = this.controller.spawnHologram(holoPos, this.options.lineHeight());
        model.setHologram(hologram);
        LinkedHashMap<HologramTextLine, String> blueprints = new LinkedHashMap<HologramTextLine, String>(this.options.lines().size());
        this.options.lines().forEach(line -> blueprints.put(hologram.appendLine(this.placeHolderController.replace(model, (String)line)), (String)line));
        if (blueprints.isEmpty()) {
            return;
        }
        this.plugin.debug(0, new Object[]{"Starting hologram updater..."});
        BukkitTask bukkitTask = new HologramRunnable(this.plugin, model, blueprints, this.placeHolderController).runTaskTimerAsynchronously(this.plugin, 20L, 20L);
        model.getTasks().add(() -> ((BukkitTask)bukkitTask).cancel());
        if (!loaded) {
            chunk.unload();
        }
    }

    @Override
    public void onDestroy(DeathChestModel model) {
        Hologram hologram = model.getHologram();
        if (hologram == null) {
            return;
        }
        Chunk chunk = hologram.getLocation().getChunk();
        boolean loaded = chunk.isLoaded();
        if (!loaded) {
            chunk.load();
        }
        hologram.delete();
        if (!loaded) {
            chunk.unload();
        }
        model.setHologram(null);
    }

    @Override
    public void onLoad(DeathChestModel model) {
        this.onCreate(model);
    }

    @Override
    public void onUnload(DeathChestModel model) {
        this.onDestroy(model);
    }
}

