/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.view.chest;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.api.ChestView;
import java.util.ArrayList;
import java.util.logging.Level;
import org.bukkit.entity.HumanEntity;
import org.bukkit.plugin.java.JavaPlugin;

public class CloseInventoryView
implements ChestView {
    private final JavaPlugin plugin;

    public CloseInventoryView(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onCreate(DeathChestModel model) {
    }

    @Override
    public void onDestroy(DeathChestModel model) {
        if (model.getInventory() == null) {
            return;
        }
        try {
            ArrayList humanEntities = new ArrayList(model.getInventory().getViewers());
            humanEntities.forEach(HumanEntity::closeInventory);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to close inventories of viewers.", e);
        }
    }

    @Override
    public void onLoad(DeathChestModel model) {
        this.onCreate(model);
    }

    @Override
    public void onUnload(DeathChestModel model) {
        this.onDestroy(model);
    }
}

