/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.view.chest;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.ChestView;
import com.github.devcyntrix.deathchest.api.animation.BreakAnimationService;
import com.github.devcyntrix.deathchest.config.BreakAnimationOptions;
import com.github.devcyntrix.deathchest.tasks.BreakAnimationRunnable;
import com.github.devcyntrix.deathchest.util.EntityIdHelper;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakAnimationView
implements ChestView {
    @NotNull
    private final DeathChestPlugin plugin;
    @Nullable
    private final BreakAnimationService service;
    @NotNull
    private final BreakAnimationOptions options;

    public BreakAnimationView(@NotNull DeathChestPlugin plugin, @Nullable BreakAnimationService service, @NotNull BreakAnimationOptions options) {
        this.plugin = plugin;
        this.service = service;
        this.options = options;
    }

    @Override
    public void onCreate(DeathChestModel model) {
        if (this.service == null) {
            return;
        }
        model.setBreakingEntityId(EntityIdHelper.increaseAndGet());
        this.plugin.debug(0, new Object[]{"Starting block break animation using entity id %d".formatted(model.getBreakingEntityId())});
        BukkitTask bukkitTask = new BreakAnimationRunnable(this.plugin, model, this.service, this.options).runTaskTimerAsynchronously(this.plugin, 20L, 20L);
        model.getTasks().add(() -> ((BukkitTask)bukkitTask).cancel());
    }

    @Override
    public void onDestroy(DeathChestModel model) {
        if (this.service == null) {
            return;
        }
        Integer breakingId = model.getBreakingEntityId();
        if (breakingId == null) {
            return;
        }
        try {
            World world;
            if (model.isExpiring() && (world = model.getWorld()) != null) {
                Stream<Player> playerStream = model.getWorld().getNearbyEntities(model.getLocation(), 20.0, 20.0, 20.0, entity -> entity.getType() == EntityType.PLAYER).stream().map(entity -> (Player)entity);
                this.service.spawnBlockBreakAnimation(breakingId, model.getLocation().toVector(), -1, playerStream);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to reset the block animation of all players in the area", e);
        }
        model.setBreakingEntityId(null);
    }

    @Override
    public void onLoad(DeathChestModel model) {
        this.onCreate(model);
    }

    @Override
    public void onUnload(DeathChestModel model) {
        this.onDestroy(model);
    }
}

