/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.view.chest;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.ChestView;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BlockView
implements ChestView,
Listener {
    private final DeathChestPlugin plugin;

    public BlockView(DeathChestPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onCreate(final DeathChestModel model) {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                BlockView.this.plugin.debug(0, new Object[]{"Creating death chest block..."});
                Location location = model.getLocation();
                BlockState state = location.getBlock().getState();
                model.setPrevious(state);
                location.getBlock().setType(Material.CHEST);
            }
        }.runTask((Plugin)this.plugin);
        model.getTasks().add(() -> ((BukkitTask)bukkitTask).cancel());
    }

    @Override
    public void onDestroy(DeathChestModel model) {
        try {
            World world = model.getWorld();
            if (world != null) {
                this.plugin.debug(0, new Object[]{"Spawning block crack particle..."});
                Location location = model.getLocation();
                Block block = location.getBlock();
                if (!this.plugin.isTest()) {
                    world.spawnParticle(Particle.BLOCK_CRACK, location.clone().add(0.5, 0.5, 0.5), 10, (Object)block.getBlockData());
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to play block crack particle", e);
        }
        if (model.getPrevious() == null) {
            return;
        }
        this.plugin.debug(0, new Object[]{"Resetting the death chest block..."});
        model.getPrevious().update(true, false);
    }

    @Override
    public void onLoad(DeathChestModel model) {
        this.onCreate(model);
    }

    @Override
    public void onUnload(DeathChestModel model) {
        this.onDestroy(model);
    }
}

