/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.util.update;

import com.github.devcyntrix.deathchest.util.update.UpdateChecker;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.logging.Level;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HangarUpdateChecker
implements UpdateChecker {
    private final JavaPlugin plugin;

    public HangarUpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public String getLatestRelease() {
        PluginDescriptionFile description = this.plugin.getDescription();
        try (InputStream inputStream = new URL("https://hangar.papermc.io/api/v1/projects/%s/latestrelease".formatted(description.getName())).openStream();){
            Scanner scanner;
            block15: {
                scanner = new Scanner(inputStream);
                try {
                    if (scanner.hasNext()) break block15;
                    String string = null;
                    scanner.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            String string = scanner.next();
            scanner.close();
            return string;
        }
        catch (IOException exception) {
            this.plugin.getLogger().info("Unable to check for updates: " + exception.getMessage());
            this.plugin.getLogger().info("To disable this message set the update checker to false in the config.yml");
            return null;
        }
    }

    @Override
    @Nullable
    public InputStream download(@NotNull String version) {
        Preconditions.checkNotNull((Object)version, (Object)"version");
        PluginDescriptionFile description = this.plugin.getDescription();
        try {
            return new URL("https://hangar.papermc.io/api/v1/projects/%s/versions/%s/PAPER/download".formatted(description.getName(), version)).openStream();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to download the newest version", e);
            return null;
        }
    }
}

