/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.util.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationAdapter
implements JsonSerializer<Location>,
JsonDeserializer<Location> {
    public Location deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject object = json.getAsJsonObject();
        World world = null;
        if (object.has("world")) {
            String worldName = object.get("world").getAsString();
            world = Bukkit.getWorld((String)worldName);
        }
        double x = object.get("x").getAsDouble();
        double y = object.get("y").getAsDouble();
        double z = object.get("z").getAsDouble();
        float yaw = 0.0f;
        if (object.has("yaw")) {
            yaw = object.get("yaw").getAsFloat();
        }
        float pitch = 0.0f;
        if (object.has("pitch")) {
            pitch = object.get("pitch").getAsFloat();
        }
        return new Location(world, x, y, z, yaw, pitch);
    }

    public JsonElement serialize(Location src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject object = new JsonObject();
        if (src.getWorld() != null) {
            object.addProperty("world", src.getWorld().getName());
        }
        object.addProperty("x", (Number)src.getX());
        object.addProperty("y", (Number)src.getY());
        object.addProperty("z", (Number)src.getZ());
        if (src.getYaw() != 0.0f) {
            object.addProperty("yaw", (Number)Float.valueOf(src.getYaw()));
        }
        if (src.getPitch() != 0.0f) {
            object.addProperty("pitch", (Number)Float.valueOf(src.getPitch()));
        }
        return object;
    }
}

