/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.util.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemStackAdapter
implements JsonDeserializer<ItemStack>,
JsonSerializer<ItemStack> {
    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Map deserialize = (Map)context.deserialize(json, Map.class);
        deserialize.computeIfPresent("meta", (s, o) -> {
            Map meta = (Map)o;
            meta.replaceAll((s1, o1) -> {
                if (o1 instanceof Number) {
                    return ((Number)o1).intValue();
                }
                return o1;
            });
            meta.computeIfPresent("enchants", (s1, enchantsMap) -> {
                Map enchants = (Map)enchantsMap;
                enchants.replaceAll((s2, o1) -> ((Number)o1).intValue());
                return enchantsMap;
            });
            Material material = Material.getMaterial((String)deserialize.get("type").toString());
            ItemStack stack = new ItemStack(material);
            Class aClass = Arrays.stream(stack.getItemMeta().getClass().getClasses()).filter(memberClass -> memberClass.getSimpleName().equals("SerializableMeta")).findFirst().orElse(null);
            try {
                Method deserializeMethod = aClass.getMethod("deserialize", Map.class);
                return deserializeMethod.invoke(null, meta);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
        return ItemStack.deserialize((Map)deserialize);
    }

    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        Map serialize = src.serialize();
        return context.serialize((Object)serialize, Map.class);
    }
}

