/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.util.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;

public class CommandSenderAdapter
implements JsonSerializer<CommandSender> {
    public JsonElement serialize(CommandSender src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("name", src.getName());
        object.addProperty("op", Boolean.valueOf(src.isOp()));
        if (src instanceof Entity) {
            Entity e = (Entity)src;
            object.add("id", context.serialize((Object)e.getUniqueId()));
            object.addProperty("entity-id", (Number)e.getEntityId());
            object.add("location", context.serialize((Object)e.getLocation()));
        } else if (src instanceof BlockCommandSender) {
            BlockCommandSender e = (BlockCommandSender)src;
            object.add("location", context.serialize((Object)e.getBlock().getLocation()));
            object.addProperty("type", e.getBlock().getBlockData().getAsString());
        }
        return object;
    }
}

