/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.tasks;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.animation.BreakAnimationService;
import com.github.devcyntrix.deathchest.config.BreakAnimationOptions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BreakAnimationRunnable
extends BukkitRunnable {
    private final DeathChestPlugin plugin;
    private final DeathChestModel chest;
    private final BreakAnimationService breakAnimationService;
    private final BreakAnimationOptions options;

    public BreakAnimationRunnable(DeathChestPlugin plugin, DeathChestModel chest, BreakAnimationService breakAnimationService, BreakAnimationOptions options) {
        this.plugin = plugin;
        this.chest = chest;
        this.breakAnimationService = breakAnimationService;
        this.options = options;
    }

    public void run() {
        Integer entityId = this.chest.getBreakingEntityId();
        if (entityId == null) {
            this.cancel();
            return;
        }
        World world = this.chest.getWorld();
        if (world == null) {
            this.cancel();
            return;
        }
        double process = (double)(System.currentTimeMillis() - this.chest.getCreatedAt()) / (double)(this.chest.getExpireAt() - this.chest.getCreatedAt());
        try {
            Stream playerStream = (Stream)Bukkit.getScheduler().callSyncMethod((Plugin)this.plugin, () -> world.getNearbyEntities(this.chest.getLocation(), this.options.viewDistance(), this.options.viewDistance(), this.options.viewDistance(), entity -> entity.getType() == EntityType.PLAYER).stream().map(entity -> (Player)entity)).get(1L, TimeUnit.SECONDS);
            this.breakAnimationService.spawnBlockBreakAnimation(entityId, this.chest.getLocation().toVector(), (int)(9.0 * process), playerStream);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().warning("Warning: Getting nearby entities took longer than 1 second.");
            }
        }
        catch (InterruptedException e) {
            this.cancel();
        }
    }
}

