/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.support.storage;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.api.storage.DeathChestStorage;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class YamlStorage
implements DeathChestStorage {
    private final Multimap<World, DeathChestModel> deathChestsCache = HashMultimap.create();

    @Override
    public ConfigurationSection getDefaultOptions() {
        return new MemoryConfiguration();
    }

    private File getFile(World world, boolean create) throws IOException {
        File worldFolder = world.getWorldFolder();
        File file = new File(worldFolder, "death-chests.yml");
        if (create && !file.isFile() && !file.createNewFile()) {
            throw new IOException("Failed to create file \"%s\"".formatted(file));
        }
        return file;
    }

    private void migrateChests(DeathChestPlugin plugin, File[] files, Logger logger) {
        logger.info("Starting death chest migration...");
        for (File file : files) {
            String name = file.getName();
            String realName = name.substring(0, name.lastIndexOf(46));
            World world = Bukkit.getWorld((String)realName);
            if (world == null) continue;
            try {
                File newLocation = this.getFile(world, false);
                if (file.renameTo(newLocation)) continue;
                logger.severe("Failed to move the file \"" + String.valueOf(file) + "\" to \"" + String.valueOf(newLocation) + "\".");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void init(@NotNull DeathChestPlugin plugin, @NotNull ConfigurationSection section) throws IOException {
        Logger logger = plugin.getLogger();
        String filename = section.getString("folder", "chests");
        File chestsFolder = new File(plugin.getDataFolder(), filename);
        File[] files = chestsFolder.listFiles();
        if (files != null) {
            this.migrateChests(plugin, files, logger);
            files = chestsFolder.listFiles();
            if (files != null && files.length == 0 && !chestsFolder.delete()) {
                logger.info("Failed to delete old \"" + String.valueOf(chestsFolder) + "\" folder");
            }
        }
        for (World world : Bukkit.getWorlds()) {
            File worldFile = this.getFile(world, false);
            if (!worldFile.isFile()) continue;
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)worldFile);
            List chests = configuration.getList("chests", Collections.emptyList());
            Set list = chests.stream().map(map -> DeathChestModel.deserialize(map, plugin.getDeathChestConfig().inventoryOptions(), plugin.getPlaceHolderController())).filter(Objects::nonNull).collect(Collectors.toSet());
            this.deathChestsCache.putAll((Object)world, list);
        }
    }

    @Override
    public void put(DeathChestModel chest) {
        this.deathChestsCache.put((Object)chest.getWorld(), (Object)chest);
    }

    @Override
    public void update(Collection<DeathChestModel> chests) {
        for (DeathChestModel chest : chests) {
            this.deathChestsCache.put((Object)chest.getWorld(), (Object)chest);
        }
    }

    @Override
    public Set<DeathChestModel> getChests() {
        return new HashSet<DeathChestModel>(this.deathChestsCache.values());
    }

    @Override
    public Set<DeathChestModel> getChests(@NotNull World world) {
        return new HashSet<DeathChestModel>(this.deathChestsCache.get((Object)world));
    }

    @Override
    public void remove(@NotNull DeathChestModel chest) {
        this.deathChestsCache.remove((Object)chest.getWorld(), (Object)chest);
    }

    @Override
    public void close() throws IOException {
        for (World world : Bukkit.getWorlds()) {
            File worldFile = this.getFile(world, true);
            List collect = this.deathChestsCache.get((Object)world).stream().map(DeathChestModel::serialize).collect(Lists::newArrayList, List::add, List::addAll);
            YamlConfiguration configuration = new YamlConfiguration();
            configuration.set("chests", (Object)collect);
            configuration.save(worldFile);
        }
    }
}

