/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.support.protection;

import com.github.devcyntrix.deathchest.api.protection.ProtectionService;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.PlaceFlag;
import com.plotsquared.core.plot.flag.types.BlockTypeWrapper;
import com.plotsquared.core.util.Permissions;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlotSquaredProtection
implements ProtectionService {
    @Override
    public boolean canBuild(@NotNull Player player, @NotNull org.bukkit.Location loc, @NotNull Material material) {
        Location location = BukkitUtil.adapt((org.bukkit.Location)loc);
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return true;
        }
        BukkitPlayer pp = BukkitUtil.adapt((Player)player);
        Plot plot = area.getPlot(location);
        if (plot != null) {
            if (!(location.getY() < area.getMaxBuildHeight() && location.getY() >= area.getMinBuildHeight() || Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_HEIGHT_LIMIT))) {
                return false;
            }
            if (!plot.hasOwner()) {
                return Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_UNOWNED);
            }
            if (!plot.isAdded(pp.getUUID())) {
                List place = (List)plot.getFlag(PlaceFlag.class);
                if (place.contains(BlockTypeWrapper.get((BlockType)BukkitAdapter.asBlockType((Material)material)))) {
                    return true;
                }
                return Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER);
            }
            if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot)) {
                return Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER);
            }
        } else {
            return Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_ROAD);
        }
        return true;
    }
}

