/*
 * Decompiled with CFR 0.152.
 */
package com.github.devcyntrix.deathchest.support.placeholder;

import com.github.devcyntrix.deathchest.DeathChestModel;
import com.github.devcyntrix.deathchest.DeathChestPlugin;
import com.github.devcyntrix.deathchest.config.DeathChestConfig;
import java.util.Collections;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LastDeathChestLocationExpansion
extends PlaceholderExpansion {
    public final DeathChestPlugin plugin;
    private final String locationFormat;
    private final String fallbackMessage;

    public LastDeathChestLocationExpansion(DeathChestPlugin plugin) {
        this.plugin = plugin;
        this.locationFormat = this.getString("location_format", "<x> <y> <z> <world>");
        this.fallbackMessage = this.getString("fallback_message", "&cChest not found");
    }

    @NotNull
    public String getIdentifier() {
        return this.plugin.getDescription().getName();
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @NotNull
    public List<String> getPlaceholders() {
        return Collections.singletonList("last_location");
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (player != null && player.isOnline()) {
            return this.onPlaceholderRequest(player.getPlayer(), params);
        }
        return this.onPlaceholderRequest(null, params);
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        if (player == null) {
            return null;
        }
        DeathChestModel deathChest = this.plugin.getLastChest(player);
        if (deathChest == null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)this.fallbackMessage);
        }
        if (params.equalsIgnoreCase("last_location")) {
            Location location = deathChest.getLocation();
            String locationFormat = this.locationFormat.replace("<x>", String.valueOf(location.getBlockX())).replace("<y>", String.valueOf(location.getBlockY())).replace("<z>", String.valueOf(location.getBlockZ()));
            if (location.getWorld() != null) {
                DeathChestConfig config = this.plugin.getDeathChestConfig();
                locationFormat = locationFormat.replace("<world>", config.worldAlias().getAlias(location.getWorld().getName()));
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)locationFormat);
        }
        return null;
    }
}

